/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250CrtCtrl;
import net.infordata.em.crt5250.XI5250CrtFrame;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250EmulatorAdapter;
import net.infordata.em.tn5250.XI5250EmulatorCtrl;
import net.infordata.em.tn5250.XI5250EmulatorEvent;
import net.infordata.em.tn5250.XIImagesBdl;
import net.infordata.em.util.XIUtil;

public class XI5250Frame
extends XI5250CrtFrame {
    private static final long serialVersionUID = 1L;
    private static XIImagesBdl cvImagesBdl = XIImagesBdl.getImagesBdl();
    private static ResourceBundle cvRes = ResourceBundle.getBundle("net.infordata.em.tn5250.resources.Res");
    private final String ivTitle;

    public XI5250Frame(String aTitle, XI5250Emulator aCrt) {
        super(aTitle, aCrt);
        this.ivTitle = aTitle;
        this.init(aCrt);
    }

    public XI5250Frame(String aTitle, XI5250Emulator aCrt, boolean dspToolBar, boolean dspMenuBar) {
        super(aTitle, aCrt, dspToolBar, dspMenuBar);
        this.ivTitle = aTitle;
        this.init(aCrt);
    }

    public XI5250Frame(String aTitle, XI5250Emulator aCrt, boolean sizeControlledFrame, boolean dspToolBar, boolean dspMenuBar) {
        super(aTitle, aCrt, sizeControlledFrame, dspToolBar, dspMenuBar);
        this.ivTitle = aTitle;
        this.init(aCrt);
    }

    private void init(XI5250Emulator aCrt) {
        if (aCrt.isActive()) {
            this.setTitle(this.ivTitle + " - " + aCrt.getHost());
        }
        aCrt.addEmulatorListener(new XI5250EmulatorAdapter(){

            @Override
            public void connected(XI5250EmulatorEvent e) {
                XI5250Frame.this.setTitle(XI5250Frame.this.ivTitle + " - " + e.get5250Emulator().getHost());
            }

            @Override
            public void disconnected(XI5250EmulatorEvent e) {
                XI5250Frame.this.setTitle(XI5250Frame.this.ivTitle);
            }
        });
    }

    @Override
    protected XI5250CrtCtrl createController(XI5250Crt crt) {
        return new XI5250EmulatorCtrl((XI5250Emulator)crt);
    }

    protected final XI5250EmulatorCtrl getEmulatorCtrl() {
        return (XI5250EmulatorCtrl)this.getCrtCtrl();
    }

    public final XI5250Emulator getEmulator() {
        return this.getEmulatorCtrl().getEmulator();
    }

    @Override
    protected void processExitCmd() {
        if (this.getEmulator().isActive()) {
            SwingUtilities.invokeLater(() -> {
                int ret = JOptionPane.showConfirmDialog(this, cvRes.getString("TXT_ConfirmExit"), "", 0);
                if (ret != 1) {
                    this.setVisible(false);
                    this.dispose();
                }
            });
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        switch (e.getID()) {
            case 200: {
                if (this.getEmulator().getHost() != null) break;
                this.getCommandMgr().dispatchCommand("CONNECT_CMD");
            }
        }
    }

    @Override
    protected JMenuBar createMenuBar() {
        String str = cvRes.getString("TXT_Communications");
        JMenu commMenu = new JMenu(XIUtil.removeMnemonics(str));
        commMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem connItem = new JMenuItem(cvRes.getString("TXT_Connect"));
        JMenuItem disconnItem = new JMenuItem(cvRes.getString("TXT_Disconnect"));
        JMenuItem aboutItem = new JMenuItem(cvRes.getString("TXT_About"));
        JMenuItem exitItem = new JMenuItem(cvRes.getString("TXT_Exit"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        commMenu.add(connItem);
        commMenu.add(disconnItem);
        commMenu.addSeparator();
        commMenu.add(aboutItem);
        commMenu.addSeparator();
        commMenu.add(exitItem);
        this.getCommandMgr().handleCommand(connItem, "CONNECT_CMD");
        this.getCommandMgr().handleCommand(disconnItem, "DISCONNECT_CMD");
        this.getCommandMgr().handleCommand(aboutItem, "ABOUT_CMD");
        this.getCommandMgr().handleCommand(exitItem, "EXIT_CMD");
        str = cvRes.getString("TXT_Edit");
        JMenu editMenu = new JMenu(XIUtil.removeMnemonics(str));
        editMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem copyItem = new JMenuItem(cvRes.getString("TXT_Copy"));
        JMenuItem pasteItem = new JMenuItem(cvRes.getString("TXT_Paste"));
        JMenuItem snapShotItem = new JMenuItem(cvRes.getString("TXT_SnapShot"));
        JMenuItem printItem = new JMenuItem(cvRes.getString("TXT_Print"));
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.addSeparator();
        editMenu.add(snapShotItem);
        editMenu.addSeparator();
        editMenu.add(printItem);
        this.getCommandMgr().handleCommand(copyItem, "COPY_CMD");
        this.getCommandMgr().handleCommand(pasteItem, "PASTE_CMD");
        this.getCommandMgr().handleCommand(snapShotItem, "SNAPSHOT_CMD");
        this.getCommandMgr().handleCommand(printItem, "PRINT_CMD");
        str = cvRes.getString("TXT_Options");
        JMenu optionsMenu = new JMenu(XIUtil.removeMnemonics(str));
        optionsMenu.setMnemonic(XIUtil.getMnemonic(str));
        JCheckBoxMenuItem switch3DfxItem = new JCheckBoxMenuItem(cvRes.getString("TXT_3dFx"));
        JCheckBoxMenuItem referenceCursorItem = new JCheckBoxMenuItem(cvRes.getString("TXT_RefCursor"));
        optionsMenu.add(switch3DfxItem);
        optionsMenu.add(referenceCursorItem);
        this.getCommandMgr().handleCommand(switch3DfxItem, "SWITCH_3DFX_CMD");
        this.getCommandMgr().handleCommand(referenceCursorItem, "REFERENCE_CURSOR_CMD");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(commMenu);
        menuBar.add(editMenu);
        menuBar.add(optionsMenu);
        return menuBar;
    }

    @Override
    protected JToolBar createToolBar() {
        AbstractButton[] buttons = new AbstractButton[]{new JButton(cvImagesBdl.getIcon("Connect")), new JButton(cvImagesBdl.getIcon("Disconnect")), null, new JButton(cvImagesBdl.getIcon("Copy")), new JButton(cvImagesBdl.getIcon("Paste")), null, new JButton(cvImagesBdl.getIcon("SnapShot")), new JButton(cvImagesBdl.getIcon("Print")), null, new JToggleButton(cvImagesBdl.getIcon("3dFx")), new JToggleButton(cvImagesBdl.getIcon("RefCursor"))};
        String[] buttonsActCmd = new String[]{"CONNECT_CMD", "DISCONNECT_CMD", null, "COPY_CMD", "PASTE_CMD", null, "SNAPSHOT_CMD", "PRINT_CMD", null, "SWITCH_3DFX_CMD", "REFERENCE_CURSOR_CMD"};
        String[] buttonHints = new String[]{cvRes.getString("TXT_Connect"), cvRes.getString("TXT_Disconnect"), null, cvRes.getString("TXT_Copy"), cvRes.getString("TXT_Paste"), null, cvRes.getString("TXT_SnapShot"), cvRes.getString("TXT_Print"), null, cvRes.getString("TXT_3dFx"), cvRes.getString("TXT_RefCursor")};
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        Dimension size = new Dimension(26, 26);
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] != null) {
                AbstractButton button = buttons[i];
                toolBar.add(button);
                button.setToolTipText(buttonHints[i]);
                button.setMinimumSize(size);
                button.setPreferredSize(size);
                button.setMaximumSize(size);
                button.setRequestFocusEnabled(false);
                this.getCommandMgr().handleCommand(button, buttonsActCmd[i]);
                continue;
            }
            toolBar.addSeparator();
        }
        return toolBar;
    }
}

