/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250CrtBuffer;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.crt5250.XI5250FieldsList;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Cmd;
import net.infordata.em.tn5250.XI5250CmdList;
import net.infordata.em.tn5250.XI5250EmulatorEvent;
import net.infordata.em.tn5250.XI5250EmulatorListener;
import net.infordata.em.tn5250.XI5250EmulatorMemento;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250OrdList;
import net.infordata.em.tn5250.XI5250StatusBar;
import net.infordata.em.tn5250.XIFieldTo5250Stream;
import net.infordata.em.tnprot.XITelnet;
import net.infordata.em.tnprot.XITelnetEmulator;

public class XI5250Emulator
extends XI5250Crt
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(XI5250Emulator.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String VERSION = "1.19m";
    public static final int MAX_ROWS = 27;
    public static final int MAX_COLS = 132;
    protected static final byte OPCODE_NOP = 0;
    protected static final byte OPCODE_INVITE_OPERATION = 1;
    protected static final byte OPCODE_OUTPUT_ONLY = 2;
    protected static final byte OPCODE_PUT_GET = 3;
    protected static final byte OPCODE_SAVE_SCREEN = 4;
    protected static final byte OPCODE_RESTORE_SCREEN = 5;
    protected static final byte OPCODE_READ_IMM = 6;
    protected static final byte OPCODE_RESERVED1 = 7;
    protected static final byte OPCODE_READ_SCREEN = 8;
    protected static final byte OPCODE_RESERVED2 = 9;
    protected static final byte OPCODE_CANCEL_INVITE = 10;
    protected static final byte OPCODE_TURN_ON_MSG = 11;
    protected static final byte OPCODE_TURN_OFF_MSG = 12;
    protected static final String[] OPCODE = new String[]{"No operation", "Invite operation", "Output only", "Put/Get Operation", "Save screen operation", "Restore screen operation", "Read immediate operation", "Reserved 1", "Read screen operation", "Reserved 2", "Cancel invite operation", "Turn ON message light", "Turn OFF message light"};
    protected static final int ERR_INVALID_COMMAND = 10030101;
    protected static final int ERR_INVALID_CLEAR_UNIT_ALT = 10030105;
    protected static final int ERR_INVALID_SOH_LENGTH = 10050131;
    protected static final int ERR_INVALID_ROW_COL_ADDR = 10050122;
    protected static final int ERR_INVALID_EXT_ATTR_TYPE = 10050132;
    protected static final int ERR_INVALID_SF_CLASS_TYPE = 10050111;
    protected static final byte FLAG_HLP = 1;
    protected static final byte FLAG_TRQ = 2;
    protected static final byte FLAG_SRQ = 4;
    protected static final byte FLAG_ATN = 64;
    protected static final byte FLAG_ERR = -128;
    protected static final byte ESC = 4;
    protected static final byte CMD_QUERY_DEVICE = -13;
    protected static final byte CMD_READ_IMMEDIATE = 114;
    protected static final byte CMD_READ_FIELDS = 66;
    protected static final byte CMD_READ_MDT_FIELDS = 82;
    protected static final byte CMD_READ_SCREEN = 98;
    protected static final byte CMD_SAVE_SCREEN = 2;
    protected static final byte CMD_CLEAR_FMT_TABLE = 80;
    protected static final byte CMD_CLEAR_UNIT = 64;
    protected static final byte CMD_CLEAR_UNIT_ALT = 32;
    protected static final byte CMD_RESTORE_SCREEN = 18;
    protected static final byte CMD_ROLL = 35;
    protected static final byte CMD_WRITE_ERROR_CODE = 33;
    protected static final byte CMD_WRITE_TO_DISPLAY = 17;
    protected static final byte ORD_SBA = 17;
    protected static final byte ORD_IC = 19;
    protected static final byte ORD_MC = 20;
    protected static final byte ORD_RA = 2;
    protected static final byte ORD_EA = 3;
    protected static final byte ORD_SOH = 1;
    protected static final byte ORD_TD = 16;
    protected static final byte ORD_WEA = 18;
    protected static final byte ORD_SF = 29;
    protected static final byte ORD_WDSF = 21;
    protected static final byte[] STRPCCMD = new byte[]{39, -128, -4, -41, -61, -42, 64, -125, -128, -95, -128};
    protected static final byte[] ENDSTRPCCMD = new byte[]{39, 0, -4, -41, -61, -42, 64, -125, -128, -126, 0};
    public static final byte AID_COMMAND = 49;
    public static final byte AID_FUNCTION = 50;
    public static final byte AID_F3 = 51;
    public static final byte AID_F4 = 52;
    public static final byte AID_F5 = 53;
    public static final byte AID_F6 = 54;
    public static final byte AID_F7 = 55;
    public static final byte AID_F8 = 56;
    public static final byte AID_F9 = 57;
    public static final byte AID_F10 = 58;
    public static final byte AID_F11 = 59;
    public static final byte AID_F12 = 60;
    public static final byte AID_F13 = -79;
    public static final byte AID_F14 = -78;
    public static final byte AID_F15 = -77;
    public static final byte AID_F16 = -76;
    public static final byte AID_F17 = -75;
    public static final byte AID_F18 = -74;
    public static final byte AID_F19 = -73;
    public static final byte AID_F20 = -72;
    public static final byte AID_F21 = -71;
    public static final byte AID_F22 = -70;
    public static final byte AID_F23 = -69;
    public static final byte AID_F24 = -68;
    public static final byte AID_CLEAR = -67;
    public static final byte AID_ENTER = -15;
    public static final byte AID_HELP = -13;
    public static final byte AID_ROLL_DN = -12;
    public static final byte AID_ROLL_UP = -11;
    public static final byte AID_PRINT = -10;
    public static final byte AID_REC_BACKSP = -8;
    public static final byte AID_AUTO_ENTER = 63;
    public static final int ST_NULL = -2;
    public static final int ST_TEMPORARY_LOCK = -1;
    public static final int ST_HARDWARE_ERROR = 0;
    public static final int ST_NORMAL_LOCKED = 1;
    public static final int ST_NORMAL_UNLOCKED = 2;
    public static final int ST_POST_HELP = 3;
    public static final int ST_POWER_ON = 4;
    public static final int ST_PRE_HELP = 5;
    public static final int ST_SS_MESSAGE = 6;
    public static final int ST_SYSTEM_REQUEST = 7;
    public static final int ST_POWERED = 8;
    private static final String[] ST_DESCRIPTION = new String[]{"ST_NULL", "ST_TEMPORARY_LOCK", "ST_HARDWARE_ERROR", "ST_NORMAL_LOCKED", "ST_NORMAL_UNLOCKED", "ST_POST_HELP", "ST_POWER_ON", "ST_PRE_HELP", "ST_SS_MESSAGE", "ST_SYSTEM_REQUEST", "ST_POWERED"};
    private transient XITelnet ivTelnet;
    private transient byte[] ivRXBuf = new byte[8192];
    private transient int ivRXBufLen;
    private transient int ivFunctionKeysMask;
    transient XI5250CmdList ivCmdList;
    transient XI5250Cmd ivPendingCmd;
    private transient int ivState = -2;
    private transient int ivPrevState = -2;
    private transient int ivErrorRow;
    private transient XI5250StatusBar ivStatusBar;
    protected transient XI5250EmulatorMemento[] ivSavedScreens = new XI5250EmulatorMemento[10];
    protected transient int ivSavedScreensIdx = 0;
    transient KeyEventQueue ivKeybEventQueue;
    transient KeyEventDispatchThread ivKeybThread;
    private transient XI5250EmulatorMemento ivSysReqMemento;
    private transient XI5250Field ivSysReqField;
    private transient XI5250CrtBuffer ivPreHelpErrorLine;
    private transient XI5250EmulatorListener ivEmulatorListener;
    private String ivTermType;
    private String ivTelnetEnv;
    private transient TelnetEmulator ivTelnetEmulator = new TelnetEmulator();
    protected transient Font ivPrevFont;
    public static final String ACTIVE = "active";
    public static final String TERMINAL_TYPE = "terminalType";
    public static final String ALTFKEY_REMAP = "altFKeyRemap";
    public static final String TELNET_ENV = "telnetEnv";
    public static final String STRPCCMD_ENABLED = "strPcCmd";
    private String ivHost;
    private int ivPort = 23;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private boolean disconnectOnSocketException;
    private int connectionTimeoutMillis;
    private boolean ivAltFKeyRemap;
    private boolean ivStrPcCmdEnabled;
    private boolean ivReceivedStrPcCmd;
    private boolean ivReceivedEndStrPcCmd;
    private static final int AUTO_ENTER_MODIFIERS = new KeyEvent(new JLabel(""), 401, 0L, -1, 10, '\n').getModifiers();

    public XI5250Emulator() {
        this.ivStatusBar = new XI5250StatusBar();
        this.ivStatusBar.setVisible(false);
        this.add(this.ivStatusBar);
        this.enableEvents(1L);
        this.setTerminalType("IBM-3179-2");
        this.setState(4);
        this.setErrorRow(this.getCrtSize().height - 1);
    }

    public synchronized void addEmulatorListener(XI5250EmulatorListener l) {
        this.ivEmulatorListener = Multicaster.add(this.ivEmulatorListener, l);
    }

    public synchronized void removeEmulatorListener(XI5250EmulatorListener l) {
        this.ivEmulatorListener = Multicaster.remove(this.ivEmulatorListener, l);
    }

    protected void processEmulatorEvent(XI5250EmulatorEvent e) {
        if (this.ivEmulatorListener == null) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                this.ivEmulatorListener.connecting(e);
                break;
            }
            case 1: {
                this.ivEmulatorListener.connected(e);
                break;
            }
            case 2: {
                this.ivEmulatorListener.disconnected(e);
                break;
            }
            case 3: {
                this.ivEmulatorListener.stateChanged(e);
                break;
            }
            case 4: {
                this.ivEmulatorListener.newPanelReceived(e);
                break;
            }
            case 5: {
                this.ivEmulatorListener.fieldsRemoved(e);
                break;
            }
            case 6: {
                this.ivEmulatorListener.dataSended(e);
            }
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.moveStatusBar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveStatusBar() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.ivStatusBar.setFont(this.getFont());
            this.ivStatusBar.setBounds(0, this.getCrtBufferSize().height, this.getCrtBufferSize().width, this.getCharSize().height + 4);
            this.ivStatusBar.setVisible(true);
        }
    }

    public synchronized void setHost(String aHost) {
        if (aHost == this.ivHost || aHost != null && aHost.equals(this.ivHost)) {
            return;
        }
        this.setActive(false);
        this.ivHost = aHost;
    }

    public final String getHost() {
        return this.ivHost;
    }

    public synchronized void setPort(int aPort) {
        if (aPort == this.ivPort) {
            return;
        }
        this.setActive(false);
        this.ivPort = aPort;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setDisconnectOnSocketException(boolean disconnectOnSocketException) {
        this.disconnectOnSocketException = disconnectOnSocketException;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean activate) {
        boolean wasActive;
        XI5250Emulator xI5250Emulator = this;
        synchronized (xI5250Emulator) {
            wasActive = this.isActive();
            if (activate == wasActive) {
                return;
            }
            if (activate) {
                this.ivTelnet = new XITelnet(this.ivHost, this.ivPort);
                this.ivTelnet.setSocketFactory(this.socketFactory);
                this.ivTelnet.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
                this.ivTelnet.setEmulator(this.ivTelnetEmulator);
                this.ivTelnet.setDisconnectOnException(this.disconnectOnSocketException);
                this.ivTelnet.connect();
            } else {
                this.setBlinkingCursor(false);
                this.ivTelnet.disconnect();
                this.ivTelnet.setEmulator(null);
                this.ivTelnet = null;
            }
        }
        this.firePropertyChange(ACTIVE, wasActive, this.isActive());
    }

    public boolean isActive() {
        return this.ivTelnet == null ? false : this.ivTelnet.isConnected();
    }

    public void setTerminalType(String aTermType) {
        if (aTermType != null && aTermType.equals(this.ivTermType)) {
            return;
        }
        if (this.isActive()) {
            throw new IllegalArgumentException("Cannot change the terminal type, close the connection first.");
        }
        if (!"IBM-3179-2".equals(aTermType) && !"IBM-3477-FC".equals(aTermType)) {
            throw new IllegalArgumentException("Wrong terminal type, valid values are IBM-3179-2 or IBM-3477-FC.");
        }
        String oldTermType = this.ivTermType;
        this.ivTermType = aTermType;
        this.firePropertyChange(TERMINAL_TYPE, oldTermType, this.ivTermType);
    }

    public String getTerminalType() {
        return this.ivTermType;
    }

    public void setTelnetEnv(String env) {
        if (env != null && env.equals(this.ivTelnetEnv)) {
            return;
        }
        if (this.isActive()) {
            throw new IllegalArgumentException("Cannot change the device name, close the connection first.");
        }
        String old = this.ivTelnetEnv;
        this.ivTelnetEnv = env;
        this.firePropertyChange(TELNET_ENV, old, this.ivTelnetEnv);
    }

    public String getTelnetEnv() {
        return this.ivTelnetEnv;
    }

    public void setAltFKeyRemap(boolean value) {
        if (value == this.ivAltFKeyRemap) {
            return;
        }
        boolean old = this.ivAltFKeyRemap;
        this.ivAltFKeyRemap = value;
        this.firePropertyChange(ALTFKEY_REMAP, old, this.ivAltFKeyRemap);
    }

    public boolean getAltFKeyRemap() {
        return this.ivAltFKeyRemap;
    }

    public void setStrPcCmdEnabled(boolean value) {
        if (value == this.ivStrPcCmdEnabled) {
            return;
        }
        boolean old = this.ivStrPcCmdEnabled;
        this.ivStrPcCmdEnabled = value;
        this.firePropertyChange(STRPCCMD_ENABLED, old, this.ivStrPcCmdEnabled);
    }

    public boolean isStrPcCmdEnabled() {
        return this.ivStrPcCmdEnabled;
    }

    @Override
    public void setCursorPos(int aCol, int aRow) {
        super.setCursorPos(aCol, aRow);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XI5250Emulator.this.ivStatusBar.setCoordArea(XI5250Emulator.this.getCursorCol() + 1, XI5250Emulator.this.getCursorRow() + 1);
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height += this.getCharSize().height + 4;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.height += this.getMinCharSize().height + 4;
        return size;
    }

    @Override
    protected Dimension getTestSize(Font aFont) {
        FontMetrics fm = this.getFontMetrics(aFont);
        Dimension res = new Dimension(fm.charWidth('W') * this.getCrtSize().width, fm.getHeight() * (this.getCrtSize().height + 1) + 4);
        return res;
    }

    protected XI5250Field create5250Field(byte[] aFFW, byte[] aFCW, int aCol, int aRow, int aLen, int aAttr) {
        return new XI5250Field(this, aFFW, aFCW, aCol, aRow, aLen, aAttr);
    }

    public synchronized XI5250EmulatorMemento createMemento() {
        return new XI5250EmulatorMemento((XI5250FieldsList)this.ivFields.clone(), this.ivFunctionKeysMask, this.ivPendingCmd, this.ivState, this.ivPrevState, this.getCursorCol(), this.getCursorRow(), this.ivErrorRow, (XI5250CrtBuffer)this.getCrtBuffer().clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreMemento(XI5250EmulatorMemento aMemento) {
        Object object = this.getTreeLock();
        synchronized (object) {
            XI5250Emulator xI5250Emulator = this;
            synchronized (xI5250Emulator) {
                Dimension dim = aMemento.ivCrtBuffer.getCrtSize();
                this.setCrtSize(dim.width, dim.height);
                this.ivFields = aMemento.ivFields;
                this.ivFunctionKeysMask = aMemento.ivFunctionKeysMask;
                this.ivPendingCmd = aMemento.ivPendingCmd;
                this.setState(aMemento.ivState);
                this.ivPrevState = aMemento.ivPrevState;
                this.setErrorRow(aMemento.ivErrorRow);
                this.setCursorPos(aMemento.ivCol, aMemento.ivRow);
                this.getCrtBuffer().copyFrom(aMemento.ivCrtBuffer);
                this.processEmulatorEvent(new XI5250EmulatorEvent(4, this));
            }
        }
        this.repaint();
    }

    protected synchronized XI5250EmulatorMemento createSysReqMemento() {
        return new XI5250EmulatorMemento((XI5250FieldsList)this.ivFields.clone(), this.ivFunctionKeysMask, this.ivPendingCmd, this.ivState, this.ivPrevState, this.getCursorCol(), this.getCursorRow(), this.ivErrorRow, new XI5250CrtBuffer((XI5250CrtBuffer)this.getCrtBuffer(), 0, this.ivErrorRow, this.getCrtSize().width, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSysReqMemento(XI5250EmulatorMemento aMemento) {
        Object object = this.getTreeLock();
        synchronized (object) {
            XI5250Emulator xI5250Emulator = this;
            synchronized (xI5250Emulator) {
                this.ivFields = aMemento.ivFields;
                this.ivFunctionKeysMask = aMemento.ivFunctionKeysMask;
                this.ivPendingCmd = aMemento.ivPendingCmd;
                this.setErrorRow(aMemento.ivErrorRow);
                this.setCursorPos(aMemento.ivCol, aMemento.ivRow);
                this.getCrtBuffer().copyFrom(0, this.ivErrorRow, aMemento.ivCrtBuffer, 0, 0, this.getCrtSize().width, 1);
                this.processEmulatorEvent(new XI5250EmulatorEvent(4, this));
            }
        }
        this.repaint();
    }

    protected void connecting() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("connecting()");
        }
        this.ivTelnet.setTerminalType(this.ivTermType);
        if (this.ivTelnetEnv != null) {
            this.ivTelnet.setEnvironment(this.ivTelnetEnv);
        }
        this.ivTelnet.setLocalReqFlag((byte)0, true);
        this.ivTelnet.setLocalReqFlag((byte)24, true);
        this.ivTelnet.setLocalReqFlag((byte)25, true);
        this.ivTelnet.setRemoteReqFlag((byte)0, true);
        this.ivTelnet.setRemoteReqFlag((byte)25, true);
        this.processEmulatorEvent(new XI5250EmulatorEvent(0, this));
    }

    protected void connected() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("connected()");
        }
        this.processEmulatorEvent(new XI5250EmulatorEvent(1, this));
    }

    protected void disconnected(boolean remote) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("disconnected()");
        }
        this.setState(4);
        this.setDefAttr(32);
        this.clear();
        this.removeFields();
        this.setCursorPos(0, 0);
        this.processEmulatorEvent(new XI5250EmulatorEvent(2, this));
    }

    protected void caughtIOException(IOException ex) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "caughtIOException()", ex);
        }
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, ex.getClass().getName() + "\n" + ex.getMessage() + "\nSee the log for details ", "WARNING", 2));
    }

    protected void caught5250Exception(XI5250Exception ex) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "caught5250Exception()", ex);
        }
        this.send5250Error(ex.getErrorCode());
    }

    protected void caughtException(Throwable ex) {
        LOGGER.log(Level.SEVERE, "caughtException()", ex);
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this, ex.getMessage() + "\nSee the log for details ", "ERROR", 0));
    }

    protected void receivedData(byte[] buf, int len) {
        if (this.getState() == 4) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Discarding received data len: " + len);
            }
            return;
        }
        System.arraycopy(buf, 0, this.ivRXBuf, this.ivRXBufLen, len);
        this.ivRXBufLen += len;
    }

    protected void receivedEOR() {
        int packetLen;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("receivedEOR()");
            if (LOGGER.isLoggable(Level.FINER)) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.ivRXBufLen; ++i) {
                    sb.append(XITelnet.toHex(this.ivRXBuf[i]) + "  ");
                }
                LOGGER.finer(sb.toString());
            }
        }
        if ((packetLen = (XITelnet.toInt(this.ivRXBuf[0]) << 8) + XITelnet.toInt(this.ivRXBuf[1])) != this.ivRXBufLen || this.ivRXBuf[2] != 18 || this.ivRXBuf[3] != -96) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("malformed packet");
            }
            this.ivRXBufLen = 0;
            return;
        }
        int varHdrLen = XITelnet.toInt(this.ivRXBuf[6]);
        int dataStart = 6 + varHdrLen;
        boolean errFlag = (this.ivRXBuf[7] & 0xFFFFFF80) != 0;
        boolean atnFlag = (this.ivRXBuf[7] & 0x40) != 0;
        boolean srqFlag = (this.ivRXBuf[7] & 4) != 0;
        boolean trqFlag = (this.ivRXBuf[7] & 2) != 0;
        boolean hlpFlag = (this.ivRXBuf[7] & 1) != 0;
        byte opCode = this.ivRXBuf[9];
        ByteArrayInputStream dataStream = new ByteArrayInputStream(this.ivRXBuf, dataStart, this.ivRXBufLen - dataStart);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("OPCODE : " + OPCODE[opCode]);
        }
        switch (opCode) {
            case 0: 
            case 7: 
            case 9: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                this.ivReceivedStrPcCmd = false;
                this.ivReceivedEndStrPcCmd = false;
                XI5250CmdList cmdList = this.createCmdList(this);
                try {
                    cmdList.readFrom5250Stream(dataStream);
                    this.ivCmdList = cmdList;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = XI5250Emulator.this.getTreeLock();
                            synchronized (object) {
                                2 var2_3 = this;
                                synchronized (var2_3) {
                                    if (XI5250Emulator.this.getState() == 7) {
                                        XI5250Emulator.this.setPrevState();
                                    }
                                    XI5250Emulator.this.setFreeze(true);
                                    try {
                                        XI5250Emulator.this.ivCmdList.execute();
                                        XI5250Emulator.this.initAllFields();
                                        XI5250Emulator.this.processEmulatorEvent(new XI5250EmulatorEvent(4, XI5250Emulator.this));
                                    }
                                    finally {
                                        XI5250Emulator.this.setFreeze(false);
                                    }
                                }
                            }
                            if (XI5250Emulator.this.ivReceivedStrPcCmd) {
                                char ch;
                                int k;
                                char ctrlChar = XI5250Emulator.this.getChar(0, 0);
                                boolean wait = ctrlChar != 'a';
                                String cmd = XI5250Emulator.this.getString(1, 0, 132 - STRPCCMD.length);
                                for (k = cmd.length() - 1; k >= 0 && (Character.isISOControl(ch = cmd.charAt(k)) || Character.isWhitespace(ch)); --k) {
                                }
                                cmd = cmd.substring(0, k + 1);
                                try {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        if (wait) {
                                            LOGGER.info("Executing and waiting for local command: " + cmd);
                                        } else {
                                            LOGGER.info("Executing local command: " + cmd);
                                        }
                                    }
                                    try {
                                        XI5250Emulator.this.strPcCmd(wait, cmd);
                                    }
                                    catch (IOException ex) {
                                        XI5250Emulator.this.caughtIOException(ex);
                                    }
                                    catch (InterruptedException ex) {
                                        XI5250Emulator.this.caughtException(ex);
                                    }
                                }
                                finally {
                                    XI5250Emulator.this.processRawKeyEvent(new KeyEvent(XI5250Emulator.this, 401, 0L, -1, 10, '\uffff'));
                                }
                            } else if (XI5250Emulator.this.ivReceivedEndStrPcCmd) {
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.info("Received STRPCCMD shutdown");
                                }
                                XI5250Emulator.this.processRawKeyEvent(new KeyEvent(XI5250Emulator.this, 401, 0L, -1, 10, '\uffff'));
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    this.caughtException(ex);
                }
                catch (XI5250Exception ex) {
                    this.caught5250Exception(ex);
                }
                catch (Exception ex) {
                    this.caughtException(ex);
                }
                if (!LOGGER.isLoggable(Level.FINER)) break;
                LOGGER.finer("" + cmdList);
                break;
            }
            case 10: {
                this.receivedCancelInvite();
                break;
            }
            case 11: 
            case 12: {
                this.switchMsgLight(opCode == 11);
                break;
            }
            default: {
                throw new RuntimeException("Illegal 5250 opcode received");
            }
        }
        this.ivRXBufLen = 0;
    }

    protected void localFlagsChanged(byte aIACOpt) {
    }

    protected void remoteFlagsChanged(byte aIACOpt) {
        if (aIACOpt == 25 && this.ivTelnet.isRemoteFlagON((byte)25)) {
            this.setState(8);
        }
    }

    protected void unhandledRequest(byte aIACOpt, String aIACStr) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("unhandledRequest()");
        }
    }

    protected void switchMsgLight(boolean turnOn) {
        this.ivStatusBar.setMessageArea(turnOn ? 1 : 0);
    }

    protected void receivedCancelInvite() {
        this.ivPendingCmd = null;
        this.send5250Packet((byte)0, (byte)10, null);
    }

    public synchronized void setKeyboardQueue(boolean flag) {
        if (flag == this.isKeyboardQueue()) {
            return;
        }
        if (flag) {
            this.ivKeybEventQueue = new KeyEventQueue();
            this.startKeybThread();
        } else {
            this.ivKeybEventQueue = null;
            this.stopKeybThread();
        }
    }

    public boolean isKeyboardQueue() {
        return this.ivKeybEventQueue != null;
    }

    public void clearKeyboardQueue() {
        if (this.ivKeybEventQueue != null) {
            this.ivKeybEventQueue.removeAll();
        }
    }

    protected void startKeybThread() {
        if (!this.isKeyboardQueue() || this.ivKeybThread != null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("startKeybThread()");
        }
        this.ivKeybThread = new KeyEventDispatchThread(this);
        this.ivKeybThread.start();
    }

    protected void stopKeybThread() {
        if (!this.isKeyboardQueue() || this.ivKeybThread == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("stopKeybThread()");
        }
        this.ivKeybThread.stopDispatching();
        this.ivKeybThread = null;
    }

    protected synchronized void setState(int aState) {
        if (aState == this.ivState) {
            return;
        }
        int oldState = this.ivState;
        if (this.ivState >= 0) {
            this.ivPrevState = this.ivState;
        }
        this.ivState = aState;
        this.ivStatusBar.setStateArea(aState);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ivPrevState = " + ST_DESCRIPTION[this.ivPrevState - -2] + "    ivState = " + ST_DESCRIPTION[this.ivState - -2]);
        }
        switch (oldState) {
            case 7: {
                this.restoreSysReqMemento(this.ivSysReqMemento);
                this.ivSysReqMemento = null;
                this.ivSysReqField = null;
                break;
            }
            case 5: {
                this.getCrtBuffer().copyFrom(0, this.ivErrorRow, this.ivPreHelpErrorLine, 0, 0, this.getCrtSize().width, 1);
                this.repaint();
            }
        }
        switch (aState) {
            case 4: {
                this.ivStatusBar.setFlashArea(true);
                break;
            }
            case 8: {
                this.ivStatusBar.setFlashArea(false);
                break;
            }
            case -1: 
            case 1: {
                this.stopKeybThread();
                break;
            }
            case 7: {
                this.ivSysReqMemento = this.createSysReqMemento();
                this.removeFields();
                this.ivPendingCmd = null;
                this.drawString(String.valueOf('\u0001'), 0, this.ivErrorRow, 52);
                this.ivSysReqField = new XI5250Field(this, 1, this.ivErrorRow, this.getCrtSize().width - 2, -1);
                this.addField(this.ivSysReqField);
                this.initAllFields();
                this.ivSysReqField.clear();
                this.setCursorPos(1, this.ivErrorRow);
                this.startKeybThread();
                break;
            }
            case 5: {
                this.ivPreHelpErrorLine = new XI5250CrtBuffer((XI5250CrtBuffer)this.getCrtBuffer(), 0, this.ivErrorRow, this.getCrtSize().width, 1);
                this.startKeybThread();
                break;
            }
            default: {
                this.startKeybThread();
            }
        }
        this.processEmulatorEvent(new XI5250EmulatorEvent(3, this));
    }

    public int getState() {
        return this.ivState;
    }

    protected void setPrevState() {
        this.setState(this.ivPrevState);
    }

    public int getPrevState() {
        return this.ivPrevState;
    }

    protected XI5250CmdList createCmdList(XI5250Emulator aEm) {
        return new XI5250CmdList(aEm);
    }

    protected XI5250OrdList createOrdList(XI5250Emulator aEm) {
        return new XI5250OrdList(aEm);
    }

    protected void setErrorRow(int aRow) {
        this.ivErrorRow = Math.min(aRow, this.getCrtSize().height - 1);
    }

    protected int getErrorRow() {
        return this.ivErrorRow;
    }

    protected void setFunctionKeysMask(int aMask) {
        this.ivFunctionKeysMask = aMask;
    }

    protected boolean isMasterMDTSet() {
        return true;
    }

    public void send5250Packet(byte flags, byte opcode, byte[] buf, int aLen) {
        byte[] cBuf = new byte[]{0, 0, 18, -96, 0, 0, 4, flags, 0, opcode};
        int len = aLen + cBuf.length;
        cBuf[0] = (byte)((len & 0xFF00) >> 8);
        cBuf[1] = (byte)(len & 0xFF);
        this.ivTelnet.send(cBuf);
        if (buf != null && aLen != 0) {
            this.ivTelnet.send(buf, aLen);
        }
        this.ivTelnet.sendEOR();
    }

    public void send5250Packet(byte flags, byte opcode, byte[] buf) {
        this.send5250Packet(flags, opcode, buf, buf != null ? buf.length : 0);
    }

    public void send5250UserError(int aErrorCode) {
        XIEbcdicTranslator translator = this.getTranslator();
        byte[] buf = translator.toPacked(aErrorCode, 4);
        this.send5250Packet((byte)1, (byte)0, buf);
    }

    public void send5250Error(int aErrorCode) {
        XIEbcdicTranslator translator = this.getTranslator();
        byte[] buf = translator.toPacked(aErrorCode, 8);
        this.send5250Packet((byte)-128, (byte)0, buf);
    }

    public void send5250Data(int anAidCode, boolean includeFields, boolean includeMDTOnly) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] cBuf = new byte[]{(byte)(this.getCursorRow() + 1), (byte)(this.getCursorCol() + 1), (byte)anAidCode};
        try {
            out.write(cBuf);
            if (includeFields) {
                this.ivFields.saveTo(new XIFieldTo5250Stream(this, out, includeMDTOnly));
            }
            byte[] buf = out.toByteArray();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("---->Send5250Data");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < buf.length; ++i) {
                    sb.append(XITelnet.toHex(buf[i]) + "  ");
                }
                LOGGER.finer(sb.toString());
            }
            this.send5250Packet((byte)0, (byte)0, buf);
            this.processEmulatorEvent(new XI5250EmulatorEvent(6, this, (byte)anAidCode));
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    public void send5250SavedScreen(int aScreenNum) {
        byte[] cBuf = new byte[]{4, 18, (byte)aScreenNum};
        this.send5250Packet((byte)0, (byte)4, cBuf);
    }

    public void send5250Screen() {
        XIEbcdicTranslator translator = this.getTranslator();
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        for (int row = 0; row < this.getCrtSize().height; ++row) {
            for (int col = 0; col < this.getCrtSize().width; ++col) {
                char ch = this.getChar(col, row);
                if (ch == '\u0001') {
                    ch = (char)this.getAttr(col, row);
                    out.write((byte)ch);
                    continue;
                }
                out.write(translator.toEBCDIC(ch));
            }
        }
        byte[] buf = out.toByteArray();
        this.send5250Packet((byte)0, (byte)8, buf);
    }

    protected void updateStatusBar(InputEvent e) {
        this.ivStatusBar.setShiftArea(e.isShiftDown() ? 1 : 0);
    }

    @Override
    public void removeFields() {
        super.removeFields();
        this.processEmulatorEvent(new XI5250EmulatorEvent(5, this));
    }

    @Override
    protected void userError(int aError) {
        Toolkit.getDefaultToolkit().beep();
        this.setState(5);
        this.send5250UserError(aError);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this.updateStatusBar(e);
        super.processMouseEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        this.updateStatusBar(e);
        super.processKeyEvent(e);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized void processRawKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 401: {
                switch (e.getKeyCode()) {
                    case 27: {
                        if (this.ivKeybEventQueue != null) {
                            this.ivKeybEventQueue.removeAll();
                        }
                        if (e.getModifiers() != 1) break;
                        this.setState(7);
                        break;
                    }
                    case 17: {
                        if (e.getModifiers() != 2 || this.ivKeybEventQueue == null) break;
                        this.ivKeybEventQueue.removeAll();
                    }
                }
                break;
            }
        }
        if (this.ivKeybEventQueue == null) {
            this.doProcessKeyEvent(e);
        } else {
            this.ivKeybEventQueue.postEvent(new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar()));
        }
        if ((e.getModifiers() & 8) == 0) {
            e.consume();
        }
    }

    @Override
    protected synchronized void doProcessKeyEvent(KeyEvent e) {
        switch (e.getID()) {
            case 401: {
                if (this.getState() != 5 || XI5250Emulator.isCharKey(e)) break;
                this.setPrevState();
            }
        }
        switch (this.getState()) {
            case -1: 
            case 1: {
                break;
            }
            case 7: {
                this.processKeySystemRequest(e);
                break;
            }
            case 2: {
                this.processKeyNormalUnlocked(e);
            }
        }
    }

    protected boolean processKeySystemRequest(KeyEvent e) {
        boolean res;
        block13: {
            super.doProcessKeyEvent(e);
            if (e.isConsumed()) {
                return true;
            }
            res = false;
            block0 : switch (e.getID()) {
                case 400: {
                    if (!XI5250Emulator.isCharKey(e)) break;
                    this.setPrevState();
                    this.userError(5);
                    res = true;
                    break;
                }
                case 401: {
                    switch (e.getKeyCode()) {
                        case 27: {
                            if (e.getModifiers() == 0) {
                                this.setPrevState();
                                break block0;
                            }
                            break block13;
                        }
                        case 10: {
                            int i;
                            String aStr = this.ivSysReqField.getString();
                            this.setPrevState();
                            for (i = aStr.length() - 1; i >= 0 && aStr.charAt(i) == '\u0000'; --i) {
                            }
                            byte[] buf = this.getTranslator().toText(aStr, i + 1);
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer("---->Send5250SysReq");
                                StringBuilder sb = new StringBuilder();
                                for (i = 0; i < buf.length; ++i) {
                                    sb.append(XITelnet.toHex(buf[i]) + "  ");
                                }
                                LOGGER.finer(sb.toString());
                            }
                            this.send5250Packet((byte)4, (byte)0, buf);
                        }
                    }
                }
            }
        }
        return res;
    }

    protected boolean processKeyNormalUnlocked(KeyEvent e) {
        boolean res;
        block13: {
            super.doProcessKeyEvent(e);
            if (e.isConsumed()) {
                return true;
            }
            res = false;
            block0 : switch (e.getID()) {
                case 400: {
                    if (!XI5250Emulator.isCharKey(e)) break;
                    this.userError(5);
                    res = true;
                    break;
                }
                case 401: {
                    switch (e.getKeyCode()) {
                        case 27: {
                            if (e.getModifiers() == 0) {
                                this.send5250Packet((byte)64, (byte)0, null);
                                break block0;
                            }
                            break block13;
                        }
                        case 10: {
                            res = this.processKeyEnter(e.getModifiers());
                            break block0;
                        }
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: {
                            res = this.processKeyFXX(e.getKeyCode(), e.getModifiers());
                            break block0;
                        }
                        case 33: 
                        case 34: {
                            res = this.processKeyPageXX(e.getKeyCode(), e.getModifiers());
                            break block0;
                        }
                        case 19: {
                            res = this.processKeyPause(e.getModifiers());
                        }
                    }
                }
            }
        }
        return res;
    }

    protected boolean processKeyEnter(int aModifier) {
        if (aModifier != 0 && aModifier != AUTO_ENTER_MODIFIERS) {
            return false;
        }
        if (this.ivPendingCmd != null) {
            this.ivPendingCmd.executePending(aModifier != AUTO_ENTER_MODIFIERS ? -15 : 63, false);
        }
        return true;
    }

    protected boolean processKeyFXX(int aKey, int aModifier) {
        int aidCode;
        int ofs = aKey - 112;
        if (aModifier == 0) {
            aidCode = 49 + ofs;
        } else if (aModifier == 1) {
            aidCode = -79 + ofs;
        } else if (aModifier == 8 && aKey == 112) {
            aidCode = -13;
        } else {
            return false;
        }
        int mask = 1 << ofs;
        if (this.ivPendingCmd != null) {
            this.ivPendingCmd.executePending(aidCode, (this.ivFunctionKeysMask & mask) != 0);
        }
        return true;
    }

    protected boolean processKeyPageXX(int aKey, int aModifier) {
        if (aModifier != 0) {
            return false;
        }
        if (this.ivPendingCmd != null) {
            this.ivPendingCmd.executePending(aKey == 33 ? -12 : -11, false);
        }
        return true;
    }

    protected boolean processKeyPause(int aModifier) {
        if (aModifier != 0) {
            return false;
        }
        if (this.ivPendingCmd != null) {
            this.ivPendingCmd.executePending(-67, false);
        }
        return true;
    }

    @Override
    protected KeyEvent translateKeyEvent(KeyEvent e) {
        if (!this.getAltFKeyRemap()) {
            return e;
        }
        if (e.getKeyCode() >= 112 && e.getKeyCode() <= 123) {
            if ((e.getModifiers() & 8) != 0 && (e.getModifiers() & 1) != 0) {
                e.setModifiers(e.getModifiers() & 0xFFFFFFFE);
            } else if ((e.getModifiers() & 8) != 0) {
                e.setModifiers(e.getModifiers() & 0xFFFFFFF7);
            }
        }
        return e;
    }

    @Override
    protected void finalize() throws Throwable {
        this.setActive(false);
        super.finalize();
    }

    void receivedStrPcCmd() {
        if (!this.isStrPcCmdEnabled()) {
            throw new IllegalStateException();
        }
        this.ivReceivedStrPcCmd = true;
    }

    void receivedEndStrPcCmd() {
        if (!this.isStrPcCmdEnabled()) {
            throw new IllegalStateException();
        }
        this.ivReceivedEndStrPcCmd = true;
    }

    protected int strPcCmd(boolean wait, String cmd) throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec(cmd);
        return wait ? proc.waitFor() : 0;
    }

    public void soundAlarm() {
        Toolkit.getDefaultToolkit().beep();
    }

    class TelnetEmulator
    implements XITelnetEmulator {
        TelnetEmulator() {
        }

        @Override
        public final void connecting() {
            XI5250Emulator.this.connecting();
        }

        @Override
        public final void connected() {
            XI5250Emulator.this.connected();
        }

        @Override
        public final void disconnected(boolean remote) {
            XI5250Emulator.this.disconnected(remote);
        }

        @Override
        public final void caughtIOException(IOException ex) {
            XI5250Emulator.this.caughtIOException(ex);
        }

        @Override
        public final void receivedData(byte[] buf, int len) {
            XI5250Emulator.this.receivedData(buf, len);
        }

        @Override
        public final void receivedEOR() {
            XI5250Emulator.this.receivedEOR();
        }

        @Override
        public final void unhandledRequest(byte aIACOpt, String aIACStr) {
            XI5250Emulator.this.unhandledRequest(aIACOpt, aIACStr);
        }

        @Override
        public final void localFlagsChanged(byte aIACOpt) {
            XI5250Emulator.this.localFlagsChanged(aIACOpt);
        }

        @Override
        public final void remoteFlagsChanged(byte aIACOpt) {
            XI5250Emulator.this.remoteFlagsChanged(aIACOpt);
        }
    }

    protected static class KeyEventDispatchThread
    extends Thread {
        protected XI5250Emulator ivEmulator;
        protected boolean ivStop = false;

        public KeyEventDispatchThread(XI5250Emulator aEmulator) {
            super("5250 Keyboard event dispatching thread");
            this.ivEmulator = aEmulator;
        }

        public void stopDispatching() {
            this.ivStop = true;
            if (this != Thread.currentThread()) {
                this.interrupt();
            }
        }

        @Override
        public void run() {
            while (!this.ivStop && this.ivEmulator.isKeyboardQueue()) {
                try {
                    KeyEvent e = (KeyEvent)this.ivEmulator.ivKeybEventQueue.getNextEvent();
                    SwingUtilities.invokeAndWait(() -> {
                        Object object = this.ivEmulator.getTreeLock();
                        synchronized (object) {
                            this.ivEmulator.doProcessKeyEvent(e);
                        }
                    });
                }
                catch (InterruptedException ex) {
                }
                catch (ThreadDeath ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    System.err.println("Exception occurred during 5250 keyboard event dispatching:");
                    ex.printStackTrace();
                }
            }
        }
    }

    protected static class KeyEventQueue {
        private KeyEventQueueItem ivQueue;

        public synchronized void postEvent(AWTEvent theEvent) {
            KeyEventQueueItem eqi = new KeyEventQueueItem(theEvent);
            if (this.ivQueue == null) {
                this.ivQueue.ivNext = this.ivQueue = eqi;
                this.notifyAll();
            } else {
                eqi.ivNext = this.ivQueue.ivNext;
                this.ivQueue.ivNext = eqi;
                this.ivQueue = eqi;
            }
        }

        public synchronized AWTEvent getNextEvent() throws InterruptedException {
            while (this.ivQueue == null) {
                this.wait();
            }
            KeyEventQueueItem eqi = this.ivQueue.ivNext;
            if (eqi == this.ivQueue) {
                this.ivQueue = null;
            } else {
                this.ivQueue.ivNext = eqi.ivNext;
            }
            return eqi.ivEvent;
        }

        public synchronized void removeAll() {
            this.ivQueue = null;
        }
    }

    protected static class KeyEventQueueItem {
        AWTEvent ivEvent;
        int ivId;
        KeyEventQueueItem ivNext;

        public KeyEventQueueItem(AWTEvent evt) {
            this.ivEvent = evt;
            this.ivId = evt.getID();
        }
    }

    private static class Multicaster
    extends AWTEventMulticaster
    implements XI5250EmulatorListener {
        protected Multicaster(EventListener a, EventListener b) {
            super(a, b);
        }

        @Override
        protected EventListener remove(EventListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            EventListener a2 = Multicaster.removeInternal(this.a, oldl);
            EventListener b2 = Multicaster.removeInternal(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return Multicaster.add((XI5250EmulatorListener)a2, (XI5250EmulatorListener)b2);
        }

        public static XI5250EmulatorListener add(XI5250EmulatorListener a, XI5250EmulatorListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new Multicaster(a, b);
        }

        public static XI5250EmulatorListener remove(XI5250EmulatorListener a, XI5250EmulatorListener b) {
            return (XI5250EmulatorListener)Multicaster.removeInternal(a, b);
        }

        @Override
        public void connecting(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).connecting(e);
            ((XI5250EmulatorListener)this.b).connecting(e);
        }

        @Override
        public void connected(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).connected(e);
            ((XI5250EmulatorListener)this.b).connected(e);
        }

        @Override
        public void disconnected(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).disconnected(e);
            ((XI5250EmulatorListener)this.b).disconnected(e);
        }

        @Override
        public void stateChanged(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).stateChanged(e);
            ((XI5250EmulatorListener)this.b).stateChanged(e);
        }

        @Override
        public void newPanelReceived(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).newPanelReceived(e);
            ((XI5250EmulatorListener)this.b).newPanelReceived(e);
        }

        @Override
        public void fieldsRemoved(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).fieldsRemoved(e);
            ((XI5250EmulatorListener)this.b).fieldsRemoved(e);
        }

        @Override
        public void dataSended(XI5250EmulatorEvent e) {
            ((XI5250EmulatorListener)this.a).dataSended(e);
            ((XI5250EmulatorListener)this.b).dataSended(e);
        }
    }
}

