/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.infordata.em.tn5250.XI5250Cmd;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XIClearFmtTableCmd;
import net.infordata.em.tn5250.XIClearUnitAltCmd;
import net.infordata.em.tn5250.XIClearUnitCmd;
import net.infordata.em.tn5250.XIQueryCmd;
import net.infordata.em.tn5250.XIReadFieldsCmd;
import net.infordata.em.tn5250.XIReadImmediateCmd;
import net.infordata.em.tn5250.XIReadMdtFieldsCmd;
import net.infordata.em.tn5250.XIReadScreenCmd;
import net.infordata.em.tn5250.XIRestoreScreenCmd;
import net.infordata.em.tn5250.XIRollCmd;
import net.infordata.em.tn5250.XISaveScreenCmd;
import net.infordata.em.tn5250.XIWriteErrorCodeCmd;
import net.infordata.em.tn5250.XIWriteToDisplayCmd;
import net.infordata.em.tnprot.XITelnet;

public class XI5250CmdList
extends XI5250Cmd {
    private static final Logger LOGGER = Logger.getLogger(XI5250CmdList.class.getName());
    private static Class<?>[] cv5250CmdClasses = new Class[256];
    protected List<XI5250Cmd> ivCmdVect;
    protected boolean ivICOrderExecuted;

    protected XI5250CmdList(XI5250Emulator aEmulator) {
        this.init(aEmulator);
    }

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        int bb;
        this.ivCmdVect = new ArrayList<XI5250Cmd>(100);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("START OF COMMANDS LIST");
        }
        while ((bb = inStream.read()) != -1 && (byte)bb != 4) {
        }
        int i = 1;
        while ((bb = inStream.read()) != -1) {
            switch (i % 2) {
                case 0: {
                    if ((byte)bb == 4) break;
                    throw new XI5250Exception("Malformed 5250 packet", 10030101);
                }
                case 1: {
                    XI5250Cmd cmd = this.createCmdInstance(XITelnet.toInt((byte)bb));
                    if (cmd != null) {
                        cmd.init(this.ivEmulator);
                        cmd.readFrom5250Stream(inStream);
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("" + cmd);
                        }
                        this.ivCmdVect.add(cmd);
                        break;
                    }
                    throw new XI5250Exception("Command not supported : 0x" + XITelnet.toHex((byte)bb), 10030101);
                }
            }
            ++i;
        }
    }

    @Override
    protected void execute() {
        for (XI5250Cmd anIvCmdVect : this.ivCmdVect) {
            anIvCmdVect.execute();
        }
    }

    protected XI5250Cmd createCmdInstance(int aCmd) {
        Class<?> cls = cv5250CmdClasses[aCmd];
        if (cls != null) {
            try {
                return (XI5250Cmd)cls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String toString() {
        return super.toString() + this.ivCmdVect.toString();
    }

    static {
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)114)] = XIReadImmediateCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)66)] = XIReadFieldsCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)82)] = XIReadMdtFieldsCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)98)] = XIReadScreenCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)2)] = XISaveScreenCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)80)] = XIClearFmtTableCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)64)] = XIClearUnitCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)32)] = XIClearUnitAltCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)18)] = XIRestoreScreenCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)35)] = XIRollCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)33)] = XIWriteErrorCodeCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)17)] = XIWriteToDisplayCmd.class;
        XI5250CmdList.cv5250CmdClasses[XITelnet.toInt((byte)-13)] = XIQueryCmd.class;
    }
}

