/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250EmulatorCtrl;
import net.infordata.em.tn5250.XI5250Frame;
import net.infordata.em.tn5250.XIImagesBdl;
import net.infordata.em.util.XICommandMgr;
import net.infordata.em.util.XIUtil;

public class XI5250Applet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private static final int DEBUG = 0;
    private static final boolean UNDEAD_FRAME = false;
    private static XIImagesBdl cvImagesBdl = XIImagesBdl.getImagesBdl();
    private static ResourceBundle cvRes = ResourceBundle.getBundle("net.infordata.em.tn5250.resources.Res");
    private XI5250EmulatorCtrl ivEmulatorCtrl;
    private EmulatorFrame ivFrame;
    private boolean ivFirstTime = true;
    private boolean ivDestroyed = false;
    private PropertyChangeListener ivPropertyChangeListener = this::emulatorPropertyChanged;
    public static final String INFRAME_CMD = "INFRAME_CMD";

    protected XI5250Emulator createEmulator() {
        return new XI5250Emulator();
    }

    @Override
    public void init() {
        String host = this.getParameter("host");
        boolean inplace = true;
        String ss = this.getParameter("inplace");
        if (ss != null && "false".equals(ss.toLowerCase())) {
            inplace = false;
        }
        boolean p3dFX = "true".equalsIgnoreCase(this.getParameter("3dFX"));
        boolean altFKeyRemap = "true".equalsIgnoreCase(this.getParameter("altFKeyRemap"));
        String codePage = this.getParameter("codePage");
        boolean requestFocus = !"false".equalsIgnoreCase(this.getParameter("requestFocus"));
        boolean pSTRPCCMD = "true".equalsIgnoreCase(this.getParameter("STRPCCMD"));
        String deviceName = this.getParameter("devName");
        this.ivEmulatorCtrl = new XI5250EmulatorCtrl(this.createEmulator());
        this.getEmulator().setTerminalType("IBM-3477-FC");
        this.getEmulator().setKeyboardQueue(true);
        this.getEmulator().setHost(host);
        if (p3dFX) {
            this.getEmulator().setDefFieldsBorderStyle(3);
            this.getEmulator().setDefBackground(UIManager.getColor("control"));
        }
        this.getEmulator().setAltFKeyRemap(altFKeyRemap);
        this.getEmulator().setCodePage(codePage);
        this.getEmulator().setStrPcCmdEnabled(pSTRPCCMD);
        if (deviceName != null) {
            this.getEmulator().setTelnetEnv("\u0003DEVNAME\u0001" + deviceName);
        }
        if (inplace) {
            SwingUtilities.invokeLater(() -> {
                this.emulatorInPlace();
                if (requestFocus) {
                    this.getEmulator().requestFocusInWindow();
                }
            });
        } else {
            SwingUtilities.invokeLater(() -> {
                this.emulatorInFrame();
                if (requestFocus) {
                    this.getEmulator().requestFocusInWindow();
                }
            });
        }
        this.getCommandMgr().enableCommand(INFRAME_CMD, this.ivFrame == null);
        this.getCommandMgr().setCommand(INFRAME_CMD, this::processInFrameCmd);
    }

    @Override
    public void start() {
        if (this.getEmulator().getHost() != null) {
            SwingUtilities.invokeLater(() -> this.getEmulator().setActive(true));
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        this.ivDestroyed = true;
        this.emulatorInPlace();
        this.getEmulator().setActive(false);
    }

    public final XI5250Emulator getEmulator() {
        return this.ivEmulatorCtrl.getEmulator();
    }

    public final XICommandMgr getCommandMgr() {
        return this.ivEmulatorCtrl.getCommandMgr();
    }

    protected void processInFrameCmd() {
        this.emulatorInFrame();
    }

    protected void emulatorInPlace() {
        if (!this.ivFirstTime && this.ivFrame == null) {
            return;
        }
        this.ivFirstTime = false;
        if (this.ivFrame != null) {
            this.ivFrame.setJMenuBar(null);
            this.ivFrame.dispose();
            this.ivFrame = null;
        }
        this.getCommandMgr().enableCommand(INFRAME_CMD, true);
        JToolBar toolBar = this.createToolBar();
        JMenuBar menuBar = this.createMenuBar();
        this.setJMenuBar(menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)toolBar, "North");
        XI5250Crt.SupportPanel panel = new XI5250Crt.SupportPanel(this.getEmulator());
        panel.setBackground(this.getEmulator().getBackground());
        this.getContentPane().add((Component)panel, "Center");
        this.getEmulator().addPropertyChangeListener(this.ivPropertyChangeListener);
    }

    protected void emulatorInFrame() {
        if (this.ivFrame != null) {
            return;
        }
        this.getCommandMgr().enableCommand(INFRAME_CMD, false);
        this.getEmulator().removePropertyChangeListener(this.ivPropertyChangeListener);
        this.setJMenuBar(null);
        this.getContentPane().removeAll();
        this.validate();
        this.repaint();
        this.ivFrame = new EmulatorFrame("tn5250 1.19m", this.getEmulator());
        this.ivFrame.setBounds(0, 0, 648, 506);
        this.ivFrame.centerOnScreen();
        this.ivFrame.setVisible(true);
    }

    private void frameClosed() {
        this.emulatorInPlace();
        this.invalidate();
        this.validate();
        this.getEmulator().requestFocusInWindow();
    }

    private void emulatorPropertyChanged(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("background".equals(propertyName)) {
            this.getEmulator().getParent().setBackground(this.getEmulator().getBackground());
        } else if ("font".equals(propertyName) || "crtSize".equals(propertyName)) {
            this.getEmulator().revalidate();
        }
    }

    private JMenuBar createMenuBar() {
        String str = cvRes.getString("TXT_Communications");
        JMenu commMenu = new JMenu(XIUtil.removeMnemonics(str));
        commMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem connItem = new JMenuItem(cvRes.getString("TXT_Connect"));
        JMenuItem disconnItem = new JMenuItem(cvRes.getString("TXT_Disconnect"));
        JMenuItem aboutItem = new JMenuItem(cvRes.getString("TXT_About"));
        commMenu.add(connItem);
        commMenu.add(disconnItem);
        commMenu.addSeparator();
        commMenu.add(aboutItem);
        this.getCommandMgr().handleCommand(connItem, "CONNECT_CMD");
        this.getCommandMgr().handleCommand(disconnItem, "DISCONNECT_CMD");
        this.getCommandMgr().handleCommand(aboutItem, "ABOUT_CMD");
        str = cvRes.getString("TXT_Edit");
        JMenu editMenu = new JMenu(XIUtil.removeMnemonics(str));
        editMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem copyItem = new JMenuItem(cvRes.getString("TXT_Copy"));
        JMenuItem pasteItem = new JMenuItem(cvRes.getString("TXT_Paste"));
        JMenuItem snapShotItem = new JMenuItem(cvRes.getString("TXT_SnapShot"));
        JMenuItem printItem = new JMenuItem(cvRes.getString("TXT_Print"));
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.addSeparator();
        editMenu.add(snapShotItem);
        editMenu.addSeparator();
        editMenu.add(printItem);
        this.getCommandMgr().handleCommand(copyItem, "COPY_CMD");
        this.getCommandMgr().handleCommand(pasteItem, "PASTE_CMD");
        this.getCommandMgr().handleCommand(snapShotItem, "SNAPSHOT_CMD");
        this.getCommandMgr().handleCommand(printItem, "PRINT_CMD");
        str = cvRes.getString("TXT_Options");
        JMenu optionsMenu = new JMenu(XIUtil.removeMnemonics(str));
        optionsMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem inFrameItem = new JMenuItem(cvRes.getString("TXT_InFrame"));
        JCheckBoxMenuItem switch3DfxItem = new JCheckBoxMenuItem(cvRes.getString("TXT_3dFx"));
        JCheckBoxMenuItem referenceCursorItem = new JCheckBoxMenuItem(cvRes.getString("TXT_RefCursor"));
        optionsMenu.add(inFrameItem);
        optionsMenu.addSeparator();
        optionsMenu.add(switch3DfxItem);
        optionsMenu.add(referenceCursorItem);
        this.getCommandMgr().handleCommand(inFrameItem, INFRAME_CMD);
        this.getCommandMgr().handleCommand(switch3DfxItem, "SWITCH_3DFX_CMD");
        this.getCommandMgr().handleCommand(referenceCursorItem, "REFERENCE_CURSOR_CMD");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(commMenu);
        menuBar.add(editMenu);
        menuBar.add(optionsMenu);
        return menuBar;
    }

    private JToolBar createToolBar() {
        AbstractButton[] buttons = new AbstractButton[]{new JButton(cvImagesBdl.getIcon("Connect")), new JButton(cvImagesBdl.getIcon("Disconnect")), null, new JButton(cvImagesBdl.getIcon("Copy")), new JButton(cvImagesBdl.getIcon("Paste")), null, new JButton(cvImagesBdl.getIcon("SnapShot")), new JButton(cvImagesBdl.getIcon("Print")), null, new JButton(cvImagesBdl.getIcon("InFrame")), null, new JToggleButton(cvImagesBdl.getIcon("3dFx")), new JToggleButton(cvImagesBdl.getIcon("RefCursor"))};
        String[] buttonsActCmd = new String[]{"CONNECT_CMD", "DISCONNECT_CMD", null, "COPY_CMD", "PASTE_CMD", null, "SNAPSHOT_CMD", "PRINT_CMD", null, INFRAME_CMD, null, "SWITCH_3DFX_CMD", "REFERENCE_CURSOR_CMD"};
        String[] buttonHints = new String[]{cvRes.getString("TXT_Connect"), cvRes.getString("TXT_Disconnect"), null, cvRes.getString("TXT_Copy"), cvRes.getString("TXT_Paste"), null, cvRes.getString("TXT_SnapShot"), cvRes.getString("TXT_Print"), null, cvRes.getString("TXT_InFrame"), null, cvRes.getString("TXT_3dFx"), cvRes.getString("TXT_RefCursor")};
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        Dimension size = new Dimension(26, 26);
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] != null) {
                AbstractButton button = buttons[i];
                toolBar.add(button);
                button.setToolTipText(buttonHints[i]);
                button.setMinimumSize(size);
                button.setPreferredSize(size);
                button.setMaximumSize(size);
                button.setRequestFocusEnabled(false);
                this.getCommandMgr().handleCommand(button, buttonsActCmd[i]);
                continue;
            }
            toolBar.addSeparator();
        }
        return toolBar;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.ivFrame != null) {
            Rectangle rt = this.getBounds();
            g.setColor(Color.darkGray);
            int hh = rt.height;
            for (int x = -hh; x < rt.width; x += 16) {
                g.drawLine(x, hh, x + hh, 0);
            }
        }
    }

    private class EmulatorFrame
    extends XI5250Frame {
        private static final long serialVersionUID = 1L;

        public EmulatorFrame(String aTitle, XI5250Emulator aCrt) {
            super(aTitle, aCrt);
        }

        @Override
        protected void processExitCmd() {
            this.dispose();
        }

        @Override
        protected void processWindowEvent(WindowEvent e) {
            switch (e.getID()) {
                case 202: {
                    XI5250Applet.this.frameClosed();
                    return;
                }
            }
            super.processWindowEvent(e);
        }
    }
}

