/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.infordata.em.crt5250.XIEbcdicNTranslator;

public abstract class XIEbcdicTranslator {
    private static final Map<String, XIEbcdicTranslator> cvRegistry = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<String, XIEbcdicTranslator> cvRORegistry = Collections.unmodifiableMap(cvRegistry);

    protected XIEbcdicTranslator() {
    }

    public static synchronized void registerTranslator(String id, XIEbcdicTranslator tr) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (tr == null) {
            throw new NullPointerException("tr is null");
        }
        if (cvRegistry.containsKey(id.toLowerCase())) {
            throw new IllegalArgumentException("Translator " + id.toLowerCase() + " already registered");
        }
        cvRegistry.put(id.toLowerCase(), tr);
    }

    public static Map<String, XIEbcdicTranslator> getRegisteredTranslators() {
        return cvRORegistry;
    }

    public static XIEbcdicTranslator getTranslator(String id) {
        return cvRegistry.get(id.toLowerCase());
    }

    public static int toInt(byte bb) {
        return bb & 0xFF;
    }

    public static String toHex(byte bb) {
        String hex = Integer.toString(XIEbcdicTranslator.toInt(bb), 16);
        return "00".substring(hex.length()) + hex;
    }

    public abstract char toChar(byte var1);

    public abstract byte toEBCDIC(char var1);

    public byte[] toText(String aString, int aLen) {
        int i;
        byte[] bb = new byte[aLen];
        int len = Math.min(aLen, aString.length());
        for (i = 0; i < len; ++i) {
            bb[i] = this.toEBCDIC(aString.charAt(i));
        }
        for (i = len; i < aLen; ++i) {
            bb[i] = this.toEBCDIC(' ');
        }
        return bb;
    }

    public byte[] toNumeric(int aNum, int aLen) {
        byte[] bb = new byte[aLen];
        for (int i = aLen - 1; i >= 0; --i) {
            bb[i] = this.toEBCDIC((char)(48 + aNum % 10));
            aNum /= 10;
        }
        return bb;
    }

    public byte[] toPacked(int aNum, int aLen) {
        byte[] res = new byte[(aLen + 1) / 2];
        int i = res.length - 1;
        while (i >= 0) {
            int x;
            if (i == res.length - 1 && aNum < 0) {
                res[i] = 13;
            } else {
                x = aNum % 10;
                aNum /= 10;
                res[i] = (byte)x;
            }
            x = aNum % 10;
            aNum /= 10;
            int n = i--;
            res[n] = (byte)(res[n] | (byte)(x << 4));
        }
        return res;
    }

    public String toString(byte[] aBuf, int aOfs, int aLen) {
        int i;
        String str = "";
        for (i = aOfs; i < aOfs + aLen; ++i) {
            str = str + this.toChar(aBuf[i]);
        }
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return str.substring(0, Math.max(0, Math.min(str.length(), i + 1)));
    }

    public int toInt(byte[] aBuf, int aOfs, int aLen) {
        String str = this.toString(aBuf, aOfs, aLen);
        return Integer.parseInt(str);
    }

    public int toIntFromPacked(byte[] aBuf, int aOfs, int aLen) {
        int res = 0;
        for (int i = aOfs; i < aOfs + aLen; ++i) {
            res = res * 100 + (aBuf[i] >> 4 & 0xF) * 10;
            if ((aBuf[i] & 0xF) == 13) {
                res /= -10;
                continue;
            }
            if ((aBuf[i] & 0xF) == 15) {
                res /= 10;
                continue;
            }
            res += aBuf[i] & 0xF;
        }
        return res;
    }

    static {
        XIEbcdicTranslator.registerTranslator("CP37", XIEbcdicNTranslator.TRANSLATOR_CP37);
        XIEbcdicTranslator.registerTranslator("CP273", XIEbcdicNTranslator.TRANSLATOR_CP273);
        XIEbcdicTranslator.registerTranslator("CP277", XIEbcdicNTranslator.TRANSLATOR_CP277);
        XIEbcdicTranslator.registerTranslator("CP278", XIEbcdicNTranslator.TRANSLATOR_CP278);
        XIEbcdicTranslator.registerTranslator("CP280", XIEbcdicNTranslator.TRANSLATOR_CP280);
        XIEbcdicTranslator.registerTranslator("CP284", XIEbcdicNTranslator.TRANSLATOR_CP284);
        XIEbcdicTranslator.registerTranslator("CP285", XIEbcdicNTranslator.TRANSLATOR_CP285);
        XIEbcdicTranslator.registerTranslator("CP297", XIEbcdicNTranslator.TRANSLATOR_CP297);
        XIEbcdicTranslator.registerTranslator("CP424", XIEbcdicNTranslator.TRANSLATOR_CP424);
        XIEbcdicTranslator.registerTranslator("CP500", XIEbcdicNTranslator.TRANSLATOR_CP500);
        XIEbcdicTranslator.registerTranslator("CP850", XIEbcdicNTranslator.TRANSLATOR_CP850);
        XIEbcdicTranslator.registerTranslator("CP870", XIEbcdicNTranslator.TRANSLATOR_CP870);
        XIEbcdicTranslator.registerTranslator("CP838", XIEbcdicNTranslator.TRANSLATOR_CP838);
        XIEbcdicTranslator.registerTranslator("CP1140", XIEbcdicNTranslator.TRANSLATOR_CP1140);
        XIEbcdicTranslator.registerTranslator("CP1141", XIEbcdicNTranslator.TRANSLATOR_CP1141);
        XIEbcdicTranslator.registerTranslator("CP1144", XIEbcdicNTranslator.TRANSLATOR_CP1144);
        XIEbcdicTranslator.registerTranslator("CP1147", XIEbcdicNTranslator.TRANSLATOR_CP1147);
        XIEbcdicTranslator.registerTranslator("CP1153", XIEbcdicNTranslator.TRANSLATOR_CP1153);
        XIEbcdicTranslator.registerTranslator("CP1160", XIEbcdicNTranslator.TRANSLATOR_CP1160);
        XIEbcdicTranslator.registerTranslator("CP1025", XIEbcdicNTranslator.TRANSLATOR_CP1025);
        XIEbcdicTranslator.registerTranslator("CP1026", XIEbcdicNTranslator.TRANSLATOR_CP1026);
        XIEbcdicTranslator.registerTranslator("CP1112", XIEbcdicNTranslator.TRANSLATOR_CP1112);
        XIEbcdicTranslator.registerTranslator("CP1122", XIEbcdicNTranslator.TRANSLATOR_CP1122);
        XIEbcdicTranslator.registerTranslator("CP1123", XIEbcdicNTranslator.TRANSLATOR_CP1123);
        XIEbcdicTranslator.registerTranslator("CP1125", XIEbcdicNTranslator.TRANSLATOR_CP1125);
        XIEbcdicTranslator.registerTranslator("CP1130", XIEbcdicNTranslator.TRANSLATOR_CP1130);
        XIEbcdicTranslator.registerTranslator("CP1132", XIEbcdicNTranslator.TRANSLATOR_CP1132);
        XIEbcdicTranslator.registerTranslator("CP1137", XIEbcdicNTranslator.TRANSLATOR_CP1137);
        XIEbcdicTranslator.registerTranslator("CP1142", XIEbcdicNTranslator.TRANSLATOR_CP1142);
        XIEbcdicTranslator.registerTranslator("CP1145", XIEbcdicNTranslator.TRANSLATOR_CP1145);
        XIEbcdicTranslator.registerTranslator("CP1146", XIEbcdicNTranslator.TRANSLATOR_CP1146);
        XIEbcdicTranslator.registerTranslator("CP1148", XIEbcdicNTranslator.TRANSLATOR_CP1148);
        XIEbcdicTranslator.registerTranslator("CP1149", XIEbcdicNTranslator.TRANSLATOR_CP1149);
        XIEbcdicTranslator.registerTranslator("CP1154", XIEbcdicNTranslator.TRANSLATOR_CP1154);
        XIEbcdicTranslator.registerTranslator("CP1155", XIEbcdicNTranslator.TRANSLATOR_CP1155);
        XIEbcdicTranslator.registerTranslator("CP1156", XIEbcdicNTranslator.TRANSLATOR_CP1156);
        XIEbcdicTranslator.registerTranslator("CP1157", XIEbcdicNTranslator.TRANSLATOR_CP1157);
        XIEbcdicTranslator.registerTranslator("CP1158", XIEbcdicNTranslator.TRANSLATOR_CP1158);
        XIEbcdicTranslator.registerTranslator("CP1164", XIEbcdicNTranslator.TRANSLATOR_CP1164);
        XIEbcdicTranslator.registerTranslator("CP420", XIEbcdicNTranslator.TRANSLATOR_CP420);
        XIEbcdicTranslator.registerTranslator("CP871", XIEbcdicNTranslator.TRANSLATOR_CP871);
        XIEbcdicTranslator.registerTranslator("CP875", XIEbcdicNTranslator.TRANSLATOR_CP875);
    }
}

