/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.util.XICommandMgr;

public class XI5250CrtCtrl {
    private static final Logger LOGGER = Logger.getLogger(XI5250CrtCtrl.class.getName());
    private XI5250Crt ivCrt;
    private XICommandMgr ivCommandMgr = new XICommandMgr();
    public static final String SWITCH_3DFX_CMD = "SWITCH_3DFX_CMD";
    public static final String REFERENCE_CURSOR_CMD = "REFERENCE_CURSOR_CMD";
    public static final String COPY_CMD = "COPY_CMD";
    public static final String PASTE_CMD = "PASTE_CMD";
    public static final String PRINT_CMD = "PRINT_CMD";

    public XI5250CrtCtrl(XI5250Crt aCrt) {
        if (aCrt == null) {
            throw new IllegalArgumentException("An XI5250Crt instance is required.");
        }
        this.ivCrt = aCrt;
        this.ivCrt.addPropertyChangeListener(new PropertyListener());
        this.getCommandMgr().enableCommand(COPY_CMD, this.ivCrt.getSelectedArea() != null);
        this.getCommandMgr().setCommand(COPY_CMD, this::processCopyCmd);
        this.getCommandMgr().setCommand(PASTE_CMD, this::processPasteCmd);
        this.getCommandMgr().setCommandState(SWITCH_3DFX_CMD, this.is3DFX());
        this.getCommandMgr().setCommand(SWITCH_3DFX_CMD, this::processSwitch3dFxCmd);
        this.getCommandMgr().setCommandState(REFERENCE_CURSOR_CMD, this.ivCrt.isReferenceCursor());
        this.getCommandMgr().setCommand(REFERENCE_CURSOR_CMD, this::processReferenceCursorCmd);
        this.getCommandMgr().setCommand(PRINT_CMD, this::processPrintCmd);
    }

    public final XI5250Crt getCrt() {
        return this.ivCrt;
    }

    public final XICommandMgr getCommandMgr() {
        return this.ivCommandMgr;
    }

    public final boolean is3DFX() {
        return this.getCrt().getDefFieldsBorderStyle() == 3;
    }

    protected void processCopyCmd() {
        this.getCrt().processRawKeyEvent(new KeyEvent(this.getCrt(), 401, 0L, 2, 155, '\u009b'));
    }

    protected void processPasteCmd() {
        this.getCrt().processRawKeyEvent(new KeyEvent(this.getCrt(), 401, 0L, 1, 155, '\u009b'));
    }

    protected void processSwitch3dFxCmd() {
        boolean flag = this.getCommandMgr().getCommandState(SWITCH_3DFX_CMD);
        if (flag) {
            this.getCrt().setDefFieldsBorderStyle(3);
            this.getCrt().setDefBackground(UIManager.getColor("control"));
        } else {
            this.getCrt().setDefFieldsBorderStyle(1);
            this.getCrt().setDefBackground(SystemColor.black);
        }
    }

    protected void processReferenceCursorCmd() {
        boolean flag = this.getCommandMgr().getCommandState(REFERENCE_CURSOR_CMD);
        this.getCrt().setReferenceCursor(flag);
    }

    protected void emulatorPropertyChanged(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == "selectedArea") {
            this.getCommandMgr().enableCommand(COPY_CMD, this.getCrt().getSelectedArea() != null);
        } else if (propertyName == "defFieldsBorderStyle") {
            this.getCommandMgr().setCommandState(SWITCH_3DFX_CMD, this.is3DFX());
        } else if (propertyName == "referenceCursor") {
            this.getCommandMgr().setCommandState(REFERENCE_CURSOR_CMD, this.getCrt().isReferenceCursor());
        }
    }

    protected void processPrintCmd() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable((graphics, pageFormat, pageIndex) -> {
            if (pageIndex > 0) {
                return 1;
            }
            int imgWidth = (int)pageFormat.getImageableWidth();
            int imgHeight = (int)pageFormat.getImageableHeight();
            XI5250Crt crt = this.getCrt();
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            int w = crt.getSize().width;
            int h = crt.getSize().height;
            double scale = Math.min((double)imgWidth / (double)w, (double)imgHeight / (double)h);
            g2d.scale(scale, scale);
            Object object = crt.getTreeLock();
            synchronized (object) {
                XI5250Crt xI5250Crt = crt;
                synchronized (xI5250Crt) {
                    Color oldBG = crt.getDefBackground();
                    try {
                        crt.setDefBackground(SystemColor.white);
                        crt.printAll(g2d);
                    }
                    finally {
                        crt.setDefBackground(oldBG);
                    }
                }
            }
            return 0;
        });
        boolean doPrint = job.printDialog();
        if (doPrint) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                LOGGER.log(Level.SEVERE, "caughtException()", ex);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(XI5250CrtCtrl.this.getCrt(), ex.getMessage() + "\nSee the log for details ", "ERROR", 0);
                    }
                });
            }
        }
    }

    class PropertyListener
    implements PropertyChangeListener {
        PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            XI5250CrtCtrl.this.emulatorPropertyChanged(e);
        }
    }
}

