/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import net.infordata.em.crt.XICrtBuffer;
import net.infordata.em.util.XIUtil;

public class XICrt
extends JComponent
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int DEBUG = 0;
    public static final int MIN_FONT_SIZE = 1;
    public static final int MAX_FONT_SIZE = 50;
    private transient VolatileImage ivImage;
    private XICrtBuffer ivCrtBuffer;
    private transient boolean ivFreeze = false;
    private transient int ivRepaintCount;
    private transient Rectangle ivSumRect;
    private transient CursorBlinkingThread ivBlinkThread;
    private transient int ivMinCharW;
    private transient int ivMinCharH;
    private transient boolean ivInitialized;
    private Font ivFont;
    private transient FontsCache ivFontsCache;
    public static final String CRT_SIZE = "crtSize";
    private transient Cursor ivCursor = new Cursor();
    private static final CursorShape cvDefaultCursorShape = new DefaultCursorShape();
    private static final CursorShape cvVoidCursorShape = new VoidCursorShape();

    public XICrt() {
        this.setFreeze(true);
        this.setOpaque(true);
        this.setFont(new Font("Monospaced", 0, 1));
        this.setLayout(null);
        this.setCrtBuffer(this.createCrtBuffer(80, 24));
        this.setBackground(Color.black);
    }

    protected XICrtBuffer createCrtBuffer(int nCols, int nRows) {
        return new XICrtBuffer(nCols, nRows);
    }

    @Override
    public void setFont(Font aFont) {
        if (aFont.getSize() < 1) {
            throw new IllegalArgumentException("Font too small");
        }
        if (aFont.getSize() > 50) {
            throw new IllegalArgumentException("Font too great");
        }
        if (aFont.equals(this.ivFont)) {
            return;
        }
        if (this.ivFont == null || !aFont.getName().equals(this.ivFont.getName()) || aFont.getStyle() != this.ivFont.getStyle()) {
            this.ivFontsCache = new FontsCache(aFont);
        }
        this.ivFont = aFont;
        super.setFont(this.ivFont);
        if (this.ivInitialized) {
            this.initializeCrtBuffer();
        }
    }

    @Override
    public Font getFont() {
        return this.ivFont;
    }

    private Graphics initializeVolatileImage() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int ww = fontMetrics.charWidth('W');
        int hh = fontMetrics.getHeight();
        this.ivImage = this.createVolatileImage(this.ivCrtBuffer.getCrtSize().width * ww, this.ivCrtBuffer.getCrtSize().height * hh);
        Graphics gr = this.ivImage.getGraphics();
        gr.setFont(font);
        fontMetrics = this.getFontMetrics(new Font(font.getName(), font.getStyle(), 1));
        this.ivMinCharW = fontMetrics.charWidth('W');
        this.ivMinCharH = fontMetrics.getHeight();
        return gr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCrtBuffer() {
        XICrt xICrt = this;
        synchronized (xICrt) {
            this.ivCrtBuffer.setGraphics(this.initializeVolatileImage());
            this.repaint();
        }
        super.invalidate();
    }

    @Override
    public void invalidate() {
        if (this.ivInitialized) {
            this.recalcFontSize();
        }
        super.invalidate();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.ivInitialized) {
            this.ivInitialized = true;
            this.initializeCrtBuffer();
            this.setFreeze(false);
        }
    }

    @Override
    public void removeNotify() {
        this.ivInitialized = false;
        this.setFreeze(true);
        super.removeNotify();
        this.ivCrtBuffer.setGraphics(null);
        this.setFont(new Font("Monospaced", 0, 1));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.ivCrtBuffer.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.ivMinCharW * this.ivCrtBuffer.getCrtSize().width, this.ivMinCharH * this.ivCrtBuffer.getCrtSize().height);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
        if (!this.ivFreeze) {
            super.repaint(tm, x, y, width, height);
        } else {
            ++this.ivRepaintCount;
            this.ivSumRect = this.ivSumRect.union(new Rectangle(x, y, width, height));
        }
    }

    public synchronized void setFreeze(boolean bb) {
        if (bb == this.ivFreeze) {
            return;
        }
        this.ivFreeze = bb;
        if (!this.ivFreeze) {
            if (this.ivRepaintCount > 0) {
                this.repaint(this.ivSumRect.x, this.ivSumRect.y, this.ivSumRect.width, this.ivSumRect.height);
            }
            this.ivSumRect = null;
            this.ivRepaintCount = 0;
            this.ivCursor.resync();
        } else {
            this.ivSumRect = new Rectangle();
        }
    }

    public final boolean isFreeze() {
        return this.ivFreeze;
    }

    @Override
    public final void paint(Graphics g) {
        this.ivCursor.beforePaint(g);
        try {
            super.paint(g);
        }
        finally {
            this.ivCursor.afterPaint(g);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void paintComponent(Graphics g) {
        if (this.ivImage != null) {
            GraphicsConfiguration gconf = this.getGraphicsConfiguration();
            XICrtBuffer xICrtBuffer = this.ivCrtBuffer;
            synchronized (xICrtBuffer) {
                int returnCode = this.ivImage.validate(gconf);
                if (returnCode == 1) {
                    this.ivCrtBuffer.invalidateAll();
                } else if (returnCode == 2) {
                    this.ivCrtBuffer.setGraphics(this.initializeVolatileImage());
                    this.ivCrtBuffer.invalidateAll();
                }
                this.ivCrtBuffer.sync();
                g.drawImage(this.ivImage, 0, 0, null);
            }
        }
        if (this.isOpaque()) {
            Dimension crtBuf = this.getCrtBufferSize();
            Dimension crt = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(crtBuf.width, 0, crt.width - crtBuf.width, crt.height);
            g.fillRect(0, crtBuf.height, crt.width, crt.height - crtBuf.height);
        }
        this.foregroundPaint(g);
    }

    protected void foregroundPaint(Graphics g) {
        super.paintComponent(g);
    }

    public void clear() {
        this.ivCrtBuffer.clear();
        this.repaint();
    }

    public void scroll(boolean down, int row1, int row2, int nLines) {
        if (down) {
            this.ivCrtBuffer.scrollDown(row1, row2, nLines);
        } else {
            this.ivCrtBuffer.scrollUp(row1, row2, nLines);
        }
        this.repaint(0, row1 * this.ivCrtBuffer.getCharSize().height, this.ivCrtBuffer.getSize().width, (row2 - row1) * this.ivCrtBuffer.getCharSize().height);
    }

    public void drawString(String str, int col, int row) {
        this.drawString(str, col, row, this.ivCrtBuffer.getDefAttr());
    }

    public void drawString(String str, int col, int row, int aAttr) {
        this.ivCrtBuffer.drawString(str, col, row, aAttr);
        this.repaint(col * this.ivCrtBuffer.getCharSize().width, row * this.ivCrtBuffer.getCharSize().height, str.length() * this.ivCrtBuffer.getCharSize().width, this.ivCrtBuffer.getCharSize().height);
    }

    public String getString(int col, int row, int nChars) {
        return this.ivCrtBuffer.getString(col, row, nChars);
    }

    public String getString() {
        return this.ivCrtBuffer.getString();
    }

    public int getAttr(int col, int row) {
        return this.ivCrtBuffer.getAttr(col, row);
    }

    public char getChar(int col, int row) {
        return this.ivCrtBuffer.getChar(col, row);
    }

    public void setDefAttr(int aAttr) {
        this.ivCrtBuffer.setDefAttr(aAttr);
    }

    protected final int assureColIn(int aCol) {
        return Math.max(0, Math.min(this.ivCrtBuffer.getCrtSize().width - 1, aCol));
    }

    protected final int assureRowIn(int aRow) {
        return Math.max(0, Math.min(this.ivCrtBuffer.getCrtSize().height - 1, aRow));
    }

    public void setCursorPos(int aCol, int aRow) {
        this.ivCursor.setPosition(this.assureColIn(aCol), this.assureRowIn(aRow));
    }

    public int getCursorCol() {
        return this.ivCursor.getCol();
    }

    public int getCursorRow() {
        return this.ivCursor.getRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCrtSize(int nCols, int nRows) {
        XICrt xICrt = this;
        synchronized (xICrt) {
            Dimension dim = this.ivCrtBuffer.getCrtSize();
            if (dim.width == nCols && dim.height == nRows) {
                return;
            }
            XICrtBuffer newCrtBuffer = this.createCrtBuffer(nCols, nRows);
            this.setCrtBuffer(newCrtBuffer);
            if (this.ivInitialized) {
                this.ivCrtBuffer.setGraphics(this.ivImage.getGraphics());
            }
        }
        this.setCursorPos(0, 0);
        this.repaint();
        this.invalidate();
        this.firePropertyChange(CRT_SIZE, null, null);
    }

    public Dimension getCrtSize() {
        return this.ivCrtBuffer.getCrtSize();
    }

    protected final void setCrtBuffer(XICrtBuffer aCrt) {
        if (aCrt == this.ivCrtBuffer) {
            return;
        }
        if (aCrt.getCrt() != null) {
            throw new IllegalArgumentException("Buffer already associated with a crt");
        }
        if (this.ivCrtBuffer != null) {
            this.ivCrtBuffer.setCrt(null);
        }
        this.ivCrtBuffer = aCrt;
        if (this.ivCrtBuffer != null) {
            this.ivCrtBuffer.setCrt(this);
        }
    }

    protected final XICrtBuffer getCrtBuffer() {
        return this.ivCrtBuffer;
    }

    public Dimension getCrtBufferSize() {
        return this.ivCrtBuffer.getSize();
    }

    public Dimension getCharSize() {
        return this.ivCrtBuffer.getCharSize();
    }

    public Dimension getMinCharSize() {
        return new Dimension(this.ivMinCharW, this.ivMinCharH);
    }

    protected Rectangle getCursorRect() {
        return this.ivCursor.getBoundingRect();
    }

    public void setCursorVisible(boolean aFlag) {
        this.ivCursor.setVisible(aFlag);
    }

    public final boolean isCursorVisible() {
        return this.ivCursor.isVisible();
    }

    public synchronized void setBlinkingCursor(boolean flag) {
        if (flag == (this.ivBlinkThread != null)) {
            return;
        }
        if (flag) {
            this.ivBlinkThread = new CursorBlinkingThread();
            this.ivBlinkThread.setPriority(4);
            this.ivBlinkThread.start();
        } else {
            this.ivBlinkThread.terminate();
            this.ivBlinkThread = null;
        }
        this.ivCursor.resync();
    }

    public boolean isBlinkingCursor() {
        return this.ivBlinkThread != null;
    }

    protected Dimension getTestSize(Font aFont) {
        FontMetrics fm = this.getFontMetrics(aFont);
        return new Dimension(fm.charWidth('W') * this.getCrtSize().width, fm.getHeight() * this.getCrtSize().height);
    }

    private void recalcFontSize() {
        int j;
        Font ft;
        int i;
        Font font = this.getFont();
        Dimension size = this.getSize();
        Font xFont = font;
        Font yFont = font;
        int startIdx = 1;
        if (size.width < this.ivCrtBuffer.getSize().width || font.getSize() > 1 && this.getTestSize((Font)this.ivFontsCache.getFont((int)(font.getSize() - 1))).width >= size.width) {
            for (i = xFont.getSize(); i >= 1; i -= 4) {
                ft = this.ivFontsCache.getFont(i);
                if (this.getTestSize((Font)ft).width <= size.width) {
                    xFont = ft;
                    break;
                }
                xFont = ft;
            }
            startIdx = 0;
        }
        block1: for (j = startIdx; j >= 0; --j) {
            for (i = xFont.getSize(); i <= 50; i += 1 + j * 3) {
                ft = this.ivFontsCache.getFont(i);
                if (this.getTestSize((Font)ft).width > size.width) continue block1;
                xFont = ft;
            }
        }
        startIdx = 1;
        if (size.height < this.ivCrtBuffer.getSize().height || font.getSize() > 1 && this.getTestSize((Font)this.ivFontsCache.getFont((int)(font.getSize() - 1))).height >= size.height) {
            for (i = yFont.getSize(); i >= 1; i -= 4) {
                ft = this.ivFontsCache.getFont(i);
                if (this.getTestSize((Font)ft).height <= size.height) {
                    yFont = ft;
                    break;
                }
                yFont = ft;
            }
            startIdx = 0;
        }
        block4: for (j = startIdx; j >= 0; --j) {
            for (i = yFont.getSize(); i <= 50; i += 1 + j * 3) {
                ft = this.ivFontsCache.getFont(i);
                if (this.getTestSize((Font)ft).height > size.height) continue block4;
                yFont = ft;
            }
        }
        this.setFont(this.ivFontsCache.getFont(Math.min(xFont.getSize(), yFont.getSize())));
    }

    public final Point toPoints(int aCol, int aRow) {
        return this.ivCrtBuffer.toPoints(aCol, aRow);
    }

    public final Rectangle toPoints(int aCol, int aRow, int aNCols, int aNRows) {
        return this.ivCrtBuffer.toPoints(aCol, aRow, aNCols, aNRows);
    }

    protected void finalize() throws Throwable {
        this.setBlinkingCursor(false);
        super.finalize();
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected CursorShape getCursorShape() {
        return cvDefaultCursorShape;
    }

    protected CursorShape getFixedCursorShape() {
        return null;
    }

    public static void main(String[] argv) {
        JFrame frm = new JFrame();
        XICrt crt = new XICrt();
        crt.drawString("eccome!", 0, 1);
        crt.setBackground(Color.yellow);
        frm.getContentPane().add(crt);
        frm.setBounds(0, 0, 600, 500);
        frm.setVisible(true);
        crt.setCursorVisible(true);
        crt.drawString("CIAO", 0, 0);
        crt.drawString("X", 79, 23);
        System.out.println(crt.ivCrtBuffer.getChar(79, 23));
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        crt.drawString("ARICIAO", 20, 0);
        System.out.println("end.");
    }

    private class CursorPlaceHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int ivCol;
        private int ivRow;
        private transient CursorShape ivCursorShape;
        private transient CursorShape ivFixedCursorShape;
        private transient boolean ivFixedCursorDrawed;
        private transient boolean ivCursorDrawed;

        public CursorPlaceHolder(int col, int row) {
            this.ivCol = col;
            this.ivRow = row;
        }

        public final int getCol() {
            return this.ivCol;
        }

        public final int getRow() {
            return this.ivRow;
        }

        public Rectangle getBoundingRect() {
            Dimension sz = XICrt.this.ivCrtBuffer.getCharSize();
            Point pt = XICrt.this.ivCrtBuffer.toPoint(this.ivCol, this.ivRow);
            return new Rectangle(pt.x, pt.y - sz.height, sz.width, sz.height);
        }

        private void retrieveShapes() {
            if (this.ivCursorShape == null) {
                this.ivCursorShape = XICrt.this.getCursorShape();
                if (this.ivCursorShape == null) {
                    this.ivCursorShape = cvVoidCursorShape;
                }
            }
            if (this.ivFixedCursorShape == null) {
                this.ivFixedCursorShape = XICrt.this.getFixedCursorShape();
                if (this.ivFixedCursorShape == null) {
                    this.ivFixedCursorShape = cvVoidCursorShape;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawShapes(boolean blinkingShapeOnly, Graphics aGc, boolean showIt) {
            Graphics gc;
            boolean bl = showIt = showIt && XICrt.this.isCursorVisible();
            if (showIt == this.ivCursorDrawed && showIt == this.ivFixedCursorDrawed) {
                return;
            }
            this.retrieveShapes();
            Graphics graphics = gc = aGc != null ? aGc : XICrt.this.getGraphics();
            if (gc == null) {
                return;
            }
            try {
                if (this.ivCursorDrawed != showIt) {
                    this.ivCursorShape.drawCursorShape(gc, this.getBoundingRect());
                    this.ivCursorDrawed = showIt;
                }
                if (this.ivFixedCursorDrawed != showIt && !blinkingShapeOnly) {
                    if (XIUtil.is1dot2 && !XIUtil.is1dot3 && aGc == null) {
                        gc.translate(-1, -1);
                    }
                    this.ivFixedCursorShape.drawCursorShape(gc, this.getBoundingRect());
                    this.ivFixedCursorDrawed = showIt;
                }
            }
            finally {
                if (aGc == null) {
                    gc.dispose();
                }
            }
        }

        public void syncShapesAfterPaint(Graphics gc) {
            if (gc == null) {
                throw new IllegalArgumentException();
            }
            this.retrieveShapes();
            if (this.ivCursorDrawed) {
                this.ivCursorShape.drawCursorShape(gc, this.getBoundingRect());
            }
            if (this.ivFixedCursorDrawed) {
                this.ivFixedCursorShape.drawCursorShape(gc, this.getBoundingRect());
            }
        }
    }

    private class Cursor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient List<CursorPlaceHolder> ivCursorsPH = new ArrayList<CursorPlaceHolder>(10);
        private CursorPlaceHolder ivCurrentCursorPH = new CursorPlaceHolder(0, 0);
        private boolean ivVisible = true;
        private transient int ivPending = 0;
        private transient int ivPendingBlink = 0;
        private transient Runnable ivPendingEvent = () -> {
            this.ivPending = 0;
            this.sync(false, null, true);
        };
        private transient Runnable ivPendingBlinkEvent = new Runnable(){
            private boolean flag;

            @Override
            public void run() {
                Cursor.this.ivPendingBlink = 0;
                this.flag = !this.flag;
                Cursor.this.sync(true, null, this.flag);
            }
        };

        private Cursor() {
        }

        public void resync() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.ivPendingEvent.run();
            } else if (this.ivPending++ == 0) {
                SwingUtilities.invokeLater(this.ivPendingEvent);
            }
        }

        public void blink() {
            if (SwingUtilities.isEventDispatchThread()) {
                this.ivPendingBlinkEvent.run();
            } else if (this.ivPendingBlink++ == 0) {
                SwingUtilities.invokeLater(this.ivPendingBlinkEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(int col, int row) {
            List<CursorPlaceHolder> list = this.ivCursorsPH;
            synchronized (list) {
                if (col == this.getCol() && row == this.getRow()) {
                    return;
                }
                this.ivCursorsPH.add(this.ivCurrentCursorPH);
                this.ivCurrentCursorPH = new CursorPlaceHolder(col, row);
            }
            this.resync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVisible(boolean flag) {
            List<CursorPlaceHolder> list = this.ivCursorsPH;
            synchronized (list) {
                if (flag == this.ivVisible) {
                    return;
                }
                this.ivVisible = flag;
                this.ivCursorsPH.add(this.ivCurrentCursorPH);
                this.ivCurrentCursorPH = new CursorPlaceHolder(this.getCol(), this.getRow());
            }
            this.resync();
        }

        public final int getCol() {
            return this.ivCurrentCursorPH.getCol();
        }

        public final int getRow() {
            return this.ivCurrentCursorPH.getRow();
        }

        public final boolean isVisible() {
            return this.ivVisible;
        }

        public Rectangle getBoundingRect() {
            return this.ivCurrentCursorPH.getBoundingRect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync(boolean blinkingShapeOnly, Graphics aGc, boolean showIt) {
            List<CursorPlaceHolder> list = this.ivCursorsPH;
            synchronized (list) {
                Graphics gc = aGc != null ? aGc : (XIUtil.is1dot2 && !XIUtil.is1dot3 ? null : XICrt.this.getGraphics());
                try {
                    Iterator<CursorPlaceHolder> e = this.ivCursorsPH.iterator();
                    while (e.hasNext()) {
                        e.next().drawShapes(false, gc, false);
                    }
                    this.ivCursorsPH.clear();
                    this.ivCurrentCursorPH.drawShapes(blinkingShapeOnly, gc, showIt);
                }
                finally {
                    if (aGc == null && gc != null) {
                        gc.dispose();
                    }
                }
            }
        }

        protected void beforePaint(Graphics g) {
        }

        protected void afterPaint(Graphics g) {
            Iterator<CursorPlaceHolder> e = this.ivCursorsPH.iterator();
            while (e.hasNext()) {
                e.next().syncShapesAfterPaint(g);
            }
            this.ivCurrentCursorPH.syncShapesAfterPaint(g);
        }
    }

    public static class DefaultCursorShape
    implements CursorShape {
        @Override
        public void drawCursorShape(Graphics gc, Rectangle rt) {
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            gc.fillRect(rt.x, rt.y, rt.width, rt.height);
            gc.setPaintMode();
        }
    }

    public static class VoidCursorShape
    implements CursorShape {
        @Override
        public void drawCursorShape(Graphics gc, Rectangle rt) {
        }
    }

    public static interface CursorShape {
        public void drawCursorShape(Graphics var1, Rectangle var2);
    }

    private class CursorBlinkingThread
    extends Thread {
        private volatile boolean ivTerminate;

        public CursorBlinkingThread() {
            super("XICrt cursor blinking thread");
            this.ivTerminate = false;
        }

        public void terminate() {
            this.ivTerminate = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.ivTerminate) {
                if (XICrt.this.isCursorVisible()) {
                    XICrt.this.ivCursor.blink();
                }
                try {
                    Thread.sleep(700L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class FontsCache {
        private Font[] ivFonts = new Font[50];
        private Font ivFont;

        public FontsCache(Font font) {
            this.ivFont = font;
        }

        public Font getFont(int size) {
            if (this.ivFonts[size - 1] == null) {
                this.ivFonts[size - 1] = new Font(this.ivFont.getName(), this.ivFont.getStyle(), size);
            }
            return this.ivFonts[size - 1];
        }
    }
}

