/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.net.SocketFactory;
import net.infordata.em.ExceptionHandler;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250EmulatorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalClient {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalClient.class);
    private TerminalClientEmulator emulator = new TerminalClientEmulator();

    public void setTerminalType(String terminalType) {
        this.emulator.setTerminalType(terminalType);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.emulator.setExceptionHandler(exceptionHandler);
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.emulator.setSocketFactory(socketFactory);
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.emulator.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    public void connect(String host, int port) {
        this.emulator.setHost(host);
        this.emulator.setPort(port);
        this.emulator.setActive(true);
    }

    public void setFieldTextByCoord(int row, int column, String text) {
        XI5250Field field = this.emulator.getFieldFromPos(column - 1, row - 1);
        if (field == null) {
            throw new IllegalArgumentException("Invalid field position " + row + "," + column);
        }
        field.setString(text);
        this.updateCursorPosition(text, column - 1, row - 1);
    }

    @VisibleForTesting
    public void updateCursorPosition(String text, int col, int row) {
        this.emulator.setCursorPos((col + text.length()) % this.emulator.getCrtSize().width, row + (col + text.length()) / this.emulator.getCrtSize().width);
    }

    public void setFieldTextByLabel(String label, String text) {
        XI5250Field field = this.emulator.getFieldNextTo(label);
        if (field == null) {
            throw new IllegalArgumentException("Invalid label" + label);
        }
        field.setString(text);
        this.updateCursorPosition(text, field.getCol(), field.getRow());
    }

    public void setFieldTextByTabulator(int tabs, String text) {
        int row = this.emulator.getCursorRow();
        int col = this.emulator.getCursorCol();
        XI5250Field field = this.emulator.getFieldFromPos(col, row);
        for (int i = tabs; i > 0; --i) {
            field = this.emulator.getNextFieldFromPos(col, row);
            row = field.getRow();
            col = field.getCol();
        }
        if (field == null) {
            throw new NoSuchElementException("No field found ");
        }
        String str = field.getTrimmedString() + text;
        field.setString(str);
        this.updateCursorPosition(text, field.getCol(), field.getRow());
    }

    public void sendKeyEvent(int keyCode, int modifiers) {
        this.emulator.processRawKeyEvent(new KeyEvent(this.emulator, 401, 0L, modifiers, keyCode, '\uffff'));
    }

    public String getScreenText() {
        int height = this.emulator.getCrtSize().height;
        int width = this.emulator.getCrtSize().width;
        StringBuilder screen = new StringBuilder();
        for (int i = 0; i < height; ++i) {
            screen.append(this.emulator.getString(0, i, width).replaceAll("[\\x00-\\x19]", " "));
            screen.append("\n");
        }
        return screen.toString();
    }

    public List<XI5250Field> getFields() {
        return this.emulator.getFields();
    }

    public Dimension getScreenDimensions() {
        return this.emulator.getCrtSize();
    }

    public boolean isKeyboardLocked() {
        int state = this.emulator.getState();
        switch (state) {
            case -2: 
            case -1: 
            case 1: 
            case 4: 
            case 8: {
                return true;
            }
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        LOG.warn("Unexpected state: {}", (Object)state);
        return false;
    }

    public Optional<Point> getCursorPosition() {
        return this.emulator.isCursorVisible() ? Optional.of(new Point(this.emulator.getCursorCol() + 1, this.emulator.getCursorRow() + 1)) : Optional.empty();
    }

    public void setCursorPosition(int row, int column) {
        this.emulator.setCursorPos(column, row);
    }

    public boolean isAlarmOn() {
        return this.emulator.isAlarmOn();
    }

    public boolean resetAlarm() {
        return this.emulator.resetAlarm();
    }

    public void addEmulatorListener(XI5250EmulatorListener listener) {
        this.emulator.addEmulatorListener(listener);
    }

    public void removeEmulatorListener(XI5250EmulatorListener listener) {
        this.emulator.removeEmulatorListener(listener);
    }

    public void disconnect() {
        this.emulator.setActive(false);
    }

    private static class TerminalClientEmulator
    extends XI5250Emulator {
        private ExceptionHandler exceptionHandler;
        private boolean alarmSounded;

        private TerminalClientEmulator() {
            this.setDisconnectOnSocketException(false);
        }

        private void setExceptionHandler(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        protected void caughtIOException(IOException ex) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onException(ex);
            }
        }

        @Override
        protected void caughtException(Throwable ex) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.onException(ex);
            }
        }

        @Override
        protected void disconnected(boolean remote) {
            if (this.exceptionHandler != null && remote) {
                this.exceptionHandler.onConnectionClosed();
            }
            super.disconnected(remote);
        }

        @Override
        public void soundAlarm() {
            this.alarmSounded = true;
        }

        private boolean isAlarmOn() {
            return this.alarmSounded;
        }

        private boolean resetAlarm() {
            boolean ret = this.alarmSounded;
            this.alarmSounded = false;
            return ret;
        }
    }
}

