/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

import java.io.IOException;
import java.util.Arrays;
import java.util.Stack;

public final class VT220Parser {
    public static final char ENQ = '\u0005';
    public static final char BELL = '\u0007';
    public static final char BS = '\b';
    public static final char TAB = '\t';
    public static final char LF = '\n';
    public static final char VT = '\u000b';
    public static final char FF = '\f';
    public static final char CR = '\r';
    public static final char SO = '\u000e';
    public static final char SI = '\u000f';
    public static final char CAN = '\u0018';
    public static final char ESCAPE = '\u001b';
    public static final char SPACE = ' ';
    public static final char IND = '\u0084';
    public static final char NEL = '\u0085';
    public static final char HTS = '\u0088';
    public static final char RI = '\u008d';
    public static final char SS2 = '\u008e';
    public static final char SS3 = '\u008f';
    public static final char DCS = '\u0090';
    public static final char SPA = '\u0096';
    public static final char EPA = '\u0097';
    public static final char SOS = '\u0098';
    public static final char DECID = '\u009a';
    public static final char CSI = '\u009b';
    public static final char ST = '\u009c';
    public static final char OSC = '\u009d';
    public static final char PM = '\u009e';
    public static final char APC = '\u009f';
    private final Stack<Object> m_parameters = new Stack();
    private int m_logLevel = 0;
    private CharSequence m_text;
    private int m_i;
    private int m_lastParsePos;
    private int m_lastWrittenChar;
    private ParserState m_state;
    private boolean m_vt52mode = false;
    private char m_designator;

    public boolean isVT52mode() {
        return this.m_vt52mode;
    }

    public int parse(CharSequence text, VT220ParserHandler handler) throws IOException {
        int c;
        this.m_text = text;
        this.m_i = 0;
        this.m_lastParsePos = 0;
        this.m_parameters.clear();
        this.m_state = this.m_vt52mode ? ParserState.VT52 : ParserState.VT100;
        this.m_lastWrittenChar = -1;
        block113: while ((c = this.nextChar()) != -1) {
            switch (this.m_state) {
                case DCS: 
                case OSC: 
                case PM: 
                case APC: 
                case SOS: {
                    switch (c) {
                        case 27: {
                            if (this.la() != 92) continue block113;
                            this.eat(1);
                            this.escSequenceFound();
                            continue block113;
                        }
                        case 156: {
                            this.m_state = this.m_vt52mode ? ParserState.VT52 : ParserState.VT100;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                    }
                    this.eat(0);
                    continue block113;
                }
                case CSI: {
                    int col;
                    switch (c) {
                        case 64: {
                            int count;
                            if (this.lb() == 32) {
                                count = this.getIntegerParameter(1);
                                handler.handleCSI(CSIType.SL, count);
                            } else {
                                count = this.getIntegerParameter(1);
                                handler.handleCSI(CSIType.ICH, count);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 65: {
                            if (this.lb() == 32) {
                                int count = this.getIntegerParameter(1);
                                handler.handleCSI(CSIType.SR, count);
                            } else {
                                int n = this.getIntegerParameter(1);
                                handler.handleCSI(CSIType.CUU, n);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 66: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CUD, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 67: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CUF, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 68: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CUB, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 69: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CNL, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 70: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CPL, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 71: 
                        case 96: {
                            int x = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CHA, x);
                            this.csiFound();
                            continue block113;
                        }
                        case 72: 
                        case 102: {
                            int row = this.getIntegerParameter(1);
                            col = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CUP, row, col);
                            this.csiFound();
                            continue block113;
                        }
                        case 73: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CHT, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 74: {
                            int mode = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECSED, mode);
                            } else {
                                handler.handleCSI(CSIType.ED, mode);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 75: {
                            int mode = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECSEL, mode);
                            } else {
                                handler.handleCSI(CSIType.EL, mode);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 76: {
                            int lines = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.IL, lines);
                            this.csiFound();
                            continue block113;
                        }
                        case 77: {
                            int lines = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.DL, lines);
                            this.csiFound();
                            continue block113;
                        }
                        case 80: {
                            int count = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.DCH, count);
                            this.csiFound();
                            continue block113;
                        }
                        case 83: {
                            int lines = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.SU, lines);
                            this.csiFound();
                            continue block113;
                        }
                        case 84: {
                            int lines = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.SD, lines);
                            this.csiFound();
                            continue block113;
                        }
                        case 88: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.ECH, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 90: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.CBT, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 97: {
                            int count = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.HPR, count);
                            this.csiFound();
                            continue block113;
                        }
                        case 98: {
                            if (this.m_lastWrittenChar >= 0) {
                                int count = this.getIntegerParameter(1);
                                handler.handleCSI(CSIType.REP, count, this.m_lastWrittenChar);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 99: {
                            int option = this.getIntegerParameter(0);
                            if (this.m_designator == '>') {
                                handler.handleCSI(CSIType.SecondaryDA, option);
                            } else {
                                handler.handleCSI(CSIType.PrimaryDA, option);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 100: {
                            int row = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.VPA, row);
                            this.csiFound();
                            continue block113;
                        }
                        case 101: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.VPR, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 103: {
                            int arg = this.getIntegerParameter(0);
                            handler.handleCSI(CSIType.TBC, arg);
                            this.csiFound();
                            continue block113;
                        }
                        case 104: {
                            int arg = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECSET, arg);
                            } else {
                                handler.handleCSI(CSIType.SM, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 105: {
                            int arg = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECSMC, arg);
                            } else {
                                handler.handleCSI(CSIType.MC, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 106: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.HPB, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 107: {
                            int n = this.getIntegerParameter(1);
                            handler.handleCSI(CSIType.VPB, n);
                            this.csiFound();
                            continue block113;
                        }
                        case 108: {
                            int arg = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECRST, arg);
                                if (arg == 2) {
                                    this.m_state = ParserState.VT52;
                                    this.m_vt52mode = true;
                                }
                            } else {
                                handler.handleCSI(CSIType.RM, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 109: {
                            int[] args = this.getIntegerParameters(0);
                            handler.handleCSI(CSIType.SGR, args);
                            this.csiFound();
                            continue block113;
                        }
                        case 110: {
                            int arg = this.getIntegerParameter(0);
                            if (this.isDecSpecific()) {
                                handler.handleCSI(CSIType.DECSDSR, arg);
                            } else {
                                handler.handleCSI(CSIType.DSR, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 112: {
                            int arg2;
                            if (this.lb() == 33) {
                                handler.handleCSI(CSIType.DECSTR, new int[0]);
                            } else if (this.lb() == 34) {
                                int arg1 = this.getIntegerParameter(0);
                                arg2 = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECSCL, arg1, arg2);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 113: {
                            if (this.lb() == 34) {
                                int arg = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECSCA, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 114: {
                            if (this.lb() == 36) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECCARA, args);
                            } else if (this.isDecSpecific()) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.RestoreDECPM, args);
                            } else {
                                int top = this.getIntegerParameter(1);
                                int bottom = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECSTBM, top, bottom);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 115: {
                            if (this.isDecSpecific()) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.SaveDECPM, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 116: {
                            int[] args;
                            if (this.lb() == 36) {
                                args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECRARA, args);
                            } else {
                                args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.WindowManipulation, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 118: {
                            if (this.lb() == 36) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECCRA, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 119: {
                            if (this.lb() == 39) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECEFR, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 120: {
                            if (this.lb() == 36) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECFRA, args);
                            } else {
                                int arg = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECREQTPARM, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 122: {
                            int arg2;
                            if (this.lb() == 39) {
                                int arg1 = this.getIntegerParameter(0);
                                arg2 = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECELR, arg1, arg2);
                            } else if (this.lb() == 36) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECERA, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 123: {
                            if (this.lb() == 39) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECSLE, args);
                            } else if (this.lb() == 36) {
                                int[] args = this.getIntegerParameters(new int[0]);
                                handler.handleCSI(CSIType.DECSERA, args);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 124: {
                            if (this.lb() == 39) {
                                int arg = this.getIntegerParameter(0);
                                handler.handleCSI(CSIType.DECRQLP, arg);
                            }
                            this.csiFound();
                            continue block113;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            int value = c - 48;
                            while (Character.isDigit((char)this.la())) {
                                c = this.nextChar();
                                value = value * 10 + (c - 48);
                            }
                            this.pushParameter(value);
                            continue block113;
                        }
                        case 59: {
                            if (this.hasParameters()) continue block113;
                            this.pushParameter(0);
                            continue block113;
                        }
                        case 32: 
                        case 33: 
                        case 34: 
                        case 36: 
                        case 39: 
                        case 61: 
                        case 62: 
                        case 63: {
                            this.m_designator = (char)c;
                            continue block113;
                        }
                    }
                    if (c < 32) {
                        handler.handleControl((char)c);
                        continue block113;
                    }
                    this.m_lastWrittenChar = c;
                    handler.handleCharacter((char)c);
                    continue block113;
                }
                case ESC: {
                    int col;
                    if (this.m_vt52mode) {
                        switch (c) {
                            case 24: {
                                this.m_state = ParserState.VT52;
                                continue block113;
                            }
                            case 65: {
                                handler.handleCSI(CSIType.CUU, 1);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 66: {
                                handler.handleCSI(CSIType.CUD, 1);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 67: {
                                handler.handleCSI(CSIType.CUF, 1);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 68: {
                                handler.handleCSI(CSIType.CUB, 1);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 70: {
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 71: {
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 72: {
                                handler.handleCSI(CSIType.CUP, 1, 1);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 73: {
                                handler.handleESC('M', new int[0]);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 74: {
                                handler.handleCSI(CSIType.ED, 0);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 75: {
                                handler.handleCSI(CSIType.EL, 0);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 89: {
                                if (this.la() != 24) {
                                    int row = Math.max(0, this.nextChar() - 32);
                                    if (this.la() != 24) {
                                        col = Math.max(0, this.nextChar() - 32);
                                        handler.handleCSI(CSIType.CUP, row + 1, col + 1);
                                        this.escSequenceFound();
                                        continue block113;
                                    }
                                    handler.handleCSI(CSIType.CUP, row + 1, 1);
                                    this.escSequenceFound();
                                    continue block113;
                                }
                                this.m_state = ParserState.VT52;
                                continue block113;
                            }
                            case 90: {
                                handler.handleESC('Z', new int[0]);
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 61: {
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 62: {
                                this.escSequenceFound();
                                continue block113;
                            }
                            case 60: {
                                this.m_state = ParserState.VT100;
                                this.m_vt52mode = false;
                                this.escSequenceFound();
                                continue block113;
                            }
                        }
                        this.escSequenceFound();
                        continue block113;
                    }
                    switch (c) {
                        case 91: {
                            this.m_state = ParserState.CSI;
                            this.m_parameters.clear();
                            continue block113;
                        }
                        case 95: {
                            this.m_state = ParserState.APC;
                            continue block113;
                        }
                        case 92: {
                            continue block113;
                        }
                        case 93: {
                            this.m_state = ParserState.OSC;
                            continue block113;
                        }
                        case 94: {
                            this.m_state = ParserState.PM;
                            continue block113;
                        }
                        case 80: {
                            this.m_state = ParserState.DCS;
                            continue block113;
                        }
                        case 88: {
                            this.m_state = ParserState.SOS;
                            continue block113;
                        }
                        case 61: 
                        case 62: 
                        case 68: 
                        case 69: 
                        case 72: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 86: 
                        case 87: 
                        case 90: 
                        case 99: 
                        case 110: 
                        case 111: 
                        case 124: 
                        case 125: 
                        case 126: {
                            handler.handleESC((char)c, new int[0]);
                            this.escSequenceFound();
                            continue block113;
                        }
                        case 32: {
                            int la = this.la();
                            if (la == 70 || la == 71) {
                                handler.handleESC((char)c, la);
                            } else if (la == 76 || la == 77 || la == 78) {
                                handler.handleESC((char)c, la);
                            }
                            this.eat(1);
                            this.escSequenceFound();
                            continue block113;
                        }
                        case 35: {
                            int la = this.la();
                            if (la != 51 && la != 52 && la != 53 && la != 54 && la == 56) {
                                handler.handleESC((char)c, la);
                            }
                            this.eat(1);
                            this.escSequenceFound();
                            continue block113;
                        }
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: {
                            while (this.la() >= 32 && this.la() <= 47) {
                                this.eat(1);
                            }
                            int f = this.nextChar();
                            handler.handleESC((char)c, f);
                            this.escSequenceFound();
                            continue block113;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            int value = c - 48;
                            while (Character.isDigit((char)this.la())) {
                                c = this.nextChar();
                                value = value * 10 + (c - 48);
                            }
                            if (value != 7 && value != 8 || this.lb() != 27) continue block113;
                            handler.handleESC((char)c, new int[0]);
                            this.escSequenceFound();
                            continue block113;
                        }
                    }
                    this.escSequenceFound();
                    continue block113;
                }
                case VT100: {
                    switch (c) {
                        case 27: {
                            this.m_state = ParserState.ESC;
                            continue block113;
                        }
                        case 155: {
                            this.m_state = ParserState.CSI;
                            this.m_parameters.clear();
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 144: {
                            this.m_state = ParserState.DCS;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 156: {
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 157: {
                            this.m_state = ParserState.OSC;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 158: {
                            this.m_state = ParserState.PM;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 159: {
                            this.m_state = ParserState.APC;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 132: {
                            handler.handleESC('D', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 133: {
                            handler.handleESC('E', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 136: {
                            handler.handleESC('H', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 141: {
                            handler.handleESC('M', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 142: {
                            handler.handleESC('N', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 143: {
                            handler.handleESC('O', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 150: {
                            handler.handleESC('V', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 151: {
                            handler.handleESC('W', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 152: {
                            this.m_state = ParserState.SOS;
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                        case 154: {
                            handler.handleESC('Z', new int[0]);
                            this.eightBitSequenceFound();
                            continue block113;
                        }
                    }
                    if (c < 32) {
                        this.m_lastWrittenChar = -1;
                        handler.handleControl((char)c);
                    } else {
                        this.m_lastWrittenChar = c;
                        handler.handleCharacter((char)c);
                    }
                    this.eat(0);
                    continue block113;
                }
                case VT52: {
                    switch (c) {
                        case 27: {
                            this.m_state = ParserState.ESC;
                            continue block113;
                        }
                    }
                    if (c < 32) {
                        this.m_lastWrittenChar = -1;
                        handler.handleControl((char)c);
                    } else {
                        this.m_lastWrittenChar = c;
                        handler.handleCharacter((char)c);
                    }
                    this.eat(0);
                    continue block113;
                }
            }
            throw new RuntimeException("Unknown/unhandled state: " + (Object)((Object)this.m_state));
        }
        return this.m_lastParsePos;
    }

    public void setLogLevel(int logLevel) {
        this.m_logLevel = logLevel;
    }

    private void csiFound() {
        this.log(this.m_text, this.m_lastParsePos, this.m_i);
        this.m_state = ParserState.VT100;
        this.m_parameters.clear();
        this.m_lastWrittenChar = -1;
        this.m_designator = '\u0000';
        this.m_lastParsePos = Math.min(this.m_text.length(), this.m_i);
    }

    private void eat(int count) {
        this.log(this.m_text, this.m_lastParsePos, this.m_i + count);
        this.m_i += count;
        this.m_lastParsePos = Math.min(this.m_text.length(), this.m_i);
    }

    private void eightBitSequenceFound() {
        this.log(this.m_text, this.m_lastParsePos, this.m_i);
        this.m_lastWrittenChar = -1;
        this.m_designator = '\u0000';
        this.m_lastParsePos = Math.min(this.m_text.length(), this.m_i);
    }

    private void escSequenceFound() {
        this.log(this.m_text, this.m_lastParsePos, this.m_i);
        this.m_state = this.m_vt52mode ? ParserState.VT52 : ParserState.VT100;
        this.m_lastWrittenChar = -1;
        this.m_designator = '\u0000';
        this.m_lastParsePos = Math.min(this.m_text.length(), this.m_i);
    }

    private int getIntegerParameter(int defaultValue) {
        Object param;
        int result = Integer.MIN_VALUE;
        if (this.hasParameters() && (param = this.m_parameters.remove(0)) instanceof Integer) {
            result = (Integer)param;
        }
        return Math.max(defaultValue, result);
    }

    private int[] getIntegerParameters(int ... defaultValues) {
        int[] result;
        int count = 0;
        for (Object e : this.m_parameters) {
            if (!(e instanceof Integer)) continue;
            ++count;
        }
        if (count == 0) {
            result = Arrays.copyOf(defaultValues, defaultValues.length);
        } else {
            result = new int[count];
            boolean bl = false;
            while (this.hasParameters()) {
                Object param = this.m_parameters.remove(0);
                if (!(param instanceof Integer)) continue;
                result[++var4_6] = (Integer)param;
            }
        }
        return result;
    }

    private boolean hasParameters() {
        return !this.m_parameters.isEmpty();
    }

    private boolean isDecSpecific() {
        return this.m_designator == '?';
    }

    private int la() {
        if (this.m_i >= this.m_text.length()) {
            return -1;
        }
        return this.m_text.charAt(this.m_i);
    }

    private int lb() {
        if (this.m_i < 2) {
            return -1;
        }
        return this.m_text.charAt(this.m_i - 2);
    }

    private void log(CharSequence text, int start, int end) {
        if (this.m_logLevel < 1) {
            return;
        }
        int length = text.length();
        if (start >= length) {
            return;
        }
        end = Math.min(end, length);
        StringBuilder sb = new StringBuilder("LOG> ");
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c >= ' ' && c <= '~') {
                sb.append(c);
                continue;
            }
            sb.append("<").append((int)c).append(">");
        }
        System.out.println(sb.toString());
    }

    private int nextChar() {
        if (this.m_i >= this.m_text.length()) {
            return -1;
        }
        return this.m_text.charAt(this.m_i++);
    }

    private void pushParameter(int value) {
        this.m_parameters.push(value);
    }

    private static enum ParserState {
        VT100,
        VT52,
        ESC,
        CSI,
        OSC,
        DCS,
        APC,
        PM,
        SOS;

    }

    public static interface VT220ParserHandler {
        public void handleCharacter(char var1) throws IOException;

        public void handleControl(char var1) throws IOException;

        public void handleCSI(CSIType var1, int ... var2) throws IOException;

        public void handleESC(char var1, int ... var2) throws IOException;
    }

    public static enum CSIType {
        ICH,
        CUU,
        CUD,
        CUF,
        CUB,
        CNL,
        CPL,
        CHA,
        CUP,
        CHT,
        ED,
        DECSED,
        EL,
        DECSEL,
        IL,
        DL,
        DCH,
        SU,
        SD,
        ECH,
        CBT,
        HPR,
        REP,
        PrimaryDA,
        SecondaryDA,
        VPA,
        VPR,
        TBC,
        SM,
        DECSET,
        MC,
        DECSMC,
        HPB,
        VPB,
        RM,
        DECRST,
        SGR,
        DSR,
        DECSDSR,
        DECSTR,
        DECSCL,
        DECSCA,
        DECSTBM,
        RestoreDECPM,
        DECCARA,
        SaveDECPM,
        DECRARA,
        DECCRA,
        DECEFR,
        DECREQTPARM,
        DECFRA,
        DECELR,
        DECERA,
        DECSLE,
        DECSERA,
        DECRQLP,
        SL,
        SR,
        WindowManipulation;

    }
}

