/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

class TextAttributes {
    static final int COLOR_MASK = 31;
    static final int BOLD_MASK = 1024;
    static final int ITALIC_MASK = 2048;
    static final int UNDERLINE_MASK = 4096;
    static final int REVERSE_MASK = 8192;
    static final int HIDDEN_MASK = 16384;
    static final int PROTECTED_MASK = 32768;
    private short m_attr;

    TextAttributes() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextAttributes other = (TextAttributes)object;
        return this.m_attr == other.m_attr;
    }

    public short getAttributes() {
        return this.m_attr;
    }

    public int getBackground() {
        int bg = this.m_attr >> 5 & 0x1F;
        return bg;
    }

    public int getForeground() {
        int fg = this.m_attr & 0x1F;
        return fg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_attr;
        return result;
    }

    public boolean isBold() {
        return (this.m_attr & 0x400) != 0;
    }

    public boolean isHidden() {
        return (this.m_attr & 0x4000) != 0;
    }

    public boolean isItalic() {
        return (this.m_attr & 0x800) != 0;
    }

    public boolean isProtected() {
        return (this.m_attr & 0x8000) != 0;
    }

    public boolean isReverse() {
        return (this.m_attr & 0x2000) != 0;
    }

    public boolean isUnderline() {
        return (this.m_attr & 0x1000) != 0;
    }

    public void reset() {
        this.m_attr = (short)(this.m_attr & 0x3FF);
    }

    public void resetAll() {
        this.m_attr = 0;
    }

    public void setAttributes(short attributes) {
        this.m_attr = attributes;
    }

    public void setBackground(int index) {
        int bg = (index & 0x1F) << 5;
        this.m_attr = (short)(this.m_attr & 0xFE1F);
        this.m_attr = (short)(this.m_attr | bg);
    }

    public void setBold(boolean enable) {
        this.setAttrBit(enable, 1024);
    }

    public void setForeground(int index) {
        int fg = index & 0x1F;
        this.m_attr = (short)(this.m_attr & 0xFFE0);
        this.m_attr = (short)(this.m_attr | fg);
    }

    public void setHidden(boolean enable) {
        this.setAttrBit(enable, 16384);
    }

    public void setItalic(boolean enable) {
        this.setAttrBit(enable, 2048);
    }

    public void setProtected(boolean enable) {
        this.setAttrBit(enable, 32768);
    }

    public void setReverse(boolean enable) {
        this.setAttrBit(enable, 8192);
    }

    public void setUnderline(boolean enable) {
        this.setAttrBit(enable, 4096);
    }

    private void setAttrBit(boolean enable, int mask) {
        this.m_attr = enable ? (short)(this.m_attr | mask) : (short)(this.m_attr & ~mask);
    }
}

