/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.SortedSet;
import java.util.TreeSet;
import nl.lxtreme.jvt220.terminal.ICursor;
import nl.lxtreme.jvt220.terminal.ITabulator;
import nl.lxtreme.jvt220.terminal.ITerminal;
import nl.lxtreme.jvt220.terminal.ITerminalFrontend;
import nl.lxtreme.jvt220.terminal.vt220.CursorImpl;
import nl.lxtreme.jvt220.terminal.vt220.TextAttributes;
import nl.lxtreme.jvt220.terminal.vt220.TextCell;

public abstract class AbstractTerminal
implements ITerminal {
    protected static final String FONT_MONOSPACED = "Monospaced";
    private static final int OPTION_ORIGIN = 0;
    private static final int OPTION_REVERSE = 1;
    private static final int OPTION_AUTOWRAP = 2;
    private static final int OPTION_NEWLINE = 3;
    private static final int OPTION_INSERT = 4;
    private final CursorImpl m_cursor;
    private final ITabulator m_tabulator;
    private final ITerminal.IKeyMapper m_keymapper = this.createKeyMapper();
    protected final BitSet m_options;
    protected final TextAttributes m_textAttributes = new TextAttributes();
    private volatile ITerminalFrontend m_frontend;
    private volatile BitSet m_heatMap;
    private volatile TextCell[] m_buffer;
    private volatile int m_width;
    private volatile int m_height;
    private int m_logLevel;
    private int m_firstScrollLine;
    private int m_lastScrollLine;
    private boolean m_wrapped;

    protected AbstractTerminal(int columns, int lines) {
        this.m_cursor = new CursorImpl();
        this.m_options = new BitSet();
        this.m_tabulator = new DefaultTabulator(columns);
        this.internalSetDimensions(columns, lines);
        this.m_logLevel = 0;
    }

    public void clearLine(int mode) {
        int idx;
        int xPos = this.m_cursor.getX();
        int yPos = this.m_cursor.getY();
        switch (mode) {
            case 0: {
                idx = this.getAbsoluteIndex(xPos, yPos);
                break;
            }
            case 1: {
                idx = this.getAbsoluteIndex(xPos, yPos);
                break;
            }
            case 2: {
                idx = this.getAbsoluteIndex(0, yPos);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid clear line mode!");
            }
        }
        this.clearLine(mode, idx, false);
    }

    public void clearScreen(int mode) {
        int xPos = this.m_cursor.getX();
        int yPos = this.m_cursor.getY();
        this.clearScreen(mode, this.getAbsoluteIndex(xPos, yPos), false);
    }

    @Override
    public void close() throws IOException {
        this.m_buffer = null;
        this.m_heatMap = null;
    }

    @Override
    public ICursor getCursor() {
        return this.m_cursor;
    }

    public final int getFirstScrollLine() {
        if (!this.isOriginMode()) {
            return 0;
        }
        return this.m_firstScrollLine;
    }

    @Override
    public final ITerminalFrontend getFrontend() {
        return this.m_frontend;
    }

    @Override
    public int getHeight() {
        return this.m_height;
    }

    @Override
    public final ITerminal.IKeyMapper getKeyMapper() {
        return this.m_keymapper;
    }

    public final int getLastScrollLine() {
        if (!this.isOriginMode()) {
            return this.getHeight() - 1;
        }
        return this.m_lastScrollLine;
    }

    @Override
    public ITabulator getTabulator() {
        return this.m_tabulator;
    }

    @Override
    public int getWidth() {
        return this.m_width;
    }

    public final boolean isAutoNewlineMode() {
        return this.m_options.get(3);
    }

    public final boolean isAutoWrapMode() {
        return this.m_options.get(2);
    }

    public final boolean isInsertMode() {
        return this.m_options.get(4);
    }

    public final boolean isOriginMode() {
        return this.m_options.get(0);
    }

    public final boolean isReverseMode() {
        return this.m_options.get(1);
    }

    public void moveCursorAbsolute(int x, int y) {
        int yPos;
        int xPos = x;
        if (xPos < 0) {
            xPos = this.m_cursor.getX();
        }
        if (xPos >= this.m_width) {
            xPos = this.m_width;
        }
        if ((yPos = y) < 0) {
            yPos = this.m_cursor.getY();
        }
        if (yPos >= this.m_height) {
            yPos = this.m_height - 1;
        }
        this.m_cursor.setPosition(xPos, yPos);
    }

    public void moveCursorRelative(int x, int y) {
        int xPos = Math.max(0, this.m_cursor.getX() + x);
        int yPos = Math.max(0, this.m_cursor.getY() + y);
        this.moveCursorAbsolute(xPos, yPos);
    }

    @Override
    public final int read(CharSequence chars) throws IOException {
        int r = this.doReadInput(chars);
        if (this.m_frontend != null && this.m_frontend.isListening()) {
            ITerminal.ITextCell[] b = (TextCell[])this.m_buffer.clone();
            BitSet hm = (BitSet)this.m_heatMap.clone();
            this.m_frontend.terminalChanged(b, hm);
            this.m_heatMap.clear();
        }
        return r;
    }

    @Override
    public void reset() {
        this.clearScreen(2);
        this.updateCursorByAbsoluteIndex(this.getFirstAbsoluteIndex());
        this.m_firstScrollLine = 0;
        this.m_lastScrollLine = this.getHeight() - 1;
    }

    public void scrollDown(int lines) {
        this.scrollDown(this.m_firstScrollLine, this.m_lastScrollLine, lines);
    }

    public void scrollUp(int lines) {
        this.scrollUp(this.m_firstScrollLine, this.m_lastScrollLine, lines);
    }

    public void setAutoNewlineMode(boolean enable) {
        this.m_options.set(3, enable);
    }

    public void setAutoWrap(boolean enable) {
        this.m_options.set(2, enable);
    }

    public void setDimensions(int newWidth, int newHeight) {
        if (newWidth <= 0) {
            newWidth = this.m_width;
        }
        if (newHeight <= 0) {
            newHeight = this.m_height;
        }
        if (newWidth == this.m_width && newHeight == this.m_height) {
            return;
        }
        this.internalSetDimensions(newWidth, newHeight);
    }

    @Override
    public void setFrontend(ITerminalFrontend frontend) {
        if (frontend == null) {
            throw new IllegalArgumentException("Frontend cannot be null!");
        }
        this.m_frontend = frontend;
    }

    public void setInsertMode(boolean enable) {
        this.m_options.set(4, enable);
    }

    public void setLogLevel(int logLevel) {
        this.m_logLevel = logLevel;
    }

    public void setOriginMode(boolean enable) {
        this.m_options.set(0, enable);
    }

    public void setReverse(boolean enable) {
        this.m_options.set(1, enable);
        this.m_heatMap.set(this.getFirstAbsoluteIndex(), this.getLastAbsoluteIndex());
        if (this.m_frontend != null) {
            this.m_frontend.setReverse(enable);
        }
    }

    public void setScrollRegion(int topIndex, int bottomIndex) {
        if (topIndex < 0) {
            throw new IllegalArgumentException("TopIndex cannot be negative!");
        }
        if (bottomIndex <= topIndex) {
            throw new IllegalArgumentException("BottomIndex cannot be equal or less than TopIndex!");
        }
        this.m_firstScrollLine = Math.max(0, topIndex);
        this.m_lastScrollLine = Math.min(this.getHeight() - 1, bottomIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int idx = this.getFirstAbsoluteIndex(); idx <= this.getLastAbsoluteIndex(); ++idx) {
            ITerminal.ITextCell cell = this.getCellAt(idx);
            if (idx > 0 && idx % this.getWidth() == 0) {
                sb.append("\n");
            }
            sb.append(cell == null ? (char)' ' : (char)cell.getChar());
        }
        return sb.toString();
    }

    @Override
    public int write(CharSequence response) throws IOException {
        int length = 0;
        Writer w = this.getWriter();
        if (response != null && w != null) {
            w.write(response.toString());
            w.flush();
            length = response.length();
        }
        return length;
    }

    protected final void clearAllTabStops() {
        this.getTabulator().clearAll();
    }

    protected final void clearLine(int mode, int absoluteIndex, boolean keepProtectedCells) {
        int length;
        int idx;
        int width = this.getWidth();
        int yPos = (int)Math.floor(absoluteIndex / width);
        int xPos = absoluteIndex - yPos * width;
        switch (mode) {
            case 0: {
                idx = absoluteIndex;
                length = width - xPos;
                break;
            }
            case 1: {
                idx = absoluteIndex - xPos;
                length = xPos + 1;
                break;
            }
            case 2: {
                idx = absoluteIndex - xPos;
                length = width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid clear line mode!");
            }
        }
        for (int i = 0; i < length; ++i) {
            this.removeChar(idx++, keepProtectedCells);
        }
    }

    protected final void clearScreen(int mode, int absoluteIndex, boolean keepProtectedCells) {
        switch (mode) {
            case 0: {
                int lastIdx = this.getLastAbsoluteIndex();
                for (int i = absoluteIndex; i <= lastIdx; ++i) {
                    this.removeChar(i, keepProtectedCells);
                }
                break;
            }
            case 1: {
                int firstIdx;
                for (int i = firstIdx = this.getFirstAbsoluteIndex(); i <= absoluteIndex; ++i) {
                    this.removeChar(i, keepProtectedCells);
                }
                break;
            }
            case 2: {
                if (keepProtectedCells) {
                    int last = this.getLastAbsoluteIndex();
                    for (int i = this.getFirstAbsoluteIndex(); i <= last; ++i) {
                        this.removeChar(i, keepProtectedCells);
                    }
                    break;
                }
                Arrays.fill(this.m_buffer, this.getFirstAbsoluteIndex(), this.getLastAbsoluteIndex() + 1, new TextCell(' ', this.getAttributes()));
                this.m_heatMap.set(this.getFirstAbsoluteIndex(), this.getLastAbsoluteIndex());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid clear screen mode!");
            }
        }
    }

    protected ITerminal.IKeyMapper createKeyMapper() {
        return new DefaultKeyMapper();
    }

    protected final int deleteChars(int absoluteIndex, int count) {
        int col = absoluteIndex % this.getWidth();
        int length = Math.max(0, this.getWidth() - col - count);
        System.arraycopy(this.m_buffer, absoluteIndex + count, this.m_buffer, absoluteIndex, length);
        int startIdx = absoluteIndex + length;
        int endIdx = absoluteIndex + this.getWidth() - col;
        Arrays.fill(this.m_buffer, startIdx, endIdx, new TextCell(' ', this.getAttributes()));
        this.m_heatMap.set(absoluteIndex, absoluteIndex + this.getWidth() - col);
        return absoluteIndex;
    }

    protected abstract int doReadInput(CharSequence var1) throws IOException;

    protected final int getAbsoluteCursorIndex() {
        return this.getAbsoluteIndex(this.m_cursor.getX(), this.m_cursor.getY());
    }

    protected final int getAbsoluteIndex(int x, int y) {
        return y * this.getWidth() + x;
    }

    protected final short getAttributes() {
        return this.m_textAttributes.getAttributes();
    }

    protected final ITerminal.ITextCell getCellAt(int absoluteIndex) {
        return this.m_buffer[absoluteIndex];
    }

    protected final ITerminal.ITextCell getCellAt(int x, int y) {
        return this.getCellAt(this.getAbsoluteIndex(x, y));
    }

    protected final int getFirstAbsoluteIndex() {
        return this.getAbsoluteIndex(0, 0);
    }

    protected final int getLastAbsoluteIndex() {
        return this.getAbsoluteIndex(this.getWidth() - 1, this.getHeight() - 1);
    }

    protected final int insertChars(int absoluteIndex, char ch, int count) {
        int col = absoluteIndex % this.getWidth();
        int length = this.getWidth() - col - count;
        System.arraycopy(this.m_buffer, absoluteIndex, this.m_buffer, absoluteIndex + count, length);
        Arrays.fill(this.m_buffer, absoluteIndex, absoluteIndex + count, new TextCell(ch, this.getAttributes()));
        this.m_heatMap.set(absoluteIndex, absoluteIndex + this.getWidth() - col);
        return absoluteIndex;
    }

    protected final boolean isWrapped() {
        return this.m_wrapped;
    }

    protected final int removeChar(int absoluteIndex, boolean keepProtectedCells) {
        int idx = absoluteIndex;
        int firstIdx = this.getFirstAbsoluteIndex();
        if (idx < firstIdx) {
            return firstIdx;
        }
        if (idx > this.getLastAbsoluteIndex()) {
            idx = this.getLastAbsoluteIndex();
        }
        if (!keepProtectedCells || !this.m_buffer[idx].isProtected()) {
            this.m_buffer[idx] = new TextCell(' ', this.getAttributes());
            this.m_heatMap.set(idx);
        }
        return idx;
    }

    protected final void resetWrapped() {
        this.m_wrapped = false;
    }

    protected void scrollDown(int firstScrollLine, int lastScrollLine, int lines) {
        if (firstScrollLine < 0) {
            throw new IllegalArgumentException("First scroll line cannot be less than zero!");
        }
        if (lastScrollLine >= this.getHeight()) {
            throw new IllegalArgumentException("Last scroll line cannot be greater than terminal height!");
        }
        if (lastScrollLine < firstScrollLine) {
            throw new IllegalArgumentException("Scroll region cannot be negative!");
        }
        if (lines < 1) {
            throw new IllegalArgumentException("Invalid number of lines!");
        }
        int region = lastScrollLine - firstScrollLine + 1;
        int n = Math.min(lines, region);
        int width = this.getWidth();
        int srcPos = firstScrollLine * width;
        int destPos = (n + firstScrollLine) * width;
        int length = (lastScrollLine + 1) * width - destPos;
        if (length > 0) {
            System.arraycopy(this.m_buffer, srcPos, this.m_buffer, destPos, length);
        }
        Arrays.fill(this.m_buffer, srcPos, destPos, new TextCell(' ', this.getAttributes()));
        this.m_heatMap.set(srcPos, destPos);
    }

    protected void scrollUp(int firstScrollLine, int lastScrollLine, int lines) {
        if (firstScrollLine < 0) {
            throw new IllegalArgumentException("First scroll line cannot be less than zero!");
        }
        if (lastScrollLine >= this.getHeight()) {
            throw new IllegalArgumentException("Last scroll line cannot be greater than terminal height!");
        }
        if (lastScrollLine < firstScrollLine) {
            throw new IllegalArgumentException("Scroll region cannot be negative!");
        }
        if (lines < 1) {
            throw new IllegalArgumentException("Invalid number of lines!");
        }
        int region = lastScrollLine - firstScrollLine + 1;
        int n = Math.min(lines, region);
        int width = this.getWidth();
        int srcPos = (n + firstScrollLine) * width;
        int destPos = firstScrollLine * width;
        int lastPos = (lastScrollLine + 1) * width;
        int length = lastPos - srcPos;
        if (length > 0) {
            System.arraycopy(this.m_buffer, srcPos, this.m_buffer, destPos, length);
        }
        Arrays.fill(this.m_buffer, destPos + length, srcPos + length, new TextCell(' ', this.getAttributes()));
        this.m_heatMap.set(destPos, lastPos);
    }

    protected final void updateCursorByAbsoluteIndex(int absoluteIndex) {
        int width = this.getWidth();
        int yPos = (int)Math.floor(absoluteIndex / width);
        int xPos = absoluteIndex - yPos * width;
        this.m_cursor.setPosition(xPos, yPos);
    }

    protected final int writeChar(int absoluteIndex, char ch) {
        int idx = absoluteIndex;
        int lastIdx = this.getAbsoluteIndex(this.getWidth() - 1, this.getLastScrollLine());
        int width = this.getWidth();
        if (idx > lastIdx) {
            idx -= width;
            this.scrollUp(1);
        }
        if (idx <= lastIdx) {
            this.m_buffer[idx] = new TextCell(ch, this.getAttributes());
            this.m_heatMap.set(idx);
        }
        boolean lastColumn = idx % width == width - 1;
        boolean bl = this.m_wrapped = this.isAutoWrapMode() && lastColumn;
        if (this.isAutoWrapMode() || !lastColumn) {
            ++idx;
        }
        return idx;
    }

    private Writer getWriter() {
        Writer result = null;
        if (this.m_frontend != null) {
            result = this.m_frontend.getWriter();
        }
        return result;
    }

    private void internalSetDimensions(int width, int height) {
        Object[] newBuffer = new TextCell[width * height];
        Arrays.fill(newBuffer, new TextCell());
        if (this.m_buffer != null) {
            int oldWidth = this.m_width;
            for (int oldIdx = 0; oldIdx < this.m_buffer.length; ++oldIdx) {
                int oldColumn = oldIdx % oldWidth;
                int oldLine = oldIdx / oldWidth;
                if (oldColumn >= width || oldLine >= height) continue;
                int newIdx = oldLine * width + oldColumn;
                newBuffer[newIdx] = this.m_buffer[oldIdx];
            }
        }
        this.m_width = width;
        this.m_height = height;
        this.m_firstScrollLine = 0;
        this.m_lastScrollLine = height - 1;
        this.m_buffer = newBuffer;
        this.m_heatMap = new BitSet(newBuffer.length);
        if (this.m_frontend != null) {
            this.m_frontend.terminalSizeChanged(width, height);
        }
    }

    protected class DefaultTabulator
    implements ITabulator {
        private static final int DEFAULT_TABSTOP = 8;
        private final SortedSet<Integer> m_tabStops = new TreeSet<Integer>();

        public DefaultTabulator(int columns) {
            this(columns, 8);
        }

        public DefaultTabulator(int columns, int tabStop) {
            for (int i = tabStop; i < columns; i += tabStop) {
                this.m_tabStops.add(i);
            }
        }

        @Override
        public void clear(int position) {
            this.m_tabStops.remove(position);
        }

        @Override
        public void clearAll() {
            this.m_tabStops.clear();
        }

        @Override
        public int getNextTabWidth(int position) {
            return this.nextTab(position) - position;
        }

        @Override
        public int getPreviousTabWidth(int position) {
            return position - this.previousTab(position);
        }

        public SortedSet<Integer> getTabStops() {
            return this.m_tabStops;
        }

        @Override
        public int nextTab(int position) {
            int tabStop = Integer.MAX_VALUE;
            SortedSet<Integer> tailSet = this.m_tabStops.tailSet(position + 1);
            if (!tailSet.isEmpty()) {
                tabStop = tailSet.first();
            }
            return Math.min(tabStop, AbstractTerminal.this.getWidth() - 1);
        }

        @Override
        public int previousTab(int position) {
            int tabStop = 0;
            SortedSet<Integer> headSet = this.m_tabStops.headSet(position);
            if (!headSet.isEmpty()) {
                tabStop = headSet.last();
            }
            return Math.max(0, tabStop);
        }

        @Override
        public void set(int position) {
            this.m_tabStops.add(position);
        }
    }

    protected static class DefaultKeyMapper
    implements ITerminal.IKeyMapper {
        protected DefaultKeyMapper() {
        }

        @Override
        public String map(int keyCode, int modifiers) {
            return null;
        }
    }
}

