/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.BitSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import nl.lxtreme.jvt220.terminal.ConnectionListener;
import nl.lxtreme.jvt220.terminal.ICursor;
import nl.lxtreme.jvt220.terminal.ITerminal;
import nl.lxtreme.jvt220.terminal.ITerminalColorScheme;
import nl.lxtreme.jvt220.terminal.ITerminalFrontend;
import nl.lxtreme.jvt220.terminal.swing.CharBuffer;
import nl.lxtreme.jvt220.terminal.swing.XtermColorScheme;

public class SwingFrontend
extends JComponent
implements ITerminalFrontend {
    private static final String ISO8859_1 = "ISO8859-1";
    protected final String m_encoding;
    private final CharBuffer m_buffer;
    private ITerminalColorScheme m_colorScheme;
    private ICursor m_oldCursor;
    private volatile CharacterDimensions m_charDims;
    private volatile BufferedImage m_image;
    private volatile boolean m_listening;
    private ITerminal m_terminal;
    protected InputStreamWorker m_inputStreamWorker;
    protected Writer m_writer;
    private ConnectionListener connectionListener;

    public SwingFrontend() {
        this(ISO8859_1);
    }

    public SwingFrontend(String encoding) {
        if (encoding == null || "".equals(encoding.trim())) {
            throw new IllegalArgumentException("Encoding cannot be null or empty!");
        }
        this.m_encoding = encoding;
        this.m_buffer = new CharBuffer();
        this.m_colorScheme = new XtermColorScheme();
        this.setFont(Font.decode("Monospaced-PLAIN-14"));
        this.mapKeyboard();
        this.setEnabled(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.requestFocus();
    }

    private static CharacterDimensions getCharacterDimensions(Font aFont) {
        BufferedImage im = new BufferedImage(1, 1, 2);
        Graphics2D g2d = im.createGraphics();
        g2d.setFont(aFont);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.dispose();
        im.flush();
        int w = fm.charWidth('@');
        int h = fm.getAscent() + fm.getDescent();
        return new CharacterDimensions(w, h, fm.getLeading() + 1);
    }

    private static Rectangle union(Rectangle rect1, Rectangle rect2) {
        if (rect2 == null) {
            return rect1;
        }
        if (rect1 == null) {
            return rect2;
        }
        return rect1.union(rect2);
    }

    @Override
    public void connect(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null!");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        this.disconnect();
        this.m_writer = new OutputStreamWriter(outputStream, this.m_encoding);
        this.m_inputStreamWorker.execute();
        this.setEnabled(true);
    }

    @Override
    public void connect(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        this.disconnect();
        this.m_writer = new OutputStreamWriter(outputStream, this.m_encoding);
        this.setEnabled(true);
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.m_inputStreamWorker != null) {
                this.m_inputStreamWorker.cancel(true);
                this.m_inputStreamWorker = null;
            }
            if (this.m_writer != null) {
                this.m_writer.close();
                this.m_writer = null;
            }
        }
        finally {
            this.setEnabled(false);
        }
    }

    @Override
    public Dimension getMaximumTerminalSize() {
        Rectangle bounds = this.getGraphicsConfiguration().getBounds();
        Insets insets = this.calculateTotalInsets();
        int width = bounds.width - insets.left - insets.right;
        int height = bounds.height - insets.top - insets.bottom;
        CharacterDimensions charDims = this.m_charDims;
        int columns = width / charDims.m_width;
        int lines = height / (charDims.m_height + charDims.m_lineSpacing);
        return new Dimension(columns, lines);
    }

    public ITerminal getTerminal() {
        return this.m_terminal;
    }

    @Override
    public Writer getWriter() {
        return this.m_writer;
    }

    @Override
    public boolean isListening() {
        return this.m_listening;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_charDims = SwingFrontend.getCharacterDimensions(font);
    }

    @Override
    public void setReverse(boolean reverse) {
        this.m_colorScheme.setInverted(reverse);
    }

    @Override
    public void setSize(int width, int height) {
        Rectangle bounds = this.getGraphicsConfiguration().getBounds();
        Insets insets = this.calculateTotalInsets();
        if (width == 0) {
            width = bounds.width - insets.left - insets.right;
        } else if (width < 0) {
            width = this.getWidth();
        }
        if (height == 0) {
            height = bounds.height - insets.top - insets.bottom;
        } else if (height < 0) {
            height = this.getHeight();
        }
        CharacterDimensions charDims = this.m_charDims;
        int columns = width / charDims.m_width;
        int lines = height / (charDims.m_height + charDims.m_lineSpacing);
        this.terminalSizeChanged(columns, lines);
    }

    @Override
    public void setTerminal(ITerminal terminal) {
        if (terminal == null) {
            throw new IllegalArgumentException("Terminal cannot be null!");
        }
        this.m_terminal = terminal;
        this.m_terminal.setFrontend(this);
    }

    @Override
    public void terminalChanged(final ITerminal.ITextCell[] cells, final BitSet heatMap) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingFrontend.this.updateTerminalImage(cells, heatMap);
            }
        });
    }

    @Override
    public void terminalSizeChanged(final int columns, final int lines) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingFrontend.this.recreateTerminalImage(columns, lines, true);
            }
        });
    }

    @Override
    public void writeCharacters(CharSequence charSeq) throws IOException {
        int ch;
        ByteArrayInputStream is = new ByteArrayInputStream(charSeq.toString().getBytes());
        InputStreamReader isr = new InputStreamReader((InputStream)is, this.m_encoding);
        while ((ch = isr.read()) >= 0) {
            this.writeCharacters(ch);
        }
    }

    @Override
    public void writeCharacters(Integer ... chars) throws IOException {
        this.m_buffer.append(chars);
        int n = this.m_terminal.read(this.m_buffer);
        this.m_buffer.removeUntil(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recreateTerminalImage(int columns, int lines, boolean forceRepaint) {
        assert (SwingUtilities.isEventDispatchThread()) : "Should be called from EDT only!";
        Dimension dims = this.calculateSizeInPixels(columns, lines);
        if (this.m_image == null || this.m_image.getWidth() != dims.width || this.m_image.getHeight() != dims.height) {
            if (this.m_image != null) {
                this.m_image.flush();
            }
            this.m_image = this.getGraphicsConfiguration().createCompatibleImage(dims.width, dims.height);
            Graphics2D canvas = this.m_image.createGraphics();
            try {
                canvas.setBackground(this.m_colorScheme.getBackgroundColor());
                canvas.clearRect(0, 0, this.m_image.getWidth(), this.m_image.getHeight());
            }
            finally {
                canvas.dispose();
                canvas = null;
            }
            Insets insets = this.getInsets();
            super.setSize(dims.width + insets.left + insets.right, dims.height + insets.top + insets.bottom);
            this.repaint(50L);
        }
    }

    void updateTerminalImage(ITerminal.ITextCell[] cells, BitSet heatMap) {
        assert (SwingUtilities.isEventDispatchThread()) : "Should be called from the EDT only!";
        int columns = this.m_terminal.getWidth();
        int lines = this.m_terminal.getHeight();
        CharacterDimensions charDims = this.m_charDims;
        int cw = charDims.m_width;
        int ch = charDims.m_height;
        int ls = charDims.m_lineSpacing;
        if (this.m_image == null) {
            this.recreateTerminalImage(columns, lines, false);
        }
        Graphics2D canvas = this.m_image.createGraphics();
        canvas.setFont(this.getFont());
        Font font = this.getFont();
        FontMetrics fm = canvas.getFontMetrics();
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Color cursorColor = null;
        Rectangle repaintArea = null;
        if (this.m_oldCursor != null) {
            repaintArea = this.drawCursor(canvas, this.m_oldCursor, this.m_colorScheme.getBackgroundColor());
        }
        for (int i = 0; i < cells.length; ++i) {
            boolean cellChanged = heatMap.get(i);
            if (!cellChanged) continue;
            ITerminal.ITextCell cell = cells[i];
            int x = i % columns * cw;
            int y = i / columns * (ch + ls);
            Rectangle rect = new Rectangle(x, y, cw, ch + ls);
            canvas.setColor(this.convertToColor(cell.getBackground(), this.m_colorScheme.getBackgroundColor()));
            canvas.fillRect(rect.x, rect.y, rect.width, rect.height);
            String txt = Character.toString(cell.getChar());
            AttributedString attrStr = new AttributedString(txt);
            cursorColor = this.applyAttributes(cell, attrStr, font);
            AttributedCharacterIterator characterIterator = attrStr.getIterator();
            LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, frc);
            while (measurer.getPosition() < characterIterator.getEndIndex()) {
                TextLayout textLayout = measurer.nextLayout(this.getWidth());
                textLayout.draw(canvas, x, y + fm.getAscent());
            }
            repaintArea = SwingFrontend.union(repaintArea, rect);
        }
        this.m_oldCursor = this.m_terminal.getCursor().clone();
        if (cursorColor == null) {
            cursorColor = this.m_colorScheme.getTextColor();
        }
        repaintArea = SwingFrontend.union(repaintArea, this.drawCursor(canvas, this.m_oldCursor, cursorColor));
        canvas.dispose();
        if (repaintArea != null) {
            repaintArea.grow(5, 3);
            this.repaint(repaintArea);
        }
    }

    protected void mapKeyboard() {
        this.mapKeystroke(38);
        this.mapKeystroke(40);
        this.mapKeystroke(39);
        this.mapKeystroke(37);
        this.mapKeystroke(34);
        this.mapKeystroke(33);
        this.mapKeystroke(36);
        this.mapKeystroke(35);
        this.mapKeystroke(96);
        this.mapKeystroke(97);
        this.mapKeystroke(98);
        this.mapKeystroke(99);
        this.mapKeystroke(100);
        this.mapKeystroke(101);
        this.mapKeystroke(102);
        this.mapKeystroke(103);
        this.mapKeystroke(104);
        this.mapKeystroke(105);
        this.mapKeystroke(45);
        this.mapKeystroke(521);
        this.mapKeystroke(44);
        this.mapKeystroke(46);
        this.mapKeystroke(10);
        this.mapKeystroke(225);
        this.mapKeystroke(226);
        this.mapKeystroke(227);
        this.mapKeystroke(224);
        this.mapKeystroke(112);
        this.mapKeystroke(112, 512);
        this.mapKeystroke(113);
        this.mapKeystroke(113, 512);
        this.mapKeystroke(114);
        this.mapKeystroke(114, 512);
        this.mapKeystroke(115);
        this.mapKeystroke(115, 512);
        this.mapKeystroke(116);
        this.mapKeystroke(117);
        this.mapKeystroke(118);
        this.mapKeystroke(119);
        this.mapKeystroke(120);
        this.mapKeystroke(121);
        this.mapKeystroke(122);
        this.mapKeystroke(123);
    }

    protected String mapKeyCode(int keycode, int modifiers) {
        return this.getTerminal().getKeyMapper().map(keycode, modifiers);
    }

    protected void mapKeystroke(int keycode) {
        this.mapKeystroke(keycode, 0);
    }

    protected void mapKeystroke(int keycode, int modifiers) {
        KeyStroke keystroke = KeyStroke.getKeyStroke(keycode, modifiers);
        String key = keystroke.toString();
        this.getInputMap().put(keystroke, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics canvas) {
        this.m_listening = false;
        canvas.setColor(this.m_colorScheme.getBackgroundColor());
        Rectangle clip = canvas.getClipBounds();
        canvas.fillRect(clip.x, clip.y, clip.width, clip.height);
        try {
            Insets insets = this.getInsets();
            canvas.drawImage(this.m_image, insets.left, insets.top, null);
        }
        finally {
            this.m_listening = true;
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keystroke, KeyEvent event, int condition, boolean pressed) {
        if (!this.isEnabled()) {
            return false;
        }
        InputMap inputMap = this.getInputMap(condition);
        ActionMap actionMap = this.getActionMap();
        try {
            if (inputMap != null && actionMap != null && event.getID() == 401) {
                Object binding = inputMap.get(keystroke);
                if (binding != null) {
                    Action action = actionMap.get(binding);
                    if (action != null) {
                        return SwingUtilities.notifyAction(action, keystroke, event, this, event.getModifiers());
                    }
                    String mapping = this.mapKeyCode(keystroke.getKeyCode(), keystroke.getModifiers());
                    if (mapping != null) {
                        this.respond(mapping);
                        return true;
                    }
                }
                if (this.isRegularKey(keystroke)) {
                    this.respond(event.getKeyChar());
                    return true;
                }
            }
        }
        catch (IOException exception) {
            this.connectionListener.onException(exception);
        }
        return false;
    }

    protected void respond(char ch) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(ch);
            this.m_writer.flush();
        }
    }

    protected void respond(String chars) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(chars);
            this.m_writer.flush();
        }
    }

    private Color applyAttributes(ITerminal.ITextCell textCell, AttributedString attributedString, Font font) {
        Color fg = this.convertToColor(textCell.getForeground(), this.m_colorScheme.getTextColor());
        Color bg = this.convertToColor(textCell.getBackground(), this.m_colorScheme.getBackgroundColor());
        attributedString.addAttribute(TextAttribute.FAMILY, font.getFamily());
        attributedString.addAttribute(TextAttribute.SIZE, font.getSize());
        attributedString.addAttribute(TextAttribute.FOREGROUND, textCell.isReverse() ^ textCell.isHidden() ? bg : fg);
        attributedString.addAttribute(TextAttribute.BACKGROUND, textCell.isReverse() ? fg : bg);
        if (textCell.isUnderline()) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (textCell.isBold()) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (textCell.isItalic()) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return textCell.isReverse() ^ textCell.isHidden() ? bg : fg;
    }

    private Dimension calculateSizeInPixels(int columns, int lines) {
        CharacterDimensions charDims = this.m_charDims;
        int width = columns * charDims.m_width;
        int height = lines * (charDims.m_height + charDims.m_lineSpacing);
        return new Dimension(width, height);
    }

    private Insets calculateTotalInsets() {
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        Container ptr = this;
        do {
            Insets compInsets = ((Container)ptr).getInsets();
            insets.top += compInsets.top;
            insets.bottom += compInsets.bottom;
            insets.left += compInsets.left;
            insets.right += compInsets.right;
        } while ((ptr = ptr.getParent()) != null);
        return insets;
    }

    private Color convertToColor(int index, Color defaultColor) {
        if (index < 1) {
            return defaultColor;
        }
        return this.m_colorScheme.getColorByIndex(index - 1);
    }

    private Rectangle drawCursor(Graphics2D canvas, ICursor cursor, Color color) {
        if (!cursor.isVisible()) {
            return null;
        }
        CharacterDimensions charDims = this.m_charDims;
        int cw = charDims.m_width;
        int ch = charDims.m_height;
        int ls = charDims.m_lineSpacing;
        int x = cursor.getX() * cw;
        int y = cursor.getY() * (ch + ls);
        Rectangle rect = new Rectangle(x, y, cw, ch - 2 * ls);
        canvas.setColor(color);
        canvas.draw(rect);
        return rect;
    }

    private boolean isRegularKey(KeyStroke keystroke) {
        int c = keystroke.getKeyCode();
        return c != 0 && c != 16 && c != 18 && c != 65406 && c != 157 && c != 524 && c != 17;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    protected final class InputStreamWorker
    extends SwingWorker<Void, Integer> {
        private final InputStreamReader m_reader;

        public InputStreamWorker(InputStream inputStream, String encoding) throws IOException {
            this.m_reader = new InputStreamReader(inputStream, encoding);
        }

        @Override
        protected Void doInBackground() throws Exception {
            while (!this.isCancelled() && !Thread.currentThread().isInterrupted()) {
                int r = this.m_reader.read();
                if (r > 0) {
                    this.publish(r);
                    continue;
                }
                SwingFrontend.this.connectionListener.onConnectionClosed();
                return null;
            }
            return null;
        }

        @Override
        protected void process(List<Integer> readChars) {
            Integer[] chars = readChars.toArray(new Integer[readChars.size()]);
            try {
                SwingFrontend.this.writeCharacters(chars);
            }
            catch (IOException exception) {
                SwingFrontend.this.connectionListener.onException(exception);
            }
        }
    }

    static final class CharacterDimensions {
        final int m_height;
        final int m_width;
        final int m_lineSpacing;

        public CharacterDimensions(int width, int height, int lineSpacing) {
            this.m_width = width;
            this.m_height = height;
            this.m_lineSpacing = lineSpacing;
        }
    }
}

