/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.swing;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

final class CharBuffer
implements CharSequence {
    private final AtomicReference<CharBufferState> stateRef;

    public CharBuffer() {
        this.stateRef = new AtomicReference<CharBufferState>(new CharBufferState(new Integer[10], 0));
    }

    public CharBuffer(Integer ... aInitialValue) {
        if (aInitialValue == null) {
            throw new IllegalArgumentException("InitialValue cannot be null!");
        }
        Integer[] initialValue = Arrays.copyOf(aInitialValue, aInitialValue.length + 10);
        int appendPos = aInitialValue.length;
        this.stateRef = new AtomicReference<CharBufferState>(new CharBufferState(initialValue, appendPos));
    }

    public void append(Integer ... aChars) {
        int curAppendPos;
        Integer[] curArray;
        CharBufferState newState;
        CharBufferState curState;
        if (aChars == null) {
            throw new IllegalArgumentException("Chars cannot be null!");
        }
        do {
            curState = this.stateRef.get();
            curAppendPos = curState.appendPos;
            curArray = curState.chars;
            if (curAppendPos + aChars.length >= curArray.length) {
                curArray = Arrays.copyOf(curArray, curArray.length + aChars.length + 10);
            }
            System.arraycopy(aChars, 0, curArray, curAppendPos, aChars.length);
        } while (!this.stateRef.compareAndSet(curState, newState = new CharBufferState(curArray, curAppendPos + aChars.length)));
    }

    @Override
    public char charAt(int aIndex) {
        CharBufferState state = this.stateRef.get();
        Integer[] chars = state.chars;
        int appendPos = state.appendPos;
        if (aIndex < 0 || aIndex >= appendPos) {
            throw new IndexOutOfBoundsException();
        }
        Integer integer = chars[aIndex];
        return (char)(integer == null ? 0 : integer);
    }

    @Override
    public int length() {
        CharBufferState state = this.stateRef.get();
        return state.appendPos;
    }

    public void removeUntil(int aPosition) {
        CharBufferState newState;
        CharBufferState curState;
        int oldAppendPos = -1;
        do {
            curState = this.stateRef.get();
            int position = aPosition;
            int curAppendPos = curState.appendPos;
            Integer[] curArray = curState.chars;
            if (oldAppendPos >= 0) {
                if (oldAppendPos > curAppendPos) {
                    position -= oldAppendPos - curAppendPos;
                }
            } else if (position < 0 || position > curAppendPos) {
                throw new IndexOutOfBoundsException("Position cannot be negative or beyond the length of this buffer!");
            }
            if (position <= 0) {
                return;
            }
            int newSize = Math.max(0, curArray.length - position);
            Integer[] newArray = new Integer[newSize];
            System.arraycopy(curArray, position, newArray, 0, newSize);
            int newAppendPos = Math.max(0, curAppendPos - position);
            newState = new CharBufferState(newArray, newAppendPos);
            oldAppendPos = curAppendPos;
        } while (!this.stateRef.compareAndSet(curState, newState));
    }

    @Override
    public CharSequence subSequence(int aStart, int aEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        CharBufferState state = this.stateRef.get();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < state.appendPos; ++i) {
            int c = state.chars[i];
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("<").append(c).append(">");
        }
        return sb.toString();
    }

    private static class CharBufferState {
        final Integer[] chars;
        final int appendPos;

        public CharBufferState(Integer[] aChars, int aAppendPos) {
            this.chars = aChars;
            this.appendPos = aAppendPos;
        }
    }
}

