/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import nl.lxtreme.jvt220.terminal.ITerminal;
import nl.lxtreme.jvt220.terminal.ScreenChangeListener;
import nl.lxtreme.jvt220.terminal.swing.SwingFrontend;

public class SwingFrontendProxy
extends SwingFrontend {
    private static final int MAX_THREAD_POOL = 150;
    private List<ScreenChangeListener> screenChangeListeners = new CopyOnWriteArrayList<ScreenChangeListener>();
    private ExecutorService swingThreadPool;

    @Override
    public void connect(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null!");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        this.disconnect();
        this.m_writer = new OutputStreamWriter(outputStream, this.m_encoding);
        ThreadFactory threadFactory = r -> new Thread(r, "jVT-Frontend-Workers");
        this.m_inputStreamWorker = new SwingFrontend.InputStreamWorker(this, inputStream, this.m_encoding);
        this.swingThreadPool = Executors.newFixedThreadPool(150, threadFactory);
        this.swingThreadPool.submit(this.m_inputStreamWorker);
        this.setEnabled(true);
    }

    @Override
    public void disconnect() {
        if (this.m_inputStreamWorker != null) {
            if (this.swingThreadPool != null) {
                this.swingThreadPool.shutdownNow();
            }
            this.m_inputStreamWorker.cancel(true);
            this.m_inputStreamWorker = null;
        }
    }

    @Override
    public boolean isListening() {
        return true;
    }

    @Override
    public void terminalChanged(ITerminal.ITextCell[] cells, BitSet heatMap) {
        this.screenChangeListeners.forEach(l -> l.screenChanged(super.getTerminal().toString()));
    }

    @Override
    public void terminalSizeChanged(int columns, int alines) {
    }

    public void addScreenChangeListener(ScreenChangeListener listener) {
        this.screenChangeListeners.add(listener);
    }

    public void removeScreenChangeListener(ScreenChangeListener listener) {
        this.screenChangeListeners.remove(listener);
    }
}

