/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import nl.lxtreme.jvt220.terminal.ConnectionListener;

public class ConnectionListenerBroadcast
implements ConnectionListener {
    private final Set<ConnectionListener> listeners = ConcurrentHashMap.newKeySet();

    @Override
    public void onException(Throwable e) {
        this.notifyOf(l -> l.onException(e));
    }

    @Override
    public void onConnectionClosed() {
        this.notifyOf(ConnectionListener::onConnectionClosed);
    }

    @Override
    public void onConnection() {
        this.notifyOf(ConnectionListener::onConnection);
    }

    private void notifyOf(Consumer<? super ConnectionListener> event) {
        this.listeners.forEach(event);
    }

    public void add(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void remove(ConnectionListener listener) {
        this.listeners.remove(listener);
    }
}

