/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.shaded;

import java.io.IOException;
import java.io.OutputStream;
import javax.net.SocketFactory;
import nl.lxtreme.jvt220.shaded.telnetEchoOptionHandler;
import nl.lxtreme.jvt220.shaded.telnetInvalidTelnetOptionException;
import nl.lxtreme.jvt220.shaded.telnetSuppressGAOptionHandler;
import nl.lxtreme.jvt220.shaded.telnetTelnetClient;
import nl.lxtreme.jvt220.shaded.telnetTerminalTypeOptionHandler;

public class telnetVT420Client
extends telnetTelnetClient {
    private OutputStream outputStream;
    private final String terminalType;

    public telnetVT420Client(String terminalType) {
        super(terminalType);
        this.terminalType = terminalType;
    }

    public void setupOptionHandlers() throws telnetInvalidTelnetOptionException, IOException {
        this.addOptionHandler(new telnetTerminalTypeOptionHandler(this.terminalType, false, false, true, false));
        this.addOptionHandler(new telnetEchoOptionHandler(true, false, true, true));
        this.addOptionHandler(new telnetSuppressGAOptionHandler(true, true, true, true));
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this.outputStream = new VT420OutputStream(this);
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        super.setSocketFactory(factory);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            super.disconnect();
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream = null;
            }
        }
    }

    private static class VT420OutputStream
    extends OutputStream {
        private final telnetTelnetClient client;
        private boolean lastWasCr;

        private VT420OutputStream(telnetTelnetClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int ch) throws IOException {
            telnetTelnetClient telnetTelnetClient2 = this.client;
            synchronized (telnetTelnetClient2) {
                ch &= 0xFF;
                if (this.client._requestedWont(0)) {
                    switch (ch) {
                        case 13: {
                            this.client._sendByte(13);
                            this.client._sendByte(0);
                            this.lastWasCr = true;
                            break;
                        }
                        case 10: {
                            if (!this.lastWasCr) {
                                this.client._sendByte(13);
                            }
                            this.client._sendByte(ch);
                            this.lastWasCr = false;
                            break;
                        }
                        case 255: {
                            this.client._sendByte(255);
                            this.client._sendByte(255);
                            this.lastWasCr = false;
                            break;
                        }
                        default: {
                            this.client._sendByte(ch);
                            this.lastWasCr = false;
                            break;
                        }
                    }
                } else if (ch == 255) {
                    this.client._sendByte(ch);
                    this.client._sendByte(255);
                } else {
                    this.client._sendByte(ch);
                }
            }
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buffer, int offset, int length) throws IOException {
            telnetTelnetClient telnetTelnetClient2 = this.client;
            synchronized (telnetTelnetClient2) {
                while (length-- > 0) {
                    this.write(buffer[offset++]);
                }
            }
        }

        @Override
        public void flush() throws IOException {
            this.client._flushOutputStream();
        }

        @Override
        public void close() throws IOException {
            this.client._closeOutputStream();
        }
    }
}

