/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.telnet;

import com.bytezone.dm3270.telnet.TelnetCommandProcessor;

public class TelnetProcessor {
    public static final byte EOR = -17;
    private static final byte IAC = -1;
    private static final byte SE = -16;
    private static final byte NOP = -15;
    private static final byte IP = -12;
    private static final byte SB = -6;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private final byte[] data = new byte[16500];
    private int dataPtr;
    private boolean pending;
    private boolean weirdData;
    private byte command;
    private final TelnetCommandProcessor commandProcessor;

    public TelnetProcessor(TelnetCommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public void listen(byte ... buffer) {
        for (byte thisByte : buffer) {
            this.data[this.dataPtr++] = thisByte;
            if (thisByte == -1) {
                if (this.pending) {
                    this.pending = false;
                    --this.dataPtr;
                    if (this.dataPtr != 1) continue;
                    this.weirdData = true;
                    continue;
                }
                this.pending = true;
                continue;
            }
            if (this.pending) {
                this.pending = false;
                if (thisByte == -17) {
                    this.commandProcessor.processRecord(this.data, this.dataPtr);
                    this.reset();
                    continue;
                }
                if (this.data[0] != -1 || this.weirdData) {
                    this.dataPtr -= 2;
                    this.commandProcessor.processData(this.data, this.dataPtr);
                    this.reset();
                    this.data[this.dataPtr++] = -1;
                    this.data[this.dataPtr++] = thisByte;
                }
                if (thisByte == -6) continue;
                if (thisByte == -16) {
                    this.commandProcessor.processTelnetSubcommand(this.data, this.dataPtr);
                    this.reset();
                    continue;
                }
                if (thisByte == -3 || thisByte == -2 || thisByte == -5 | thisByte == -4) {
                    this.command = thisByte;
                    continue;
                }
                if (thisByte == -15 || thisByte == -12) {
                    this.commandProcessor.processTelnetCommand(this.data, this.dataPtr);
                    this.reset();
                    continue;
                }
                System.err.printf("Unknown command: %02X%n", thisByte);
                continue;
            }
            if (this.command == 0) continue;
            this.commandProcessor.processTelnetCommand(this.data, this.dataPtr);
            this.reset();
        }
    }

    private void reset() {
        this.dataPtr = 0;
        this.command = 0;
        this.weirdData = false;
    }
}

