/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.telnet;

import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.streams.TelnetState;
import com.bytezone.dm3270.telnet.TelnetSubcommand;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TN3270ExtendedSubcommand
extends TelnetSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(TN3270ExtendedSubcommand.class);
    private static final byte EXT_DEVICE_TYPE = 2;
    private static final byte EXT_FUNCTIONS = 3;
    private static final byte EXT_IS = 4;
    private static final byte EXT_REQUEST = 7;
    private static final byte EXT_SEND = 8;
    private SubType subType;
    private String luName = "";
    private List<Function> functions;
    private String functionsList = "";

    public TN3270ExtendedSubcommand(byte[] buffer, int offset, int length, TelnetState telnetState) {
        super(buffer, offset, length, telnetState);
        switch (buffer[3]) {
            case 8: {
                this.type = TelnetSubcommand.SubcommandType.SEND;
                if (buffer[4] != 2) break;
                this.subType = SubType.DEVICE_TYPE;
                break;
            }
            case 2: {
                this.type = TelnetSubcommand.SubcommandType.DEVICE_TYPE;
                if (buffer[4] == 7) {
                    this.subType = SubType.REQUEST;
                    this.value = new String(buffer, 5, length - 7);
                    break;
                }
                if (buffer[4] != 4) break;
                this.subType = SubType.IS;
                for (int ptr = 6; ptr < length; ++ptr) {
                    if (buffer[ptr] != 1) continue;
                    this.value = new String(buffer, 5, ptr - 5);
                    this.luName = new String(buffer, ptr + 1, length - ptr - 3);
                    break;
                }
                if (this.value != null) break;
                this.value = new String(buffer, 5, length - 5);
                break;
            }
            case 3: {
                this.type = TelnetSubcommand.SubcommandType.FUNCTIONS;
                if (buffer[4] == 7) {
                    this.subType = SubType.REQUEST;
                    this.setFunctions(buffer, length);
                    break;
                }
                if (buffer[4] != 4) break;
                this.subType = SubType.IS;
                this.setFunctions(buffer, length);
                break;
            }
            default: {
                throw new InvalidParameterException(String.format("Unknown Extended: %02X", buffer[3]));
            }
        }
    }

    private void setFunctions(byte[] buffer, int length) {
        StringBuilder funcList = new StringBuilder();
        this.functions = new ArrayList<Function>();
        int max = length - 2;
        for (int ptr = 5; ptr < max; ++ptr) {
            if (buffer[ptr] == 0) {
                this.functions.add(Function.BIND_IMAGE);
                funcList.append("BIND, ");
                continue;
            }
            if (buffer[ptr] == 2) {
                this.functions.add(Function.RESPONSES);
                funcList.append("RESPONSES, ");
                continue;
            }
            if (buffer[ptr] == 4) {
                this.functions.add(Function.SYSREQ);
                funcList.append("SYSREQ, ");
                continue;
            }
            if (buffer[ptr] == 5) {
                this.functions.add(Function.REASON);
                funcList.append("REASON, ");
                continue;
            }
            throw new InvalidParameterException(String.format("Unknown function: %02X%n", buffer[ptr]));
        }
        if (funcList.length() > 0) {
            funcList.deleteCharAt(funcList.length() - 1);
            funcList.deleteCharAt(funcList.length() - 1);
        }
        this.functionsList = funcList.toString();
    }

    @Override
    public void process(Screen screen) {
        byte[] reply;
        if (this.type == TelnetSubcommand.SubcommandType.SEND && this.subType == SubType.DEVICE_TYPE) {
            byte[] header = new byte[]{-1, -6, 40, 2, 7};
            String terminalType = this.telnetState.doDeviceType();
            byte[] terminal = terminalType.getBytes(StandardCharsets.US_ASCII);
            byte[] reply2 = new byte[header.length + terminal.length + 2];
            System.arraycopy(header, 0, reply2, 0, header.length);
            System.arraycopy(terminal, 0, reply2, header.length, terminal.length);
            reply2[reply2.length - 2] = -1;
            reply2[reply2.length - 1] = -16;
            this.setReply(new TN3270ExtendedSubcommand(reply2, 0, reply2.length, this.telnetState));
        }
        if (this.type == TelnetSubcommand.SubcommandType.DEVICE_TYPE && this.subType == SubType.IS) {
            reply = new byte[]{-1, -6, 40, 3, 7, 0, 2, 4, -1, -16};
            this.setReply(new TN3270ExtendedSubcommand(reply, 0, reply.length, this.telnetState));
        }
        switch (this.subType) {
            case REQUEST: {
                if (this.type != TelnetSubcommand.SubcommandType.FUNCTIONS) break;
                reply = new byte[this.data.length];
                System.arraycopy(this.data, 0, reply, 0, this.data.length);
                reply[4] = 4;
                this.setReply(new TN3270ExtendedSubcommand(reply, 0, reply.length, this.telnetState));
                break;
            }
            case IS: {
                if (this.type == TelnetSubcommand.SubcommandType.FUNCTIONS) {
                    this.telnetState.setFunctions(this.functions);
                    break;
                }
                if (this.type != TelnetSubcommand.SubcommandType.DEVICE_TYPE) break;
                this.telnetState.setDeviceType(this.getValue());
                break;
            }
            case DEVICE_TYPE: {
                break;
            }
            default: {
                LOG.warn("Unknown subtype: {}", (Object)this.subType);
            }
        }
    }

    @Override
    public String toString() {
        switch (this.type) {
            case SEND: {
                return (Object)((Object)this.type) + " " + (Object)((Object)this.subType);
            }
            case FUNCTIONS: {
                return (Object)((Object)this.type) + " " + (Object)((Object)this.subType) + " : " + this.functionsList;
            }
            case DEVICE_TYPE: {
                String connectText = this.luName.isEmpty() ? "" : " (" + this.luName + ")";
                return (Object)((Object)this.type) + " " + (Object)((Object)this.subType) + " " + this.value + connectText;
            }
        }
        return "SUB: Unknown";
    }

    public static enum Function {
        BIND_IMAGE,
        RESPONSES,
        SYSREQ,
        REASON;

    }

    private static enum SubType {
        IS,
        REQUEST,
        DEVICE_TYPE;

    }
}

