/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.streams;

import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.streams.TerminalServer;
import com.bytezone.dm3270.telnet.TN3270ExtendedSubcommand;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetState
implements Runnable {
    public static final byte[] NO_OP = new byte[]{-1, -15};
    private static final Logger LOG = LoggerFactory.getLogger(TelnetState.class);
    private static final String[] TERMINAL_TYPES = new String[]{"", "", "IBM-3278-2", "IBM-3278-3", "IBM-3278-4", "IBM-3278-5"};
    private boolean do3270Extended;
    private int commandHeaderCount;
    private boolean doBinary;
    private boolean doEOR;
    private boolean doTerminalType;
    private String doDeviceType;
    private boolean does3270Extended;
    private boolean doesEOR;
    private boolean doesBinary;
    private boolean doesTerminalType;
    private String deviceType = "";
    private List<TN3270ExtendedSubcommand.Function> functions;
    private String terminal = "";
    private TerminalServer terminalServer;
    private AtomicLong lastAccess;
    private volatile boolean running = false;
    private Thread thread;
    private ScreenDimensions secondary = new ScreenDimensions(24, 80);

    public TelnetState() {
        this.setDo3270Extended(true);
        this.setDoDeviceType(2);
        this.setDoEOR(true);
        this.setDoBinary(true);
        this.setDoTerminalType(true);
        this.lastAccess = new AtomicLong(System.currentTimeMillis());
    }

    public void setTerminalServer(TerminalServer terminalServer) {
        this.terminalServer = terminalServer;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void setLastAccess() {
        this.lastAccess.set(System.currentTimeMillis());
    }

    public void write(byte[] buffer) {
        if (this.terminalServer != null) {
            this.terminalServer.write(buffer);
        }
        this.lastAccess.set(System.currentTimeMillis());
    }

    public int nextCommandHeaderSeq() {
        return this.commandHeaderCount++;
    }

    @Override
    public void run() {
        this.running = true;
        long limit = 120L;
        while (this.running) {
            try {
                long lastTimeIChecked = this.lastAccess.get();
                long delay = (System.currentTimeMillis() - lastTimeIChecked) / 1000L;
                long sleep = limit - delay;
                if (sleep > 1L) {
                    Thread.sleep(sleep * 1000L);
                }
                if (lastTimeIChecked != this.lastAccess.get()) continue;
                this.write(NO_OP);
            }
            catch (InterruptedException e) {
                if (this.running) {
                    LOG.debug("TelnetState was interrupted.");
                }
                this.close();
                return;
            }
        }
    }

    public void close() {
        if (this.thread != null) {
            this.running = false;
            this.thread.interrupt();
        }
    }

    public ScreenDimensions getSecondary() {
        return this.secondary;
    }

    public void setDoes3270Extended(boolean state) {
        LOG.debug("Does Extended: {}", (Object)state);
        this.does3270Extended = state;
    }

    public void setDoesEOR(boolean state) {
        LOG.debug("Does EOR: {}", (Object)state);
        this.doesEOR = state;
    }

    public void setDoesBinary(boolean state) {
        LOG.debug("Does Binary: {}", (Object)state);
        this.doesBinary = state;
    }

    public void setDoesTerminalType(boolean state) {
        LOG.debug("Does Terminal type: {}", (Object)state);
        this.doesTerminalType = state;
    }

    public void setTerminal(String terminal) {
        LOG.debug("Terminal: {}", (Object)terminal);
        this.terminal = terminal;
    }

    public void setDeviceType(String deviceType) {
        LOG.debug("Device Type: {}", (Object)deviceType);
        this.deviceType = deviceType;
        int modelNo = 0;
        for (int i = 2; i <= 5; ++i) {
            if (!TERMINAL_TYPES[i].equals(deviceType)) continue;
            modelNo = i;
            break;
        }
        switch (modelNo) {
            case 2: {
                this.secondary = new ScreenDimensions(24, 80);
                break;
            }
            case 3: {
                this.secondary = new ScreenDimensions(32, 80);
                break;
            }
            case 4: {
                this.secondary = new ScreenDimensions(43, 80);
                break;
            }
            case 5: {
                this.secondary = new ScreenDimensions(27, 132);
                break;
            }
            default: {
                this.secondary = new ScreenDimensions(24, 80);
                LOG.debug("Model not found: {}", (Object)deviceType);
            }
        }
    }

    public void setFunctions(List<TN3270ExtendedSubcommand.Function> functions) {
        LOG.debug("Functions: {}", functions);
        this.functions = functions;
    }

    public boolean does3270Extended() {
        return this.does3270Extended;
    }

    public boolean doesEOR() {
        return this.doesEOR || this.does3270Extended;
    }

    public boolean doesBinary() {
        return this.doesBinary || this.does3270Extended;
    }

    public boolean doesTerminalType() {
        return this.doesTerminalType || this.does3270Extended;
    }

    public boolean do3270Extended() {
        return this.do3270Extended;
    }

    public boolean doEOR() {
        return this.doEOR;
    }

    public boolean doBinary() {
        return this.doBinary;
    }

    public boolean doTerminalType() {
        return this.doTerminalType;
    }

    public String doDeviceType() {
        return this.doDeviceType;
    }

    public void setDo3270Extended(boolean state) {
        this.do3270Extended = state;
    }

    public void setDoBinary(boolean state) {
        this.doBinary = state;
    }

    public void setDoEOR(boolean state) {
        this.doEOR = state;
    }

    public void setDoTerminalType(boolean state) {
        this.doTerminalType = state;
    }

    public void setDoDeviceType(int modelNo) {
        this.doDeviceType = TERMINAL_TYPES[modelNo];
        LOG.debug("setting: {}", (Object)this.doDeviceType);
    }

    public String toString() {
        return String.format("3270 ext ........ %s%n", this.does3270Extended) + String.format("binary .......... %s%n", this.doesBinary) + String.format("EOR ............. %s%n", this.doesEOR) + String.format("terminal type ... %s%n", this.doesTerminalType) + String.format("terminal ........ %s%n", this.terminal) + String.format("device type ..... %s%n", this.deviceType) + String.format("functions ....... %s", this.functions);
    }
}

