/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.nio.ByteBuffer;

public class UsableArea
extends QueryReplyField {
    private static final int HARD_COPY_FLAG_MASK = 1;
    private static final int PAGE_PRINTER_FLAG_MASK = 4;
    private final AddressingMode addressingMode;
    private final boolean hardCopy;
    private final boolean pagePrinter;
    private final short width;
    private final short height;
    private final MeasurementUnit measurementUnit;
    private final short xPointsDistanceNumerator;
    private final short xPointsDistanceDenominator;
    private final short yPointsDistanceNumerator;
    private final short yPointsDistanceDenominator;
    private final byte defaultCellXUnits;
    private final byte defaultCellYUnits;
    private final short bufferSize;

    public UsableArea(int rows, int columns) {
        super((byte)-127);
        this.addressingMode = AddressingMode.ADDRESSING_12_14_BIT;
        this.hardCopy = false;
        this.pagePrinter = false;
        this.width = (short)columns;
        this.height = (short)rows;
        this.measurementUnit = MeasurementUnit.MILLIMETRES;
        this.xPointsDistanceNumerator = (short)211;
        this.xPointsDistanceDenominator = (short)800;
        this.yPointsDistanceNumerator = (short)158;
        this.yPointsDistanceDenominator = (short)600;
        this.defaultCellXUnits = (byte)7;
        this.defaultCellYUnits = (byte)12;
        this.bufferSize = (short)(rows * columns);
        ByteBuffer buffer = this.createReplyBuffer(19);
        byte flags1 = this.flagsToByte();
        buffer.put(flags1);
        byte flags2 = 0;
        buffer.put(flags2);
        buffer.putShort(this.width);
        buffer.putShort(this.height);
        buffer.put(this.measurementUnit.id);
        buffer.putShort(this.xPointsDistanceNumerator);
        buffer.putShort(this.xPointsDistanceDenominator);
        buffer.putShort(this.yPointsDistanceNumerator);
        buffer.putShort(this.yPointsDistanceDenominator);
        buffer.put(this.defaultCellXUnits);
        buffer.put(this.defaultCellYUnits);
        buffer.putShort(this.bufferSize);
    }

    public UsableArea(byte[] buffer) {
        super(buffer);
        ByteBuffer dataBuffer = ByteBuffer.wrap(buffer);
        dataBuffer.get();
        assert (dataBuffer.get() == -127);
        byte flags1 = dataBuffer.get();
        this.addressingMode = AddressingMode.fromByte((byte)(flags1 & 0xF));
        this.hardCopy = (flags1 & 1) != 0;
        this.pagePrinter = (flags1 & 4) != 0;
        dataBuffer.get();
        this.width = dataBuffer.getShort();
        this.height = dataBuffer.getShort();
        this.measurementUnit = MeasurementUnit.fromByte(dataBuffer.get());
        this.xPointsDistanceNumerator = dataBuffer.getShort();
        this.xPointsDistanceDenominator = dataBuffer.getShort();
        this.yPointsDistanceNumerator = dataBuffer.getShort();
        this.yPointsDistanceDenominator = dataBuffer.getShort();
        this.defaultCellXUnits = dataBuffer.get();
        this.defaultCellYUnits = dataBuffer.get();
        this.bufferSize = dataBuffer.getShort();
    }

    private byte flagsToByte() {
        byte flags = this.addressingMode.id;
        if (this.hardCopy) {
            flags = (byte)(flags | 1);
        }
        if (this.pagePrinter) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public ScreenDimensions getScreenDimensions() {
        return new ScreenDimensions(this.height, this.width);
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n  flags     : %02X", this.flagsToByte()) + String.format("%n  ad mode    : %d - %s", this.addressingMode.id, this.addressingMode.name) + String.format("%n  width      : %d", this.width) + String.format("%n  height     : %d", this.height) + String.format("%n  units      : %d - %s", this.measurementUnit.id, this.measurementUnit.name) + String.format("%n  x ratio    : %d / %d", this.xPointsDistanceNumerator, this.xPointsDistanceDenominator) + String.format("%n  y ratio    : %d / %d", this.yPointsDistanceNumerator, this.yPointsDistanceDenominator) + String.format("%n  x units    : %d", this.defaultCellXUnits) + String.format("%n  y units    : %d", this.defaultCellYUnits) + String.format("%n  buffer     : %d", this.bufferSize);
    }

    private static class AddressingMode {
        private static final String RESERVED = "Reserved";
        private static final AddressingMode ADDRESSING_12_14_BIT = new AddressingMode(1, "12/14 bit");
        private static final AddressingMode ADDRESSING_14_14_16_BIT = new AddressingMode(3, "12/14/16 bit");
        private static final AddressingMode[] MODES = new AddressingMode[]{new AddressingMode(0, "Reserved"), ADDRESSING_12_14_BIT, new AddressingMode(1, "Reserved"), ADDRESSING_14_14_16_BIT};
        private final byte id;
        private final String name;

        private AddressingMode(int id, String name) {
            this.id = (byte)id;
            this.name = name;
        }

        static AddressingMode fromByte(byte b) {
            int val = b & 0xF;
            return val < MODES.length ? MODES[val] : new AddressingMode(val, "Unknown");
        }
    }

    private static class MeasurementUnit {
        private static final MeasurementUnit INCHES = new MeasurementUnit(0, "Inches");
        private static final MeasurementUnit MILLIMETRES = new MeasurementUnit(1, "Millimetres");
        private static final MeasurementUnit[] UNITS = new MeasurementUnit[]{INCHES, MILLIMETRES};
        private final byte id;
        private final String name;

        MeasurementUnit(int id, String name) {
            this.id = (byte)id;
            this.name = name;
        }

        static MeasurementUnit fromByte(byte val) {
            return val < UNITS.length ? UNITS[val] : new MeasurementUnit(val, "Unknown");
        }
    }
}

