/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.replyfield.AlphanumericPartitions;
import com.bytezone.dm3270.replyfield.AuxiliaryDevices;
import com.bytezone.dm3270.replyfield.CharacterSets;
import com.bytezone.dm3270.replyfield.Color;
import com.bytezone.dm3270.replyfield.DefaultReply;
import com.bytezone.dm3270.replyfield.DistributedDataManagement;
import com.bytezone.dm3270.replyfield.Highlight;
import com.bytezone.dm3270.replyfield.ImplicitPartition;
import com.bytezone.dm3270.replyfield.OEMAuxiliaryDevice;
import com.bytezone.dm3270.replyfield.RPQNames;
import com.bytezone.dm3270.replyfield.ReplyModes;
import com.bytezone.dm3270.replyfield.Segment;
import com.bytezone.dm3270.replyfield.Summary;
import com.bytezone.dm3270.replyfield.Transparency;
import com.bytezone.dm3270.replyfield.UsableArea;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class QueryReplyField {
    public static final byte SUMMARY_QUERY_REPLY = -128;
    public static final byte USABLE_AREA_REPLY = -127;
    public static final byte ALPHANUMERIC_PARTITIONS_REPLY = -124;
    public static final byte CHARACTER_SETS_REPLY = -123;
    public static final byte COLOR_QUERY_REPLY = -122;
    public static final byte HIGHLIGHT_QUERY_REPLY = -121;
    public static final byte REPLY_MODES_REPLY = -120;
    public static final byte OEM_AUXILIARY_DEVICE_REPLY = -113;
    public static final byte DISTRIBUTED_DATA_MANAGEMENT_REPLY = -107;
    public static final byte AUXILIARY_DEVICE_REPLY = -103;
    public static final byte RPQ_NAMES_REPLY = -95;
    public static final byte IMP_PART_QUERY_REPLY = -90;
    public static final byte TRANSPARENCY_REPLY = -88;
    public static final byte SEGMENT_REPLY = -80;
    private static final byte STORAGE_POOLS_REPLY = -106;
    private static final byte PROCEDURE_REPLY = -79;
    private static final byte LINE_TYPE_REPLY = -78;
    private static final byte PORT_REPLY = -77;
    private static final byte GRAPHIC_COLOR_REPLY = -76;
    private static final byte GRAPHIC_SYMBOL_SETS_REPLY = -74;
    protected byte[] data;
    protected final ReplyType replyType;
    protected byte[] reply;
    protected List<QueryReplyField> replies;

    public QueryReplyField(byte replyType) {
        this.replyType = ReplyType.fromId(replyType);
    }

    public QueryReplyField(byte[] buffer) {
        assert (buffer[0] == -127);
        this.data = buffer;
        this.replyType = ReplyType.fromId(buffer[1]);
    }

    public ReplyType getReplyType() {
        return this.replyType;
    }

    public static QueryReplyField getReplyField(byte[] buffer, Charset charset) {
        assert (buffer[0] == -127);
        switch (buffer[1]) {
            case -128: {
                return new Summary(buffer);
            }
            case -127: {
                return new UsableArea(buffer);
            }
            case -124: {
                return new AlphanumericPartitions(buffer);
            }
            case -123: {
                return new CharacterSets(buffer);
            }
            case -122: {
                return new Color(buffer);
            }
            case -121: {
                return new Highlight(buffer);
            }
            case -120: {
                return new ReplyModes(buffer);
            }
            case -113: {
                return new OEMAuxiliaryDevice(buffer, charset);
            }
            case -107: {
                return new DistributedDataManagement(buffer);
            }
            case -103: {
                return new AuxiliaryDevices(buffer);
            }
            case -95: {
                return new RPQNames(buffer, charset);
            }
            case -90: {
                return new ImplicitPartition(buffer);
            }
            case -88: {
                return new Transparency(buffer);
            }
            case -80: {
                return new Segment(buffer);
            }
        }
        return new DefaultReply(buffer, charset);
    }

    public void addReplyFields(List<QueryReplyField> replies) {
        this.replies = replies;
    }

    protected boolean isProvided(byte type) {
        for (QueryReplyField reply : this.replies) {
            if (reply.replyType.type != type) continue;
            return true;
        }
        return false;
    }

    private Optional<Summary> getSummary() {
        for (QueryReplyField reply : this.replies) {
            if (reply.replyType.type != -128) continue;
            return Optional.of((Summary)reply);
        }
        return Optional.empty();
    }

    protected int createReply(int size) {
        this.reply = new byte[size += 4];
        int ptr = Buffer.packUnsignedShort(size, this.reply, 0);
        this.reply[ptr++] = -127;
        this.reply[ptr++] = this.replyType.type;
        return ptr;
    }

    protected ByteBuffer createReplyBuffer(int size) {
        int ptr = this.createReply(size);
        return ByteBuffer.wrap(this.reply, ptr, this.reply.length - ptr);
    }

    public int packReply(byte[] buffer, int ptr) {
        System.arraycopy(this.reply, 0, buffer, ptr, this.reply.length);
        return ptr += this.reply.length;
    }

    protected boolean checkDataLength(int ptr) {
        assert (ptr == this.reply.length) : String.format("Length:%d, Ptr:%d", this.reply.length, ptr);
        return true;
    }

    public int replySize() {
        return this.reply.length;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        Optional<Summary> summary = this.getSummary();
        String message = summary.map(value -> value.isListed(this.replyType.type) ? "" : "** missing **").orElse("no summary");
        text.append(String.format("  Type       : %-30s %s%n", this.replyType, message));
        return text.toString();
    }

    public static class ReplyType {
        private static final List<ReplyType> REPLY_TYPES = Arrays.asList(new ReplyType(-128, "Summary"), new ReplyType(-127, "Usable Area"), new ReplyType(-124, "Alphanumeric Partitions"), new ReplyType(-123, "Character Sets"), new ReplyType(-122, "Color"), new ReplyType(-121, "Highlight"), new ReplyType(-120, "Reply Modes"), new ReplyType(-113, "OEM Aux Devices"), new ReplyType(-107, "Distributed Data Management"), new ReplyType(-106, "Storage Pools"), new ReplyType(-103, "Auxiliary Devices"), new ReplyType(-95, "RPQ Names"), new ReplyType(-90, "Implicit Partition"), new ReplyType(-88, "Transparency"), new ReplyType(-80, "Segment"), new ReplyType(-79, "Procedure"), new ReplyType(-78, "Line Type"), new ReplyType(-77, "Port"), new ReplyType(-76, "Graphic Color"), new ReplyType(-74, "Graphic Symbol Sets"));
        public final byte type;
        public final String name;

        private ReplyType(byte type, String name) {
            this.type = type;
            this.name = name;
        }

        public static ReplyType fromId(byte id) {
            for (ReplyType rt : REPLY_TYPES) {
                if (id != rt.type) continue;
                return rt;
            }
            return new ReplyType(id, "Unknown Reply Type");
        }

        public String toString() {
            return String.format("%02X %s", this.type, this.name);
        }
    }
}

