/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.orders.BufferAddress;
import com.bytezone.dm3270.orders.Order;

public class RepeatToAddressOrder
extends Order {
    private final BufferAddress stopAddress;
    private char repeatCharacter;
    private byte rptChar;

    public RepeatToAddressOrder(byte[] buffer, int offset, Charset charset) {
        assert (buffer[offset] == 60);
        this.stopAddress = new BufferAddress(buffer[offset + 1], buffer[offset + 2]);
        if (buffer[offset + 3] == 8) {
            this.repeatCharacter = charset.getChar(buffer[offset + 4]);
            this.rptChar = buffer[offset + 4];
            this.buffer = new byte[6];
        } else {
            this.repeatCharacter = charset.getChar(buffer[offset + 3]);
            this.rptChar = buffer[offset + 3];
            this.buffer = new byte[4];
        }
        System.arraycopy(buffer, offset, this.buffer, 0, this.buffer.length);
        if (this.rptChar == 0) {
            this.repeatCharacter = (char)32;
        }
    }

    @Override
    public void process(DisplayScreen screen) {
        int stopLocation = this.stopAddress.getLocation();
        Pen pen = screen.getPen();
        if (pen.getPosition() == stopLocation) {
            screen.clearScreen(((Screen)screen).getCurrentScreenOption());
        } else {
            while (pen.getPosition() != stopLocation) {
                pen.write(this.rptChar);
            }
        }
    }

    public String toString() {
        return String.format("RTA : %-12s : %02X [%1.1s]", this.stopAddress, this.rptChar, Character.valueOf(this.repeatCharacter));
    }
}

