/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.orders.EraseUnprotectedToAddressOrder;
import com.bytezone.dm3270.orders.FormatControlOrder;
import com.bytezone.dm3270.orders.GraphicsEscapeOrder;
import com.bytezone.dm3270.orders.InsertCursorOrder;
import com.bytezone.dm3270.orders.ModifyFieldOrder;
import com.bytezone.dm3270.orders.NewlineOrder;
import com.bytezone.dm3270.orders.ProgramTabOrder;
import com.bytezone.dm3270.orders.RepeatToAddressOrder;
import com.bytezone.dm3270.orders.SetAttributeOrder;
import com.bytezone.dm3270.orders.SetBufferAddressOrder;
import com.bytezone.dm3270.orders.StartFieldExtendedOrder;
import com.bytezone.dm3270.orders.StartFieldOrder;
import com.bytezone.dm3270.orders.TextOrder;

public abstract class Order {
    public static final byte PROGRAM_TAB = 5;
    public static final byte GRAPHICS_ESCAPE = 8;
    public static final byte SET_BUFFER_ADDRESS = 17;
    public static final byte ERASE_UNPROTECTED = 18;
    public static final byte INSERT_CURSOR = 19;
    public static final byte START_FIELD = 29;
    public static final byte SET_ATTRIBUTE = 40;
    public static final byte START_FIELD_EXTENDED = 41;
    public static final byte MODIFY_FIELD = 44;
    public static final byte REPEAT_TO_ADDRESS = 60;
    public static final byte FCO_NULL = 0;
    public static final byte FCO_SUBSTITUTE = 63;
    public static final byte FCO_DUPLICATE = 28;
    public static final byte FCO_FIELD_MARK = 30;
    public static final byte FCO_FORM_FEED = 12;
    public static final byte FCO_CARRIAGE_RETURN = 13;
    public static final byte FCO_NEWLINE = 21;
    public static final byte FCO_END_OF_MEDIUM = 25;
    public static final byte FCO_EIGHT_ONES = -1;
    public static byte[] orderValues = new byte[]{29, 41, 17, 19, 8, 60, 18, 5, 40, 44, 0, 63, 28, 30, 12, 13, 21, 25, -1};
    protected byte[] buffer;
    protected int duplicates;

    public static Order getOrder(byte[] buffer, int ptr, int max, Charset charset) {
        switch (buffer[ptr]) {
            case 29: {
                return new StartFieldOrder(buffer, ptr);
            }
            case 41: {
                return new StartFieldExtendedOrder(buffer, ptr);
            }
            case 17: {
                return new SetBufferAddressOrder(buffer, ptr);
            }
            case 40: {
                return new SetAttributeOrder(buffer, ptr);
            }
            case 44: {
                return new ModifyFieldOrder(buffer, ptr);
            }
            case 19: {
                return new InsertCursorOrder(buffer, ptr);
            }
            case 5: {
                return new ProgramTabOrder(buffer, ptr);
            }
            case 60: {
                return new RepeatToAddressOrder(buffer, ptr, charset);
            }
            case 18: {
                return new EraseUnprotectedToAddressOrder(buffer, ptr);
            }
            case 8: {
                return new GraphicsEscapeOrder(buffer, ptr);
            }
            case -1: 
            case 0: 
            case 12: 
            case 13: 
            case 25: 
            case 28: 
            case 30: 
            case 63: {
                return new FormatControlOrder(buffer, ptr);
            }
            case 21: {
                return new NewlineOrder(buffer, ptr);
            }
        }
        return new TextOrder(buffer, ptr, max, charset);
    }

    public void incrementDuplicates() {
        ++this.duplicates;
    }

    public byte getType() {
        return this.buffer[0];
    }

    public boolean isText() {
        return false;
    }

    public boolean matchesPreviousOrder(Order order) {
        return false;
    }

    public int size() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public abstract void process(DisplayScreen var1);
}

