/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.extended;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.buffers.MultiBuffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.AbstractExtendedCommand;
import com.bytezone.dm3270.extended.CommandHeader;
import com.bytezone.dm3270.streams.TelnetState;
import java.util.ArrayList;
import java.util.Optional;

public class TN3270ExtendedCommand
extends AbstractExtendedCommand {
    private final Command command;
    private final TelnetState telnetState;
    private final Charset charset;

    public TN3270ExtendedCommand(CommandHeader commandHeader, Command command, TelnetState telnetState, Charset charset) {
        super(commandHeader);
        this.command = command;
        this.telnetState = telnetState;
        this.charset = charset;
    }

    public Command getCommand() {
        return this.command;
    }

    @Override
    public byte[] getData() {
        byte[] combinedData = new byte[this.command.size() + 5];
        System.arraycopy(this.commandHeader.getData(), 0, combinedData, 0, this.commandHeader.size());
        System.arraycopy(this.command.getData(), 0, combinedData, this.commandHeader.size(), this.command.size());
        return combinedData;
    }

    @Override
    public int size() {
        return this.command.size() + this.commandHeader.size();
    }

    @Override
    public void process(Screen screen) {
        this.commandHeader.process(screen);
        this.command.process(screen);
    }

    @Override
    public Optional<Buffer> getReply() {
        ArrayList<TN3270ExtendedCommand> buffers = new ArrayList<TN3270ExtendedCommand>();
        Optional<Buffer> headerReply = this.commandHeader.getReply();
        headerReply.ifPresent(buffers::add);
        Optional<Buffer> reply = this.command.getReply();
        if (reply.isPresent()) {
            byte[] headerBuffer = new byte[5];
            Buffer.packUnsignedShort(this.telnetState.nextCommandHeaderSeq(), headerBuffer, 3);
            CommandHeader header = new CommandHeader(headerBuffer, this.charset);
            TN3270ExtendedCommand tN3270ExtendedCommand = new TN3270ExtendedCommand(header, (Command)reply.get(), this.telnetState, this.charset);
            buffers.add(tN3270ExtendedCommand);
        }
        if (buffers.size() == 0) {
            return Optional.empty();
        }
        if (buffers.size() == 1) {
            return Optional.of(buffers.get(0));
        }
        MultiBuffer multiBuffer = new MultiBuffer(this.charset);
        for (Buffer buffer : buffers) {
            multiBuffer.addBuffer(buffer);
        }
        return Optional.of(multiBuffer);
    }

    @Override
    public byte[] getTelnetData() {
        byte[] headerTelnetBuffer = this.commandHeader.getTelnetData();
        byte[] commandTelnetBuffer = this.command.getTelnetData();
        int length = headerTelnetBuffer.length + commandTelnetBuffer.length;
        byte[] returnBuffer = new byte[length];
        System.arraycopy(headerTelnetBuffer, 0, returnBuffer, 0, headerTelnetBuffer.length);
        System.arraycopy(commandTelnetBuffer, 0, returnBuffer, headerTelnetBuffer.length, commandTelnetBuffer.length);
        return returnBuffer;
    }

    @Override
    public String getName() {
        return this.command.getName();
    }

    public String toString() {
        return this.command.toString();
    }
}

