/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.ScreenContext;
import java.util.ArrayList;
import java.util.List;

public final class ScreenPosition {
    private final int position;
    private StartFieldAttribute startFieldAttribute;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private byte value;
    private ScreenContext screenContext;
    private final Charset charset;

    public ScreenPosition(int position, ScreenContext screenContext, Charset charset) {
        this.position = position;
        this.screenContext = screenContext;
        this.charset = charset;
        this.reset();
    }

    public void reset() {
        this.value = 0;
        this.screenContext = this.screenContext.withGraphic(false);
        this.startFieldAttribute = null;
        this.attributes.clear();
    }

    public void setChar(byte value) {
        this.value = value;
        this.screenContext = this.screenContext.withGraphic(false);
    }

    public void setAplGraphicChar(byte value) {
        this.value = value;
        this.screenContext = this.screenContext.withGraphic(true);
    }

    public StartFieldAttribute getStartFieldAttribute() {
        return this.startFieldAttribute;
    }

    public void setStartField(StartFieldAttribute startFieldAttribute) {
        if (startFieldAttribute == null && this.startFieldAttribute != null) {
            this.attributes.clear();
        }
        this.startFieldAttribute = startFieldAttribute;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public int getPosition() {
        return this.position;
    }

    public void setScreenContext(ScreenContext screenContext) {
        if (screenContext == null) {
            throw new IllegalArgumentException("ScreenContext cannot be null");
        }
        this.screenContext = screenContext;
    }

    public ScreenContext getScreenContext() {
        return this.screenContext;
    }

    public boolean isStartField() {
        return this.startFieldAttribute != null;
    }

    public boolean isGraphic() {
        return this.screenContext.isGraphic();
    }

    public char getChar() {
        if (this.value == 0) {
            return '\u0000';
        }
        if ((this.value & 0xC0) == 0) {
            return ' ';
        }
        if (this.screenContext.isGraphic()) {
            return ScreenPosition.convertGraphicChar(this.value);
        }
        return this.charset.getChar(this.value);
    }

    private static char convertGraphicChar(byte val) {
        switch (val) {
            case -123: {
                return '\u2502';
            }
            case -94: {
                return '\u2500';
            }
            case -60: {
                return '\u2514';
            }
            case -59: {
                return '\u250c';
            }
            case -58: {
                return '\u251c';
            }
            case -57: {
                return '\u2534';
            }
            case -45: {
                return '\u253c';
            }
            case -44: {
                return '\u2518';
            }
            case -43: {
                return '\u2510';
            }
            case -42: {
                return '\u2524';
            }
            case -41: {
                return '\u252c';
            }
        }
        return ' ';
    }

    public String getCharString() {
        if (this.isStartField()) {
            return " ";
        }
        if (this.screenContext.isGraphic()) {
            return String.valueOf(ScreenPosition.convertGraphicChar(this.value));
        }
        char ret = this.charset.getChar(this.value);
        return ret < ' ' ? " " : String.valueOf(ret);
    }

    public byte getByte() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == 0;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        if (this.isStartField()) {
            text.append("..").append(this.startFieldAttribute);
        } else {
            for (Attribute attribute : this.attributes) {
                text.append("--").append(attribute);
            }
        }
        text.append(", byte: ").append(this.getCharString());
        return text.toString();
    }
}

