/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.commands.AIDCommand;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.FieldManager;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.display.ScreenPosition;
import com.bytezone.dm3270.extended.SscpLuDataCommand;
import com.bytezone.dm3270.orders.BufferAddress;
import java.util.List;

public class ScreenPacker {
    private final byte[] buffer = new byte[8192];
    private Pen pen;
    private final FieldManager fieldManager;
    private final Charset charset;

    public ScreenPacker(Pen pen, FieldManager fieldManager, Charset charset) {
        this.pen = pen;
        this.fieldManager = fieldManager;
        this.charset = charset;
    }

    public Command readModifiedFields(byte currentAID, int cursorLocation, boolean readModifiedAll, boolean sscpLuData) {
        int ptr = 0;
        if (!(readModifiedAll || currentAID != 108 && currentAID != 110 && currentAID != 107 && currentAID != 109)) {
            this.buffer[ptr++] = currentAID;
            return new AIDCommand(this.buffer, 0, ptr, this.charset);
        }
        if (!sscpLuData) {
            this.buffer[ptr++] = currentAID;
            BufferAddress ba = new BufferAddress(cursorLocation);
            ptr = ba.packAddress(this.buffer, ptr);
        }
        if (!this.fieldManager.getFields().isEmpty()) {
            for (Field field : this.fieldManager.getFields()) {
                if (!field.isModified()) continue;
                ptr = this.packField(field, this.buffer, ptr);
            }
        } else {
            for (ScreenPosition sp : this.pen.fromCurrentPosition()) {
                if (sp.isNull()) continue;
                this.buffer[ptr++] = sp.getByte();
            }
        }
        return sscpLuData ? new SscpLuDataCommand(this.buffer, 0, ptr, this.charset) : new AIDCommand(this.buffer, 0, ptr, this.charset);
    }

    private int packField(Field field, byte[] buffer, int ptr) {
        assert (field.isModified());
        for (ScreenPosition sp : field) {
            if (sp.isStartField()) {
                buffer[ptr++] = 17;
                BufferAddress ba = new BufferAddress(field.getFirstLocation());
                ptr = ba.packAddress(buffer, ptr);
                continue;
            }
            if (sp.isNull()) continue;
            buffer[ptr++] = sp.getByte();
        }
        return ptr;
    }

    public AIDCommand readBuffer(byte currentAID, int cursorLocation, byte replyMode, byte[] replyTypes) {
        int ptr = 0;
        this.buffer[ptr++] = currentAID;
        BufferAddress ba = new BufferAddress(cursorLocation);
        ptr = ba.packAddress(this.buffer, ptr);
        for (ScreenPosition sp : this.pen) {
            if (sp.isStartField()) {
                ptr = this.packStartPosition(sp, this.buffer, ptr, replyMode);
                continue;
            }
            ptr = this.packDataPosition(sp, this.buffer, ptr, replyMode, replyTypes);
        }
        return new AIDCommand(this.buffer, 0, ptr, this.charset);
    }

    private int packStartPosition(ScreenPosition sp, byte[] buffer, int ptr, byte replyMode) {
        assert (sp.isStartField());
        StartFieldAttribute sfa = sp.getStartFieldAttribute();
        if (replyMode == 0) {
            buffer[ptr++] = 29;
            buffer[ptr++] = sfa.getAttributeValue();
        } else {
            buffer[ptr++] = 41;
            List<Attribute> attributes = sp.getAttributes();
            buffer[ptr++] = (byte)(attributes.size() + 1);
            ptr = sfa.pack(buffer, ptr);
            for (Attribute attribute : attributes) {
                ptr = attribute.pack(buffer, ptr);
            }
        }
        return ptr;
    }

    private int packDataPosition(ScreenPosition sp, byte[] buffer, int ptr, byte replyMode, byte[] replyTypes) {
        if (replyMode == 2) {
            block0: for (Attribute attribute : sp.getAttributes()) {
                if (attribute.getAttributeType() == Attribute.AttributeType.RESET) {
                    buffer[ptr++] = 40;
                    ptr = attribute.pack(buffer, ptr);
                    continue;
                }
                for (byte b : replyTypes) {
                    if (!attribute.matches(b)) continue;
                    buffer[ptr++] = 40;
                    ptr = attribute.pack(buffer, ptr);
                    continue block0;
                }
            }
        }
        if (sp.isGraphic() && replyMode != 0) {
            buffer[ptr++] = 8;
        }
        buffer[ptr++] = sp.getByte();
        return ptr;
    }
}

