/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.application.ConsolePane;
import com.bytezone.dm3270.application.KeyboardStatusChangedEvent;
import com.bytezone.dm3270.application.KeyboardStatusListener;
import com.bytezone.dm3270.commands.AIDCommand;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Cursor;
import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.FieldManager;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.display.ScreenPacker;
import com.bytezone.dm3270.display.ScreenPosition;
import com.bytezone.dm3270.orders.BufferAddress;
import com.bytezone.dm3270.streams.TelnetState;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Screen
implements DisplayScreen {
    private static final Logger LOG = LoggerFactory.getLogger(Screen.class);
    private static final byte[] SAVE_SCREEN_REPLY_TYPES = new byte[]{65, 66, 67, 69, 70};
    private ScreenPosition[] screenPositions;
    private final FieldManager fieldManager;
    private ScreenPacker screenPacker;
    private final TelnetState telnetState;
    private final Charset charset;
    private final ScreenDimensions defaultScreenDimensions;
    private final ScreenDimensions alternateScreenDimensions;
    private Pen pen;
    private final Cursor cursor;
    private ScreenOption currentScreen;
    private boolean alarmSounded;
    private boolean sscpLuData;
    private byte currentAID;
    private byte replyMode;
    private byte[] replyTypes = new byte[0];
    private int insertedCursorPosition = -1;
    private boolean keyboardLocked;
    private boolean insertMode;
    private boolean readModifiedAll = false;
    private final Set<KeyboardStatusListener> keyboardChangeListeners = ConcurrentHashMap.newKeySet();

    public Screen(ScreenDimensions defaultScreenDimensions, ScreenDimensions alternateScreenDimensions, TelnetState telnetState, Charset charset) {
        this.defaultScreenDimensions = defaultScreenDimensions;
        this.alternateScreenDimensions = alternateScreenDimensions;
        this.telnetState = telnetState;
        this.charset = charset;
        ScreenOption currentOption = alternateScreenDimensions == null ? ScreenOption.DEFAULT : ScreenOption.ALTERNATE;
        ScreenDimensions screenDimensions = currentOption.equals((Object)ScreenOption.DEFAULT) ? defaultScreenDimensions : alternateScreenDimensions;
        this.cursor = new Cursor(this);
        this.fieldManager = new FieldManager(this, screenDimensions);
        this.screenPositions = new ScreenPosition[screenDimensions.size];
        this.pen = Pen.getInstance(this.screenPositions, screenDimensions, charset);
        this.screenPacker = new ScreenPacker(this.pen, this.fieldManager, charset);
        this.setCurrentScreen(currentOption);
    }

    public TelnetState getTelnetState() {
        return this.telnetState;
    }

    public void setCurrentScreen(ScreenOption value) {
        if (this.currentScreen == value) {
            return;
        }
        this.currentScreen = value;
        ScreenDimensions screenDimensions = this.getScreenDimensions();
        this.pen.setScreenDimensions(screenDimensions);
        this.fieldManager.setScreenDimensions(screenDimensions);
        BufferAddress.setScreenWidth(screenDimensions.columns);
    }

    public ScreenOption getCurrentScreenOption() {
        return this.currentScreen;
    }

    @Override
    public ScreenDimensions getScreenDimensions() {
        return this.currentScreen == ScreenOption.DEFAULT ? this.defaultScreenDimensions : this.alternateScreenDimensions;
    }

    public void setConsolePane(ConsolePane consolePane) {
        this.addKeyboardStatusChangeListener(consolePane);
    }

    public FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public Cursor getScreenCursor() {
        return this.cursor;
    }

    public void resetInsertMode() {
        if (this.insertMode) {
            this.toggleInsertMode();
        }
    }

    public void toggleInsertMode() {
        this.insertMode = !this.insertMode;
        this.fireKeyboardStatusChange("");
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void setSscpLuData() {
        this.sscpLuData = true;
    }

    public boolean isSscpLuData() {
        return this.sscpLuData;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void eraseAllUnprotected() {
        Optional<Field> firstUnprotectedField = this.fieldManager.eraseAllUnprotected();
        this.restoreKeyboard();
        this.resetModified();
        this.draw();
        firstUnprotectedField.ifPresent(screenPositions1 -> this.cursor.moveTo(screenPositions1.getFirstLocation()));
    }

    public void buildFields() {
        this.fieldManager.buildFields(this.screenPositions);
    }

    public void checkRecording() {
        byte savedReplyMode = this.replyMode;
        byte[] savedReplyTypes = this.replyTypes;
        this.setReplyMode((byte)2, SAVE_SCREEN_REPLY_TYPES);
        this.setReplyMode(savedReplyMode, savedReplyTypes);
    }

    public void draw() {
        if (this.insertedCursorPosition >= 0) {
            this.cursor.moveTo(this.insertedCursorPosition);
            this.insertedCursorPosition = -1;
            this.cursor.setVisible(true);
        }
    }

    public void setAID(byte aid) {
        this.currentAID = aid;
    }

    public void setReplyMode(byte replyMode, byte[] replyTypes) {
        this.replyMode = replyMode;
        this.replyTypes = replyTypes;
    }

    public void setFieldText(Field field, String text) {
        field.setText(this.getTextBytes(text));
        field.setModified(true);
    }

    private byte[] getTextBytes(String text) {
        try {
            return text.getBytes(this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPositionText(int position, String text) {
        byte[] bytes = this.getTextBytes(text);
        for (int i = 0; i < bytes.length && position + i < this.screenPositions.length; ++i) {
            this.screenPositions[position + i].setChar(bytes[i]);
        }
    }

    @Override
    public Pen getPen() {
        return this.pen;
    }

    @Override
    public ScreenPosition getScreenPosition(int position) {
        return this.screenPositions[position];
    }

    @Override
    public int validate(int position) {
        return this.pen.validate(position);
    }

    @Override
    public void clearScreen(ScreenOption requestedScreenOption) {
        if (!requestedScreenOption.equals((Object)this.currentScreen)) {
            ScreenDimensions size = requestedScreenOption.equals((Object)ScreenOption.DEFAULT) ? this.defaultScreenDimensions : this.alternateScreenDimensions;
            this.screenPositions = new ScreenPosition[size.size];
            this.pen = Pen.getInstance(this.screenPositions, size, this.charset);
            this.screenPacker = new ScreenPacker(this.pen, this.fieldManager, this.charset);
            this.currentScreen = requestedScreenOption;
            this.sscpLuData = false;
            this.fieldManager.reset();
            return;
        }
        this.cursor.moveTo(0);
        this.pen.clearScreen();
        this.sscpLuData = false;
        this.fieldManager.reset();
    }

    @Override
    public void insertCursor(int position) {
        this.insertedCursorPosition = position;
    }

    public Command readModifiedFields() {
        return this.screenPacker.readModifiedFields(this.currentAID, this.getScreenCursor().getLocation(), this.readModifiedAll, this.sscpLuData);
    }

    public Command readModifiedFields(byte type) {
        switch (type) {
            case -10: {
                return this.readModifiedFields();
            }
            case 110: {
                this.readModifiedAll = true;
                Command command = this.readModifiedFields();
                this.readModifiedAll = false;
                return command;
            }
        }
        LOG.warn("Unknown type {}", (Object)type);
        return null;
    }

    public AIDCommand readBuffer() {
        return this.screenPacker.readBuffer(this.currentAID, this.getScreenCursor().getLocation(), this.replyMode, this.replyTypes);
    }

    public boolean isAlarmOn() {
        return this.alarmSounded;
    }

    public void soundAlarm() {
        this.alarmSounded = true;
    }

    public boolean resetAlarm() {
        boolean sounded = this.alarmSounded;
        this.alarmSounded = false;
        return sounded;
    }

    public void restoreKeyboard() {
        this.setAID((byte)96);
        this.cursor.setVisible(true);
        this.keyboardLocked = false;
        this.fireKeyboardStatusChange("");
    }

    public void lockKeyboard(String keyName) {
        this.keyboardLocked = true;
        this.fireKeyboardStatusChange(keyName);
        this.cursor.setVisible(false);
    }

    public void resetModified() {
        this.fieldManager.getUnprotectedFields().forEach(f -> f.setModified(false));
    }

    public boolean isKeyboardLocked() {
        return this.keyboardLocked;
    }

    private void fireKeyboardStatusChange(String keyName) {
        KeyboardStatusChangedEvent evt = new KeyboardStatusChangedEvent(this.insertMode, this.keyboardLocked, keyName);
        this.keyboardChangeListeners.forEach(l -> l.keyboardStatusChanged(evt));
    }

    public void addKeyboardStatusChangeListener(KeyboardStatusListener listener) {
        this.keyboardChangeListeners.add(listener);
    }

    public void removeKeyboardStatusChangeListener(KeyboardStatusListener listener) {
        this.keyboardChangeListeners.remove(listener);
    }

    public static enum ScreenOption {
        DEFAULT,
        ALTERNATE;

    }
}

