/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.display.ScreenChangeListener;
import com.bytezone.dm3270.display.ScreenContext;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.display.ScreenPosition;
import com.bytezone.dm3270.display.ScreenWatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class FieldManager {
    private final Screen screen;
    private ScreenWatcher screenWatcher;
    private ScreenDimensions screenDimensions;
    private final List<Field> fields = new CopyOnWriteArrayList<Field>();
    private final List<Field> unprotectedFields = new ArrayList<Field>();
    private final Set<ScreenChangeListener> screenChangeListeners = ConcurrentHashMap.newKeySet();

    public FieldManager(Screen screen, ScreenDimensions screenDimensions) {
        this.screen = screen;
        this.screenDimensions = screenDimensions;
        this.screenWatcher = new ScreenWatcher(this, screenDimensions);
    }

    public void setScreenDimensions(ScreenDimensions screenDimensions) {
        this.screenDimensions = this.screen.getScreenDimensions();
        this.screenWatcher = new ScreenWatcher(this, screenDimensions);
    }

    public void reset() {
        this.fields.clear();
        this.unprotectedFields.clear();
    }

    public void buildFields(ScreenPosition[] screenPositions) {
        this.reset();
        ArrayList<Field> auxFields = new ArrayList<Field>();
        for (List<ScreenPosition> list : FieldManager.divide(screenPositions)) {
            auxFields.add(new Field(this.screen, list));
            this.setContexts(list);
        }
        this.fields.addAll(auxFields);
        Field previousUnprotectedField = null;
        for (Field field : this.fields) {
            if (!field.isUnprotected()) continue;
            this.unprotectedFields.add(field);
            if (previousUnprotectedField != null) {
                previousUnprotectedField.linkToNext(field);
            }
            previousUnprotectedField = field;
        }
        if (this.unprotectedFields.size() > 0) {
            Field field = this.unprotectedFields.get(0);
            Field lastField = this.unprotectedFields.get(this.unprotectedFields.size() - 1);
            lastField.linkToNext(field);
            Field next = field;
            for (Field field2 : this.fields) {
                if (field2.isProtected()) {
                    field2.setNext(next);
                    continue;
                }
                next = field2.getNextUnprotectedField();
            }
        }
        this.configureCircularField();
        this.screenWatcher.check();
        this.fireScreenChanged(this.screenWatcher);
    }

    private void configureCircularField() {
        if (this.unprotectedFields.isEmpty()) {
            return;
        }
        Field lastField = this.unprotectedFields.get(this.unprotectedFields.size() - 1);
        if (lastField.getFirstLocation() > lastField.getEndPosition()) {
            lastField.setCircular(true);
        }
    }

    private void addField(Field field) {
        this.fields.add(field);
    }

    public Optional<Field> getFieldAt(int position) {
        return this.fields.parallelStream().filter(f -> f.contains(position)).findAny();
    }

    public List<Field> getUnprotectedFields() {
        return this.unprotectedFields;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int size() {
        return this.fields.size();
    }

    public Optional<Field> eraseAllUnprotected() {
        this.unprotectedFields.parallelStream().forEach(f -> f.clearData(true));
        return this.unprotectedFields.stream().findFirst();
    }

    public List<Field> getRowFields(int requestedRow) {
        int firstLocation = requestedRow * this.screenDimensions.columns;
        int lastLocation = firstLocation + this.screenDimensions.columns - 1;
        return this.getFieldsInRange(firstLocation, lastLocation);
    }

    public List<Field> getRowFields(int requestedRowFrom, int rows) {
        int firstLocation = requestedRowFrom * this.screenDimensions.columns;
        int lastLocation = (requestedRowFrom + rows) * this.screenDimensions.columns - 1;
        return this.getFieldsInRange(firstLocation, lastLocation);
    }

    private List<Field> getFieldsInRange(int firstLocation, int lastLocation) {
        ArrayList<Field> rowFields = new ArrayList<Field>();
        for (Field field : this.fields) {
            int location = field.getFirstLocation();
            if (location < firstLocation) continue;
            if (location > lastLocation) break;
            if (field.getDisplayLength() <= 0) continue;
            rowFields.add(field);
        }
        return rowFields;
    }

    public boolean textMatches(int fieldNo, String text) {
        return text.equals(this.fields.get(fieldNo).getText());
    }

    public boolean textMatches(int fieldNo, String text, int location) {
        Field field = this.fields.get(fieldNo);
        return field.getFirstLocation() == location && text.equals(field.getText());
    }

    public boolean textMatchesTrim(Field field, String text) {
        return text.equals(field.getText().trim());
    }

    public List<String> getMenus() {
        ArrayList<String> menus = new ArrayList<String>();
        for (Field field : this.fields) {
            String text;
            if (field.getFirstLocation() >= this.screenDimensions.columns) break;
            if (!field.isProtected() || !field.isVisible() || field.getDisplayLength() <= 1 || (text = field.getText().trim()).isEmpty()) continue;
            menus.add(text);
        }
        return menus;
    }

    private void fireScreenChanged(ScreenWatcher screenWatcher) {
        this.screenChangeListeners.forEach(listener -> listener.screenChanged(screenWatcher));
    }

    public void addScreenChangeListener(ScreenChangeListener listener) {
        this.screenChangeListeners.add(listener);
    }

    public void removeScreenChangeListener(ScreenChangeListener listener) {
        this.screenChangeListeners.remove(listener);
    }

    private static List<List<ScreenPosition>> divide(ScreenPosition[] screenPositions) {
        ArrayList<List<ScreenPosition>> components = new ArrayList<List<ScreenPosition>>();
        ArrayList<ScreenPosition> positions = new ArrayList<ScreenPosition>();
        boolean inField = false;
        int ptr = 0;
        while (ptr < screenPositions.length) {
            ScreenPosition screenPosition;
            if ((screenPosition = screenPositions[ptr++]).isStartField()) {
                if (inField) {
                    components.add(new ArrayList(positions));
                    positions.clear();
                }
                inField = true;
            }
            if (!inField) continue;
            positions.add(screenPosition);
        }
        if (inField && !positions.isEmpty()) {
            if (positions.get(0) == screenPositions[0] || !components.isEmpty() && !((ScreenPosition)((List)components.get(0)).get(0)).equals(screenPositions[0])) {
                int circularUntil = !components.isEmpty() ? ((ScreenPosition)((List)components.get(0)).get(0)).getPosition() : ((ScreenPosition)positions.get(0)).getPosition();
                ptr = 0;
                while (ptr < circularUntil) {
                    positions.add(screenPositions[ptr++]);
                }
            }
            components.add(new ArrayList(positions));
        }
        return components;
    }

    private void setContexts(List<ScreenPosition> positions) {
        StartFieldAttribute startFieldAttribute = positions.get(0).getStartFieldAttribute();
        ScreenContext defaultContext = startFieldAttribute.process(null, null);
        if (startFieldAttribute.isExtended()) {
            this.setExtendedContext(defaultContext, positions);
        } else {
            positions.forEach(sp -> sp.setScreenContext(defaultContext));
        }
    }

    private void setExtendedContext(ScreenContext defaultContext, List<ScreenPosition> positions) {
        boolean first = true;
        ScreenContext currentContext = defaultContext;
        for (ScreenPosition screenPosition : positions) {
            for (Attribute attribute : screenPosition.getAttributes()) {
                currentContext = attribute.process(defaultContext, currentContext);
            }
            if (first) {
                first = false;
                defaultContext = currentContext;
            }
            screenPosition.setScreenContext(currentContext);
        }
    }
}

