/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.display.ScreenPosition;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Field
implements Iterable<ScreenPosition> {
    private static final Logger LOG = LoggerFactory.getLogger(Field.class);
    private final Screen screen;
    private final int startPosition;
    private final int endPosition;
    private Field next;
    private final StartFieldAttribute startFieldAttribute;
    private final List<ScreenPosition> screenPositions;
    private final ScreenDimensions screenDimensions;
    private boolean isCircular;

    public Field(Screen screen, List<ScreenPosition> positions) {
        this.screen = screen;
        this.screenDimensions = screen.getScreenDimensions();
        ScreenPosition firstScreenPosition = positions.get(0);
        ScreenPosition lastScreenPosition = positions.get(positions.size() - 1);
        this.screenPositions = new ArrayList<ScreenPosition>(positions);
        this.startFieldAttribute = firstScreenPosition.getStartFieldAttribute();
        this.startPosition = firstScreenPosition.getPosition();
        this.endPosition = lastScreenPosition.getPosition();
    }

    public void linkToNext(Field nextField) {
        assert (this.isUnprotected());
        assert (nextField.isUnprotected());
        this.next = nextField;
    }

    public void setNext(Field field) {
        this.next = field;
    }

    public Field getNextUnprotectedField() {
        return this.next;
    }

    public int getDisplayLength() {
        return this.screenPositions.size() - 1;
    }

    public int getFirstLocation() {
        return this.screen.validate(this.startPosition + 1);
    }

    public int getCursorOffset() {
        int cursorLocation = this.screen.getScreenCursor().getLocation();
        if (cursorLocation >= this.startPosition) {
            return cursorLocation - this.startPosition;
        }
        return this.screenDimensions.size - this.startPosition + cursorLocation;
    }

    public boolean isHidden() {
        return this.startFieldAttribute.isHidden();
    }

    public boolean isProtected() {
        return this.startFieldAttribute.isProtected();
    }

    public boolean isUnprotected() {
        return !this.startFieldAttribute.isProtected();
    }

    public boolean isModified() {
        return this.startFieldAttribute.isModified();
    }

    public boolean isVisible() {
        return this.startFieldAttribute.isVisible();
    }

    public void setModified(boolean modified) {
        this.startFieldAttribute.setModified(modified);
    }

    public void setCircular(boolean isCircular) {
        this.isCircular = isCircular;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public boolean contains(int position) {
        if (this.startPosition <= this.endPosition) {
            return position >= this.startPosition && position <= this.endPosition;
        }
        return position >= this.startPosition || position <= this.endPosition;
    }

    public void erase() {
        for (int i = 1; i < this.screenPositions.size(); ++i) {
            this.screenPositions.get(i).setChar((byte)0);
        }
        this.setModified(true);
    }

    public void clearData(boolean alterModifiedFlag) {
        if (alterModifiedFlag) {
            this.setModified(true);
        }
        for (int i = 1; i < this.screenPositions.size(); ++i) {
            this.screenPositions.get(i).setChar((byte)0);
        }
    }

    public void push(int first, int last) {
        ScreenPosition spLast = this.screenPositions.get(last);
        while (first < last) {
            ScreenPosition sp = this.screenPositions.get(--last);
            spLast.setChar(sp.getByte());
            spLast.setScreenContext(sp.getScreenContext());
            spLast = sp;
        }
    }

    public byte getByteAt(int position) {
        return this.screenPositions.get(position).getByte();
    }

    public String getText() {
        if (this.startPosition == this.endPosition) {
            return "";
        }
        char[] buffer = new char[this.getDisplayLength()];
        int ptr = 0;
        for (ScreenPosition screenPosition : this.screenPositions) {
            if (screenPosition.isStartField()) continue;
            if (ptr < buffer.length) {
                buffer[ptr++] = screenPosition.getChar();
                continue;
            }
            LOG.warn("Too long: {}", (Object)ptr);
        }
        return new String(buffer);
    }

    public void setText(String text) {
        try {
            this.erase();
            this.setText(text.getBytes(this.screen.getCharset().name()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setText(byte[] buffer) {
        int ptr = 1;
        for (byte b : buffer) {
            if (ptr >= this.screenPositions.size()) {
                LOG.warn("Buffer overrun");
                break;
            }
            this.screenPositions.get(ptr++).setChar(b);
        }
    }

    public String toString() {
        return String.format("%04d-%04d %s [%s]", this.startPosition, this.endPosition, this.startFieldAttribute.getAcronym(), this.getText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field that = (Field)o;
        return this.startPosition == that.startPosition && this.endPosition == that.endPosition && this.startFieldAttribute.getAcronym().equals(that.startFieldAttribute.getAcronym()) && this.getText().equals(that.getText());
    }

    public int hashCode() {
        return Objects.hash(this.startPosition, this.endPosition, this.startFieldAttribute.getAcronym(), this.getText());
    }

    @Override
    public Iterator<ScreenPosition> iterator() {
        return this.screenPositions.iterator();
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

