/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.commands.ReadStructuredFieldCommand;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPartitionQuery
extends Command {
    private static final Logger LOG = LoggerFactory.getLogger(ReadPartitionQuery.class);
    private final Charset charset;
    private String typeName;

    public ReadPartitionQuery(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        this.charset = charset;
        assert (this.data[0] == 1);
        assert (this.data[1] == -1);
    }

    @Override
    public void process(Screen screen) {
        if (this.getReply().isPresent()) {
            return;
        }
        block0 : switch (this.data[2]) {
            case 2: {
                this.setReply(new ReadStructuredFieldCommand(screen.getTelnetState(), this.charset));
                this.typeName = "Read Partition (Query)";
                break;
            }
            case 3: {
                switch (this.data[3] & 0xFF) {
                    case 0: {
                        LOG.warn("QCODE list not yet supported");
                        break block0;
                    }
                    case 64: {
                        this.typeName = "Read Partition (QueryList): Equivalent + QCODE list";
                        ArrayList<QueryReplyField.ReplyType> queryList = new ArrayList<QueryReplyField.ReplyType>();
                        for (int i = 4; i < this.data.length; ++i) {
                            queryList.add(QueryReplyField.ReplyType.fromId(this.data[i]));
                        }
                        this.setReply(new ReadStructuredFieldCommand(queryList, screen.getTelnetState(), this.charset));
                        break block0;
                    }
                    case 128: {
                        this.typeName = "Read Partition (QueryList): all";
                        this.setReply(new ReadStructuredFieldCommand(screen.getTelnetState(), this.charset));
                        break block0;
                    }
                }
                LOG.warn("Unknown query type: {}", (Object)String.format("%02X", this.data[3]));
                break;
            }
            default: {
                LOG.warn("Unknown ReadStructuredField type: {}", (Object)String.format("%02X", this.data[2]));
            }
        }
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    public String toString() {
        return String.format("%s", this.typeName);
    }
}

