/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCommand
extends Command {
    private static final Logger LOG = LoggerFactory.getLogger(ReadCommand.class);
    private final String name;
    private final CommandType type;

    public ReadCommand(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        assert (buffer[offset] == 2 || buffer[offset] == -14 || buffer[offset] == 6 || buffer[offset] == -10 || buffer[offset] == 14 || buffer[offset] == 110);
        switch (this.data[0]) {
            case -14: 
            case 2: {
                this.name = "Read Buffer";
                this.type = CommandType.READ_BUFFER;
                break;
            }
            case -10: 
            case 6: {
                this.name = "Read Modified";
                this.type = CommandType.READ_MODIFIED;
                break;
            }
            case 14: 
            case 110: {
                this.name = "Read Modified All";
                this.type = CommandType.READ_MODIFIED_ALL;
                break;
            }
            default: {
                this.name = "Not found";
                this.type = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void process(Screen screen) {
        if (this.type == CommandType.READ_BUFFER) {
            this.setReply(screen.readBuffer());
        } else if (this.type == CommandType.READ_MODIFIED) {
            this.setReply(screen.readModifiedFields((byte)-10));
        } else if (this.type == CommandType.READ_MODIFIED_ALL) {
            this.setReply(screen.readModifiedFields((byte)110));
        } else {
            LOG.warn("Unknown READ command: {}", (Object)String.format("%02X", this.data[0]));
        }
    }

    public String toString() {
        return this.name;
    }

    private static enum CommandType {
        READ_BUFFER,
        READ_MODIFIED,
        READ_MODIFIED_ALL;

    }
}

