/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.AbstractTN3270Command;
import com.bytezone.dm3270.commands.AIDCommand;
import com.bytezone.dm3270.commands.EraseAllUnprotectedCommand;
import com.bytezone.dm3270.commands.ReadCommand;
import com.bytezone.dm3270.commands.ReadStructuredFieldCommand;
import com.bytezone.dm3270.commands.WriteCommand;
import com.bytezone.dm3270.commands.WriteStructuredFieldCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command
extends AbstractTN3270Command {
    public static final byte WRITE_F1 = -15;
    public static final byte ERASE_WRITE_F5 = -11;
    public static final byte ERASE_WRITE_ALTERNATE_7E = 126;
    public static final byte ERASE_ALL_UNPROTECTED_6F = 111;
    public static final byte WRITE_STRUCTURED_FIELD_F3 = -13;
    public static final byte READ_BUFFER_F2 = -14;
    public static final byte READ_MODIFIED_F6 = -10;
    public static final byte READ_MODIFIED_ALL_6E = 110;
    public static final byte WRITE_01 = 1;
    public static final byte ERASE_WRITE_05 = 5;
    public static final byte ERASE_WRITE_ALTERNATE_0D = 13;
    public static final byte ERASE_ALL_UNPROTECTED_0F = 15;
    public static final byte WRITE_STRUCTURED_FIELD_11 = 17;
    public static final byte READ_BUFFER_02 = 2;
    public static final byte READ_MODIFIED_06 = 6;
    public static final byte READ_MODIFIED_ALL_0E = 14;
    private static final Logger LOG = LoggerFactory.getLogger(Command.class);

    public Command(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public Command() {
    }

    public static Command getCommand(byte[] buffer, int offset, int length, Charset charset) {
        switch (buffer[offset]) {
            case -15: 
            case -11: 
            case 1: 
            case 5: 
            case 13: 
            case 126: {
                return new WriteCommand(buffer, offset, length, charset);
            }
            case 15: 
            case 111: {
                return new EraseAllUnprotectedCommand(buffer, offset, length);
            }
            case -14: 
            case -10: 
            case 2: 
            case 6: 
            case 14: 
            case 110: {
                return new ReadCommand(buffer, offset, length);
            }
            case -13: 
            case 17: {
                return new WriteStructuredFieldCommand(buffer, offset, length, charset);
            }
        }
        LOG.warn("Unknown 3270 Command: {}\n{}", (Object)String.format("%02X", buffer[offset]), (Object)charset.toHex(buffer, offset, length));
        return null;
    }

    public abstract String getName();

    public static Command getReply(byte[] buffer, int offset, int length, Charset charset) {
        if (buffer[offset] == -120) {
            return new ReadStructuredFieldCommand(buffer, offset, length, charset);
        }
        return new AIDCommand(buffer, offset, length, charset);
    }
}

