/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.buffers;

import com.bytezone.dm3270.buffers.Buffer;

public abstract class AbstractBuffer
implements Buffer {
    protected byte[] data;

    public AbstractBuffer() {
        this.data = new byte[0];
    }

    public AbstractBuffer(byte[] buffer, int offset, int length) {
        this.data = new byte[length];
        System.arraycopy(buffer, offset, this.data, 0, length);
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public byte[] getTelnetData() {
        int length = this.data.length + this.countFF(this.data) + 2;
        byte[] buffer = new byte[length];
        this.copyAndExpand(this.data, buffer);
        buffer[--length] = -17;
        buffer[--length] = -1;
        return buffer;
    }

    protected int countFF(byte[] buffer) {
        int count = 0;
        for (byte b : buffer) {
            if (b != -1) continue;
            ++count;
        }
        return count;
    }

    protected void copyAndExpand(byte[] source, byte[] dest) {
        int ptr = 0;
        for (byte b : source) {
            dest[ptr++] = b;
            if (b != -1) continue;
            dest[ptr++] = b;
        }
    }
}

