/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270;

import com.bytezone.dm3270.ConnectionListener;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ConnectionListenerBroadcast
implements ConnectionListener {
    private final Set<ConnectionListener> connectionListeners = ConcurrentHashMap.newKeySet();

    public void add(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public void remove(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    @Override
    public void onConnection() {
        this.notify(ConnectionListener::onConnection);
    }

    @Override
    public void onException(Exception ex) {
        this.notify(connectionListener -> connectionListener.onException(ex));
    }

    @Override
    public void onConnectionClosed() {
        this.notify(ConnectionListener::onConnectionClosed);
    }

    private void notify(Consumer<? super ConnectionListener> event) {
        this.connectionListeners.forEach(event);
    }
}

