/*
 * Decompiled with CFR 0.152.
 */
package com.tomash.androidcontacts.contactgetter.entity;

import android.graphics.Bitmap;
import android.net.Uri;
import com.tomash.androidcontacts.contactgetter.entity.Address;
import com.tomash.androidcontacts.contactgetter.entity.Email;
import com.tomash.androidcontacts.contactgetter.entity.Group;
import com.tomash.androidcontacts.contactgetter.entity.IMAddress;
import com.tomash.androidcontacts.contactgetter.entity.NameData;
import com.tomash.androidcontacts.contactgetter.entity.Organization;
import com.tomash.androidcontacts.contactgetter.entity.PhoneNumber;
import com.tomash.androidcontacts.contactgetter.entity.Relation;
import com.tomash.androidcontacts.contactgetter.entity.SpecialDate;
import java.util.ArrayList;
import java.util.List;

public abstract class ContactData {
    private int contactId;
    private String lookupKey;
    private List<Email> emailList = new ArrayList<Email>();
    private List<PhoneNumber> phoneList = new ArrayList<PhoneNumber>();
    private List<Address> addressesList = new ArrayList<Address>();
    private List<String> websitesList = new ArrayList<String>();
    private List<IMAddress> imAddressesList = new ArrayList<IMAddress>();
    private List<Relation> relationsList = new ArrayList<Relation>();
    private List<SpecialDate> specialDatesList = new ArrayList<SpecialDate>();
    private List<Group> groupList = new ArrayList<Group>();
    private String note = "";
    private String nickName = "";
    private String sipAddress = "";
    private Uri photoUri = Uri.EMPTY;
    private Organization organization = new Organization();
    private NameData nameData = new NameData();
    private String compositeName;
    private String accountName;
    private String accountType;
    private long lastModificationDate;
    private Uri updatedPhotoUri;
    private Bitmap updatedBitmap;
    private boolean isFavorite;

    public int getContactId() {
        return this.contactId;
    }

    public ContactData setContactId(int contactId) {
        this.contactId = contactId;
        return this;
    }

    public List<Email> getEmailList() {
        return this.emailList;
    }

    public ContactData setEmailList(List<Email> emailList) {
        if (emailList == null) {
            return this;
        }
        this.emailList = emailList;
        return this;
    }

    public List<PhoneNumber> getPhoneList() {
        return this.phoneList;
    }

    public ContactData setPhoneList(List<PhoneNumber> phoneList) {
        if (phoneList == null) {
            return this;
        }
        this.phoneList = phoneList;
        return this;
    }

    public Uri getPhotoUri() {
        return this.photoUri;
    }

    public ContactData setPhotoUri(Uri photoUri) {
        if (photoUri == null) {
            return this;
        }
        if (photoUri != Uri.EMPTY) {
            this.updatedPhotoUri = photoUri;
        }
        this.photoUri = photoUri;
        return this;
    }

    public Uri getUpdatedPhotoUri() {
        return this.updatedPhotoUri;
    }

    public ContactData setUpdatedPhotoUri(Uri updatedPhotoUri) {
        this.updatedPhotoUri = updatedPhotoUri;
        return this;
    }

    public Bitmap getUpdatedBitmap() {
        return this.updatedBitmap;
    }

    public ContactData setUpdatedBitmap(Bitmap updatedBitmap) {
        this.updatedBitmap = updatedBitmap;
        return this;
    }

    public List<Address> getAddressesList() {
        return this.addressesList;
    }

    public ContactData setAddressesList(List<Address> addressesList) {
        if (addressesList == null) {
            return this;
        }
        this.addressesList = addressesList;
        return this;
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public ContactData setCompositeName(String compositeName) {
        this.compositeName = compositeName;
        return this;
    }

    public List<String> getWebsitesList() {
        return this.websitesList;
    }

    public ContactData setWebsitesList(List<String> websitesList) {
        if (websitesList == null) {
            return this;
        }
        this.websitesList = websitesList;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public ContactData setNote(String note) {
        if (note == null) {
            return this;
        }
        this.note = note;
        return this;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public ContactData setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
        return this;
    }

    public List<IMAddress> getImAddressesList() {
        return this.imAddressesList;
    }

    public ContactData setImAddressesList(List<IMAddress> imAddressesList) {
        if (imAddressesList == null) {
            return this;
        }
        this.imAddressesList = imAddressesList;
        return this;
    }

    public List<Relation> getRelationsList() {
        return this.relationsList;
    }

    public ContactData setRelationsList(List<Relation> relationsList) {
        if (relationsList == null) {
            return this;
        }
        this.relationsList = relationsList;
        return this;
    }

    public List<SpecialDate> getSpecialDatesList() {
        return this.specialDatesList;
    }

    public ContactData setSpecialDatesList(List<SpecialDate> specialDatesList) {
        if (specialDatesList == null) {
            return this;
        }
        this.specialDatesList = specialDatesList;
        return this;
    }

    public String getNickName() {
        return this.nickName;
    }

    public ContactData setNickName(String nickName) {
        if (nickName == null) {
            return this;
        }
        this.nickName = nickName;
        return this;
    }

    public String getSipAddress() {
        return this.sipAddress;
    }

    public ContactData setSipAddress(String sipAddress) {
        if (sipAddress == null) {
            return this;
        }
        this.sipAddress = sipAddress;
        return this;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public ContactData setOrganization(Organization organization) {
        if (organization == null) {
            return this;
        }
        this.organization = organization;
        return this;
    }

    public NameData getNameData() {
        return this.nameData;
    }

    public ContactData setNameData(NameData nameData) {
        if (nameData == null) {
            return this;
        }
        this.nameData = nameData;
        return this;
    }

    public ContactData setFavorite(boolean favorite) {
        this.isFavorite = favorite;
        return this;
    }

    public boolean isFavorite() {
        return this.isFavorite;
    }

    public List<Group> getGroupList() {
        return this.groupList;
    }

    public ContactData setGroupList(List<Group> groupList) {
        if (groupList == null) {
            return this;
        }
        this.groupList = groupList;
        return this;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public ContactData setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public ContactData setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactData contact = (ContactData)o;
        if (this.contactId != contact.contactId) {
            return false;
        }
        if (!this.emailList.equals(contact.emailList)) {
            return false;
        }
        if (!this.phoneList.equals(contact.phoneList)) {
            return false;
        }
        if (!this.addressesList.equals(contact.addressesList)) {
            return false;
        }
        if (!this.websitesList.equals(contact.websitesList)) {
            return false;
        }
        if (!this.imAddressesList.equals(contact.imAddressesList)) {
            return false;
        }
        if (!this.relationsList.equals(contact.relationsList)) {
            return false;
        }
        if (!this.specialDatesList.equals(contact.specialDatesList)) {
            return false;
        }
        if (!this.groupList.equals(contact.groupList)) {
            return false;
        }
        if (!this.note.equals(contact.note)) {
            return false;
        }
        if (!this.nickName.equals(contact.nickName)) {
            return false;
        }
        if (!this.sipAddress.equals(contact.sipAddress)) {
            return false;
        }
        if (!this.photoUri.equals((Object)contact.photoUri)) {
            return false;
        }
        if (!this.organization.equals(contact.organization)) {
            return false;
        }
        if (!this.nameData.equals(contact.nameData)) {
            return false;
        }
        if (this.isFavorite != contact.isFavorite) {
            return false;
        }
        return this.compositeName == null ? contact.compositeName == null : this.compositeName.equals(contact.compositeName);
    }

    public String getLookupKey() {
        return this.lookupKey;
    }

    public ContactData setLookupKey(String lookupKey) {
        this.lookupKey = lookupKey;
        return this;
    }

    public int hashCode() {
        return this.contactId;
    }
}

