/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class PGLockService
extends SessionLockService {
    static final String SQL_TRY_LOCK = "SELECT pg_try_advisory_lock(?,?)";
    static final String SQL_UNLOCK = "SELECT pg_advisory_unlock(?,?)";
    static final String SQL_LOCK_INFO = "SELECT l.pid, a.client_hostname, a.backend_start, a.state FROM pg_locks l LEFT JOIN pg_stat_activity a ON a.pid = l.pid WHERE l.locktype = 'advisory' AND l.classid = ? AND l.objid = ? AND l.objsubid = 2 AND l.granted";

    @Override
    public boolean supports(Database database) {
        return database instanceof PostgresDatabase && PGLockService.isAtLeastPostgres91(database);
    }

    private static boolean isAtLeastPostgres91(Database database) {
        try {
            return database.getDatabaseMajorVersion() > 9 || database.getDatabaseMajorVersion() == 9 && database.getDatabaseMinorVersion() >= 1;
        }
        catch (DatabaseException e) {
            PGLockService.getLog(PGLockService.class).warning("Problem querying database version", (Throwable)e);
            return false;
        }
    }

    private int[] getChangeLogLockId() throws LockException {
        String defaultSchemaName = this.database.getDefaultSchemaName();
        if (defaultSchemaName == null) {
            throw new LockException("Default schema name is not set for current DB user/connection");
        }
        return new int[]{this.database.getDatabaseChangeLogLockTableName().hashCode(), defaultSchemaName.hashCode()};
    }

    private static Boolean getBooleanResult(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            Boolean bl = (Boolean)rs.getObject(1);
            return bl;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_TRY_LOCK);){
            int[] lockId = this.getChangeLogLockId();
            stmt.setInt(1, lockId[0]);
            stmt.setInt(2, lockId[1]);
            boolean bl = Boolean.TRUE.equals(PGLockService.getBooleanResult(stmt));
            return bl;
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_UNLOCK);){
            int[] lockId = this.getChangeLogLockId();
            stmt.setInt(1, lockId[0]);
            stmt.setInt(2, lockId[1]);
            Boolean unlocked = PGLockService.getBooleanResult(stmt);
            if (!Boolean.TRUE.equals(unlocked)) {
                throw new LockException("pg_advisory_unlock() returned " + unlocked);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String lockedBy(ResultSet rs) throws SQLException {
        String host = rs.getString("client_hostname");
        if (host == null) {
            return "pid#" + rs.getInt("pid");
        }
        return host + " (" + rs.getString("state") + ")";
    }
}

