/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.templatecard.ActionMenuItem;
import me.chanjar.weixin.cp.bean.templatecard.CheckboxOption;
import me.chanjar.weixin.cp.bean.templatecard.HorizontalContent;
import me.chanjar.weixin.cp.bean.templatecard.MultipleSelect;
import me.chanjar.weixin.cp.bean.templatecard.QuoteArea;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardButton;
import me.chanjar.weixin.cp.bean.templatecard.TemplateCardJump;
import me.chanjar.weixin.cp.bean.templatecard.VerticalContent;
import org.apache.commons.lang3.StringUtils;

public class WxCpGroupRobotMessage
implements Serializable {
    private static final long serialVersionUID = -4301684507150486556L;
    private String msgType;
    private String content;
    private List<String> mentionedList;
    private List<String> mentionedMobileList;
    private String base64;
    private String md5;
    private List<NewArticle> articles;
    private String mediaId;
    private Integer agentId;
    private String cardType;
    private String sourceIconUrl;
    private String sourceDesc;
    private Integer sourceDescColor;
    private String actionMenuDesc;
    private List<ActionMenuItem> actionMenuActionList;
    private String mainTitleTitle;
    private String mainTitleDesc;
    private String cardImageUrl;
    private Float cardImageAspectRatio;
    private String emphasisContentTitle;
    private String emphasisContentDesc;
    private String subTitleText;
    private List<VerticalContent> verticalContents;
    private List<HorizontalContent> horizontalContents;
    private List<TemplateCardJump> jumps;
    private Integer cardActionType;
    private String cardActionUrl;
    private String cardActionAppid;
    private String cardActionPagepath;
    private List<TemplateCardButton> buttons;
    private String checkboxQuestionKey;
    private Integer checkboxMode;
    private List<CheckboxOption> options;
    private String submitButtonText;
    private String submitButtonKey;
    private List<MultipleSelect> selects;
    private QuoteArea quoteArea;

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("msgtype", this.getMsgType());
        if (this.getAgentId() != null) {
            messageJson.addProperty("agentid", (Number)this.getAgentId());
        }
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                JsonArray uidJsonArray = new JsonArray();
                JsonArray mobileJsonArray = new JsonArray();
                text.addProperty("content", this.getContent());
                if (this.getMentionedList() != null) {
                    for (String string : this.getMentionedList()) {
                        uidJsonArray.add(string);
                    }
                }
                if (this.getMentionedMobileList() != null) {
                    for (String string : this.getMentionedMobileList()) {
                        mobileJsonArray.add(string);
                    }
                }
                text.add("mentioned_list", (JsonElement)uidJsonArray);
                text.add("mentioned_mobile_list", (JsonElement)mobileJsonArray);
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject text = new JsonObject();
                text.addProperty("base64", this.getBase64());
                text.addProperty("md5", this.getMd5());
                messageJson.add("image", (JsonElement)text);
                break;
            }
            case "news": {
                JsonObject text = new JsonObject();
                JsonArray array = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("title", article.getTitle());
                    jsonObject.addProperty("description", article.getDescription());
                    jsonObject.addProperty("url", article.getUrl());
                    jsonObject.addProperty("picurl", article.getPicUrl());
                    array.add((JsonElement)jsonObject);
                }
                text.add("articles", (JsonElement)array);
                messageJson.add("news", (JsonElement)text);
                break;
            }
            case "file": {
                JsonObject file = new JsonObject();
                file.addProperty("media_id", this.getMediaId());
                messageJson.add("file", (JsonElement)file);
                break;
            }
            case "template_card": {
                QuoteArea quoteArea;
                List<MultipleSelect> list;
                JsonObject tempObject;
                List<TemplateCardButton> list2;
                List<TemplateCardJump> jumps;
                List<HorizontalContent> horizontalContents;
                List<VerticalContent> verticalContents;
                JsonObject template = new JsonObject();
                template.addProperty("card_type", this.getCardType());
                if (StringUtils.isNotBlank((CharSequence)this.getSourceIconUrl()) || StringUtils.isNotBlank((CharSequence)this.getSourceDesc())) {
                    JsonObject source = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSourceIconUrl())) {
                        source.addProperty("icon_url", this.getSourceIconUrl());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSourceDesc())) {
                        source.addProperty("desc", this.getSourceDesc());
                    }
                    source.addProperty("desc_color", (Number)this.getSourceDescColor());
                    template.add("source", (JsonElement)source);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getActionMenuDesc())) {
                    JsonObject action_menu = new JsonObject();
                    action_menu.addProperty("desc", this.getActionMenuDesc());
                    JsonArray actionList = new JsonArray();
                    List<ActionMenuItem> actionMenuItemList = this.getActionMenuActionList();
                    Iterator<ActionMenuItem> iterator = actionMenuItemList.iterator();
                    while (iterator.hasNext()) {
                        ActionMenuItem actionMenuItem = iterator.next();
                        actionList.add((JsonElement)actionMenuItem.toJson());
                    }
                    action_menu.add("action_list", (JsonElement)actionList);
                    template.add("action_menu", (JsonElement)action_menu);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getMainTitleTitle()) || StringUtils.isNotBlank((CharSequence)this.getMainTitleDesc())) {
                    JsonObject mainTitle = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getMainTitleTitle())) {
                        mainTitle.addProperty("title", this.getMainTitleTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getMainTitleDesc())) {
                        mainTitle.addProperty("desc", this.getMainTitleDesc());
                    }
                    template.add("main_title", (JsonElement)mainTitle);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getCardImageUrl()) || this.getCardImageAspectRatio() != null) {
                    JsonObject cardImage = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getCardImageUrl())) {
                        cardImage.addProperty("url", this.getCardImageUrl());
                    }
                    if (null != this.getCardImageAspectRatio()) {
                        cardImage.addProperty("aspect_ratio", (Number)this.getCardImageAspectRatio());
                    }
                    template.add("card_image", (JsonElement)cardImage);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentTitle()) || StringUtils.isNotBlank((CharSequence)this.getEmphasisContentDesc())) {
                    JsonObject emphasisContent = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentTitle())) {
                        emphasisContent.addProperty("title", this.getEmphasisContentTitle());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getEmphasisContentDesc())) {
                        emphasisContent.addProperty("desc", this.getEmphasisContentDesc());
                    }
                    template.add("emphasis_content", (JsonElement)emphasisContent);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSubTitleText())) {
                    template.addProperty("sub_title_text", this.getSubTitleText());
                }
                if (null != (verticalContents = this.getVerticalContents()) && !verticalContents.isEmpty()) {
                    JsonArray vContentJsonArray = new JsonArray();
                    for (VerticalContent verticalContent : this.getVerticalContents()) {
                        JsonObject jsonObject = verticalContent.toJson();
                        vContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("vertical_content_list", (JsonElement)vContentJsonArray);
                }
                if (null != (horizontalContents = this.getHorizontalContents()) && !horizontalContents.isEmpty()) {
                    JsonArray hContentJsonArray = new JsonArray();
                    for (HorizontalContent horizontalContent : this.getHorizontalContents()) {
                        JsonObject jsonObject = horizontalContent.toJson();
                        hContentJsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("horizontal_content_list", (JsonElement)hContentJsonArray);
                }
                if (null != (jumps = this.getJumps()) && !jumps.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardJump templateCardJump : this.getJumps()) {
                        JsonObject jsonObject = templateCardJump.toJson();
                        jsonArray.add((JsonElement)jsonObject);
                    }
                    template.add("jump_list", (JsonElement)jsonArray);
                }
                if (null != this.getCardActionType()) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("type", (Number)this.getCardActionType());
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionUrl())) {
                        jsonObject.addProperty("url", this.getCardActionUrl());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionAppid())) {
                        jsonObject.addProperty("appid", this.getCardActionAppid());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getCardActionPagepath())) {
                        jsonObject.addProperty("pagepath", this.getCardActionPagepath());
                    }
                    template.add("card_action", (JsonElement)jsonObject);
                }
                if (null != (list2 = this.getButtons()) && !list2.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (TemplateCardButton templateCardButton : this.getButtons()) {
                        JsonObject tempObject5 = templateCardButton.toJson();
                        jsonArray.add((JsonElement)tempObject5);
                    }
                    template.add("button_list", (JsonElement)jsonArray);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getCheckboxQuestionKey())) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("question_key", this.getCheckboxQuestionKey());
                    if (null != this.getCheckboxMode()) {
                        jsonObject.addProperty("mode", (Number)this.getCheckboxMode());
                    }
                    JsonArray jsonArray = new JsonArray();
                    for (CheckboxOption option : this.getOptions()) {
                        tempObject = option.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    jsonObject.add("option_list", (JsonElement)jsonArray);
                    template.add("checkbox", (JsonElement)jsonObject);
                }
                if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonText()) || StringUtils.isNotBlank((CharSequence)this.getSubmitButtonKey())) {
                    JsonObject jsonObject = new JsonObject();
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonText())) {
                        jsonObject.addProperty("text", this.getSubmitButtonText());
                    }
                    if (StringUtils.isNotBlank((CharSequence)this.getSubmitButtonKey())) {
                        jsonObject.addProperty("key", this.getSubmitButtonKey());
                    }
                    template.add("submit_button", (JsonElement)jsonObject);
                }
                if (null != (list = this.getSelects()) && !list.isEmpty()) {
                    JsonArray jsonArray = new JsonArray();
                    for (MultipleSelect select : this.getSelects()) {
                        tempObject = select.toJson();
                        jsonArray.add((JsonElement)tempObject);
                    }
                    template.add("select_list", (JsonElement)jsonArray);
                }
                if (null != (quoteArea = this.getQuoteArea())) {
                    JsonObject jsonObject = quoteArea.toJson();
                    template.add("quote_area", (JsonElement)jsonObject);
                }
                messageJson.add("template_card", (JsonElement)template);
                break;
            }
        }
        return messageJson.toString();
    }

    public WxCpGroupRobotMessage(String msgType, String content, List<String> mentionedList, List<String> mentionedMobileList, String base64, String md5, List<NewArticle> articles, String mediaId, Integer agentId, String cardType, String sourceIconUrl, String sourceDesc, Integer sourceDescColor, String actionMenuDesc, List<ActionMenuItem> actionMenuActionList, String mainTitleTitle, String mainTitleDesc, String cardImageUrl, Float cardImageAspectRatio, String emphasisContentTitle, String emphasisContentDesc, String subTitleText, List<VerticalContent> verticalContents, List<HorizontalContent> horizontalContents, List<TemplateCardJump> jumps, Integer cardActionType, String cardActionUrl, String cardActionAppid, String cardActionPagepath, List<TemplateCardButton> buttons, String checkboxQuestionKey, Integer checkboxMode, List<CheckboxOption> options, String submitButtonText, String submitButtonKey, List<MultipleSelect> selects, QuoteArea quoteArea) {
        this.msgType = msgType;
        this.content = content;
        this.mentionedList = mentionedList;
        this.mentionedMobileList = mentionedMobileList;
        this.base64 = base64;
        this.md5 = md5;
        this.articles = articles;
        this.mediaId = mediaId;
        this.agentId = agentId;
        this.cardType = cardType;
        this.sourceIconUrl = sourceIconUrl;
        this.sourceDesc = sourceDesc;
        this.sourceDescColor = sourceDescColor;
        this.actionMenuDesc = actionMenuDesc;
        this.actionMenuActionList = actionMenuActionList;
        this.mainTitleTitle = mainTitleTitle;
        this.mainTitleDesc = mainTitleDesc;
        this.cardImageUrl = cardImageUrl;
        this.cardImageAspectRatio = cardImageAspectRatio;
        this.emphasisContentTitle = emphasisContentTitle;
        this.emphasisContentDesc = emphasisContentDesc;
        this.subTitleText = subTitleText;
        this.verticalContents = verticalContents;
        this.horizontalContents = horizontalContents;
        this.jumps = jumps;
        this.cardActionType = cardActionType;
        this.cardActionUrl = cardActionUrl;
        this.cardActionAppid = cardActionAppid;
        this.cardActionPagepath = cardActionPagepath;
        this.buttons = buttons;
        this.checkboxQuestionKey = checkboxQuestionKey;
        this.checkboxMode = checkboxMode;
        this.options = options;
        this.submitButtonText = submitButtonText;
        this.submitButtonKey = submitButtonKey;
        this.selects = selects;
        this.quoteArea = quoteArea;
    }

    public WxCpGroupRobotMessage() {
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getMentionedList() {
        return this.mentionedList;
    }

    public List<String> getMentionedMobileList() {
        return this.mentionedMobileList;
    }

    public String getBase64() {
        return this.base64;
    }

    public String getMd5() {
        return this.md5;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getSourceIconUrl() {
        return this.sourceIconUrl;
    }

    public String getSourceDesc() {
        return this.sourceDesc;
    }

    public Integer getSourceDescColor() {
        return this.sourceDescColor;
    }

    public String getActionMenuDesc() {
        return this.actionMenuDesc;
    }

    public List<ActionMenuItem> getActionMenuActionList() {
        return this.actionMenuActionList;
    }

    public String getMainTitleTitle() {
        return this.mainTitleTitle;
    }

    public String getMainTitleDesc() {
        return this.mainTitleDesc;
    }

    public String getCardImageUrl() {
        return this.cardImageUrl;
    }

    public Float getCardImageAspectRatio() {
        return this.cardImageAspectRatio;
    }

    public String getEmphasisContentTitle() {
        return this.emphasisContentTitle;
    }

    public String getEmphasisContentDesc() {
        return this.emphasisContentDesc;
    }

    public String getSubTitleText() {
        return this.subTitleText;
    }

    public List<VerticalContent> getVerticalContents() {
        return this.verticalContents;
    }

    public List<HorizontalContent> getHorizontalContents() {
        return this.horizontalContents;
    }

    public List<TemplateCardJump> getJumps() {
        return this.jumps;
    }

    public Integer getCardActionType() {
        return this.cardActionType;
    }

    public String getCardActionUrl() {
        return this.cardActionUrl;
    }

    public String getCardActionAppid() {
        return this.cardActionAppid;
    }

    public String getCardActionPagepath() {
        return this.cardActionPagepath;
    }

    public List<TemplateCardButton> getButtons() {
        return this.buttons;
    }

    public String getCheckboxQuestionKey() {
        return this.checkboxQuestionKey;
    }

    public Integer getCheckboxMode() {
        return this.checkboxMode;
    }

    public List<CheckboxOption> getOptions() {
        return this.options;
    }

    public String getSubmitButtonText() {
        return this.submitButtonText;
    }

    public String getSubmitButtonKey() {
        return this.submitButtonKey;
    }

    public List<MultipleSelect> getSelects() {
        return this.selects;
    }

    public QuoteArea getQuoteArea() {
        return this.quoteArea;
    }

    public WxCpGroupRobotMessage setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxCpGroupRobotMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public WxCpGroupRobotMessage setMentionedList(List<String> mentionedList) {
        this.mentionedList = mentionedList;
        return this;
    }

    public WxCpGroupRobotMessage setMentionedMobileList(List<String> mentionedMobileList) {
        this.mentionedMobileList = mentionedMobileList;
        return this;
    }

    public WxCpGroupRobotMessage setBase64(String base64) {
        this.base64 = base64;
        return this;
    }

    public WxCpGroupRobotMessage setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public WxCpGroupRobotMessage setArticles(List<NewArticle> articles) {
        this.articles = articles;
        return this;
    }

    public WxCpGroupRobotMessage setMediaId(String mediaId) {
        this.mediaId = mediaId;
        return this;
    }

    public WxCpGroupRobotMessage setAgentId(Integer agentId) {
        this.agentId = agentId;
        return this;
    }

    public WxCpGroupRobotMessage setCardType(String cardType) {
        this.cardType = cardType;
        return this;
    }

    public WxCpGroupRobotMessage setSourceIconUrl(String sourceIconUrl) {
        this.sourceIconUrl = sourceIconUrl;
        return this;
    }

    public WxCpGroupRobotMessage setSourceDesc(String sourceDesc) {
        this.sourceDesc = sourceDesc;
        return this;
    }

    public WxCpGroupRobotMessage setSourceDescColor(Integer sourceDescColor) {
        this.sourceDescColor = sourceDescColor;
        return this;
    }

    public WxCpGroupRobotMessage setActionMenuDesc(String actionMenuDesc) {
        this.actionMenuDesc = actionMenuDesc;
        return this;
    }

    public WxCpGroupRobotMessage setActionMenuActionList(List<ActionMenuItem> actionMenuActionList) {
        this.actionMenuActionList = actionMenuActionList;
        return this;
    }

    public WxCpGroupRobotMessage setMainTitleTitle(String mainTitleTitle) {
        this.mainTitleTitle = mainTitleTitle;
        return this;
    }

    public WxCpGroupRobotMessage setMainTitleDesc(String mainTitleDesc) {
        this.mainTitleDesc = mainTitleDesc;
        return this;
    }

    public WxCpGroupRobotMessage setCardImageUrl(String cardImageUrl) {
        this.cardImageUrl = cardImageUrl;
        return this;
    }

    public WxCpGroupRobotMessage setCardImageAspectRatio(Float cardImageAspectRatio) {
        this.cardImageAspectRatio = cardImageAspectRatio;
        return this;
    }

    public WxCpGroupRobotMessage setEmphasisContentTitle(String emphasisContentTitle) {
        this.emphasisContentTitle = emphasisContentTitle;
        return this;
    }

    public WxCpGroupRobotMessage setEmphasisContentDesc(String emphasisContentDesc) {
        this.emphasisContentDesc = emphasisContentDesc;
        return this;
    }

    public WxCpGroupRobotMessage setSubTitleText(String subTitleText) {
        this.subTitleText = subTitleText;
        return this;
    }

    public WxCpGroupRobotMessage setVerticalContents(List<VerticalContent> verticalContents) {
        this.verticalContents = verticalContents;
        return this;
    }

    public WxCpGroupRobotMessage setHorizontalContents(List<HorizontalContent> horizontalContents) {
        this.horizontalContents = horizontalContents;
        return this;
    }

    public WxCpGroupRobotMessage setJumps(List<TemplateCardJump> jumps) {
        this.jumps = jumps;
        return this;
    }

    public WxCpGroupRobotMessage setCardActionType(Integer cardActionType) {
        this.cardActionType = cardActionType;
        return this;
    }

    public WxCpGroupRobotMessage setCardActionUrl(String cardActionUrl) {
        this.cardActionUrl = cardActionUrl;
        return this;
    }

    public WxCpGroupRobotMessage setCardActionAppid(String cardActionAppid) {
        this.cardActionAppid = cardActionAppid;
        return this;
    }

    public WxCpGroupRobotMessage setCardActionPagepath(String cardActionPagepath) {
        this.cardActionPagepath = cardActionPagepath;
        return this;
    }

    public WxCpGroupRobotMessage setButtons(List<TemplateCardButton> buttons) {
        this.buttons = buttons;
        return this;
    }

    public WxCpGroupRobotMessage setCheckboxQuestionKey(String checkboxQuestionKey) {
        this.checkboxQuestionKey = checkboxQuestionKey;
        return this;
    }

    public WxCpGroupRobotMessage setCheckboxMode(Integer checkboxMode) {
        this.checkboxMode = checkboxMode;
        return this;
    }

    public WxCpGroupRobotMessage setOptions(List<CheckboxOption> options) {
        this.options = options;
        return this;
    }

    public WxCpGroupRobotMessage setSubmitButtonText(String submitButtonText) {
        this.submitButtonText = submitButtonText;
        return this;
    }

    public WxCpGroupRobotMessage setSubmitButtonKey(String submitButtonKey) {
        this.submitButtonKey = submitButtonKey;
        return this;
    }

    public WxCpGroupRobotMessage setSelects(List<MultipleSelect> selects) {
        this.selects = selects;
        return this;
    }

    public WxCpGroupRobotMessage setQuoteArea(QuoteArea quoteArea) {
        this.quoteArea = quoteArea;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpGroupRobotMessage)) {
            return false;
        }
        WxCpGroupRobotMessage other = (WxCpGroupRobotMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        Integer this$sourceDescColor = this.getSourceDescColor();
        Integer other$sourceDescColor = other.getSourceDescColor();
        if (this$sourceDescColor == null ? other$sourceDescColor != null : !((Object)this$sourceDescColor).equals(other$sourceDescColor)) {
            return false;
        }
        Float this$cardImageAspectRatio = this.getCardImageAspectRatio();
        Float other$cardImageAspectRatio = other.getCardImageAspectRatio();
        if (this$cardImageAspectRatio == null ? other$cardImageAspectRatio != null : !((Object)this$cardImageAspectRatio).equals(other$cardImageAspectRatio)) {
            return false;
        }
        Integer this$cardActionType = this.getCardActionType();
        Integer other$cardActionType = other.getCardActionType();
        if (this$cardActionType == null ? other$cardActionType != null : !((Object)this$cardActionType).equals(other$cardActionType)) {
            return false;
        }
        Integer this$checkboxMode = this.getCheckboxMode();
        Integer other$checkboxMode = other.getCheckboxMode();
        if (this$checkboxMode == null ? other$checkboxMode != null : !((Object)this$checkboxMode).equals(other$checkboxMode)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$mentionedList = this.getMentionedList();
        List<String> other$mentionedList = other.getMentionedList();
        if (this$mentionedList == null ? other$mentionedList != null : !((Object)this$mentionedList).equals(other$mentionedList)) {
            return false;
        }
        List<String> this$mentionedMobileList = this.getMentionedMobileList();
        List<String> other$mentionedMobileList = other.getMentionedMobileList();
        if (this$mentionedMobileList == null ? other$mentionedMobileList != null : !((Object)this$mentionedMobileList).equals(other$mentionedMobileList)) {
            return false;
        }
        String this$base64 = this.getBase64();
        String other$base64 = other.getBase64();
        if (this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        if (this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$cardType = this.getCardType();
        String other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !this$cardType.equals(other$cardType)) {
            return false;
        }
        String this$sourceIconUrl = this.getSourceIconUrl();
        String other$sourceIconUrl = other.getSourceIconUrl();
        if (this$sourceIconUrl == null ? other$sourceIconUrl != null : !this$sourceIconUrl.equals(other$sourceIconUrl)) {
            return false;
        }
        String this$sourceDesc = this.getSourceDesc();
        String other$sourceDesc = other.getSourceDesc();
        if (this$sourceDesc == null ? other$sourceDesc != null : !this$sourceDesc.equals(other$sourceDesc)) {
            return false;
        }
        String this$actionMenuDesc = this.getActionMenuDesc();
        String other$actionMenuDesc = other.getActionMenuDesc();
        if (this$actionMenuDesc == null ? other$actionMenuDesc != null : !this$actionMenuDesc.equals(other$actionMenuDesc)) {
            return false;
        }
        List<ActionMenuItem> this$actionMenuActionList = this.getActionMenuActionList();
        List<ActionMenuItem> other$actionMenuActionList = other.getActionMenuActionList();
        if (this$actionMenuActionList == null ? other$actionMenuActionList != null : !((Object)this$actionMenuActionList).equals(other$actionMenuActionList)) {
            return false;
        }
        String this$mainTitleTitle = this.getMainTitleTitle();
        String other$mainTitleTitle = other.getMainTitleTitle();
        if (this$mainTitleTitle == null ? other$mainTitleTitle != null : !this$mainTitleTitle.equals(other$mainTitleTitle)) {
            return false;
        }
        String this$mainTitleDesc = this.getMainTitleDesc();
        String other$mainTitleDesc = other.getMainTitleDesc();
        if (this$mainTitleDesc == null ? other$mainTitleDesc != null : !this$mainTitleDesc.equals(other$mainTitleDesc)) {
            return false;
        }
        String this$cardImageUrl = this.getCardImageUrl();
        String other$cardImageUrl = other.getCardImageUrl();
        if (this$cardImageUrl == null ? other$cardImageUrl != null : !this$cardImageUrl.equals(other$cardImageUrl)) {
            return false;
        }
        String this$emphasisContentTitle = this.getEmphasisContentTitle();
        String other$emphasisContentTitle = other.getEmphasisContentTitle();
        if (this$emphasisContentTitle == null ? other$emphasisContentTitle != null : !this$emphasisContentTitle.equals(other$emphasisContentTitle)) {
            return false;
        }
        String this$emphasisContentDesc = this.getEmphasisContentDesc();
        String other$emphasisContentDesc = other.getEmphasisContentDesc();
        if (this$emphasisContentDesc == null ? other$emphasisContentDesc != null : !this$emphasisContentDesc.equals(other$emphasisContentDesc)) {
            return false;
        }
        String this$subTitleText = this.getSubTitleText();
        String other$subTitleText = other.getSubTitleText();
        if (this$subTitleText == null ? other$subTitleText != null : !this$subTitleText.equals(other$subTitleText)) {
            return false;
        }
        List<VerticalContent> this$verticalContents = this.getVerticalContents();
        List<VerticalContent> other$verticalContents = other.getVerticalContents();
        if (this$verticalContents == null ? other$verticalContents != null : !((Object)this$verticalContents).equals(other$verticalContents)) {
            return false;
        }
        List<HorizontalContent> this$horizontalContents = this.getHorizontalContents();
        List<HorizontalContent> other$horizontalContents = other.getHorizontalContents();
        if (this$horizontalContents == null ? other$horizontalContents != null : !((Object)this$horizontalContents).equals(other$horizontalContents)) {
            return false;
        }
        List<TemplateCardJump> this$jumps = this.getJumps();
        List<TemplateCardJump> other$jumps = other.getJumps();
        if (this$jumps == null ? other$jumps != null : !((Object)this$jumps).equals(other$jumps)) {
            return false;
        }
        String this$cardActionUrl = this.getCardActionUrl();
        String other$cardActionUrl = other.getCardActionUrl();
        if (this$cardActionUrl == null ? other$cardActionUrl != null : !this$cardActionUrl.equals(other$cardActionUrl)) {
            return false;
        }
        String this$cardActionAppid = this.getCardActionAppid();
        String other$cardActionAppid = other.getCardActionAppid();
        if (this$cardActionAppid == null ? other$cardActionAppid != null : !this$cardActionAppid.equals(other$cardActionAppid)) {
            return false;
        }
        String this$cardActionPagepath = this.getCardActionPagepath();
        String other$cardActionPagepath = other.getCardActionPagepath();
        if (this$cardActionPagepath == null ? other$cardActionPagepath != null : !this$cardActionPagepath.equals(other$cardActionPagepath)) {
            return false;
        }
        List<TemplateCardButton> this$buttons = this.getButtons();
        List<TemplateCardButton> other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        String this$checkboxQuestionKey = this.getCheckboxQuestionKey();
        String other$checkboxQuestionKey = other.getCheckboxQuestionKey();
        if (this$checkboxQuestionKey == null ? other$checkboxQuestionKey != null : !this$checkboxQuestionKey.equals(other$checkboxQuestionKey)) {
            return false;
        }
        List<CheckboxOption> this$options = this.getOptions();
        List<CheckboxOption> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$submitButtonText = this.getSubmitButtonText();
        String other$submitButtonText = other.getSubmitButtonText();
        if (this$submitButtonText == null ? other$submitButtonText != null : !this$submitButtonText.equals(other$submitButtonText)) {
            return false;
        }
        String this$submitButtonKey = this.getSubmitButtonKey();
        String other$submitButtonKey = other.getSubmitButtonKey();
        if (this$submitButtonKey == null ? other$submitButtonKey != null : !this$submitButtonKey.equals(other$submitButtonKey)) {
            return false;
        }
        List<MultipleSelect> this$selects = this.getSelects();
        List<MultipleSelect> other$selects = other.getSelects();
        if (this$selects == null ? other$selects != null : !((Object)this$selects).equals(other$selects)) {
            return false;
        }
        QuoteArea this$quoteArea = this.getQuoteArea();
        QuoteArea other$quoteArea = other.getQuoteArea();
        return !(this$quoteArea == null ? other$quoteArea != null : !((Object)this$quoteArea).equals(other$quoteArea));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpGroupRobotMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        Integer $sourceDescColor = this.getSourceDescColor();
        result = result * 59 + ($sourceDescColor == null ? 43 : ((Object)$sourceDescColor).hashCode());
        Float $cardImageAspectRatio = this.getCardImageAspectRatio();
        result = result * 59 + ($cardImageAspectRatio == null ? 43 : ((Object)$cardImageAspectRatio).hashCode());
        Integer $cardActionType = this.getCardActionType();
        result = result * 59 + ($cardActionType == null ? 43 : ((Object)$cardActionType).hashCode());
        Integer $checkboxMode = this.getCheckboxMode();
        result = result * 59 + ($checkboxMode == null ? 43 : ((Object)$checkboxMode).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $mentionedList = this.getMentionedList();
        result = result * 59 + ($mentionedList == null ? 43 : ((Object)$mentionedList).hashCode());
        List<String> $mentionedMobileList = this.getMentionedMobileList();
        result = result * 59 + ($mentionedMobileList == null ? 43 : ((Object)$mentionedMobileList).hashCode());
        String $base64 = this.getBase64();
        result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : $cardType.hashCode());
        String $sourceIconUrl = this.getSourceIconUrl();
        result = result * 59 + ($sourceIconUrl == null ? 43 : $sourceIconUrl.hashCode());
        String $sourceDesc = this.getSourceDesc();
        result = result * 59 + ($sourceDesc == null ? 43 : $sourceDesc.hashCode());
        String $actionMenuDesc = this.getActionMenuDesc();
        result = result * 59 + ($actionMenuDesc == null ? 43 : $actionMenuDesc.hashCode());
        List<ActionMenuItem> $actionMenuActionList = this.getActionMenuActionList();
        result = result * 59 + ($actionMenuActionList == null ? 43 : ((Object)$actionMenuActionList).hashCode());
        String $mainTitleTitle = this.getMainTitleTitle();
        result = result * 59 + ($mainTitleTitle == null ? 43 : $mainTitleTitle.hashCode());
        String $mainTitleDesc = this.getMainTitleDesc();
        result = result * 59 + ($mainTitleDesc == null ? 43 : $mainTitleDesc.hashCode());
        String $cardImageUrl = this.getCardImageUrl();
        result = result * 59 + ($cardImageUrl == null ? 43 : $cardImageUrl.hashCode());
        String $emphasisContentTitle = this.getEmphasisContentTitle();
        result = result * 59 + ($emphasisContentTitle == null ? 43 : $emphasisContentTitle.hashCode());
        String $emphasisContentDesc = this.getEmphasisContentDesc();
        result = result * 59 + ($emphasisContentDesc == null ? 43 : $emphasisContentDesc.hashCode());
        String $subTitleText = this.getSubTitleText();
        result = result * 59 + ($subTitleText == null ? 43 : $subTitleText.hashCode());
        List<VerticalContent> $verticalContents = this.getVerticalContents();
        result = result * 59 + ($verticalContents == null ? 43 : ((Object)$verticalContents).hashCode());
        List<HorizontalContent> $horizontalContents = this.getHorizontalContents();
        result = result * 59 + ($horizontalContents == null ? 43 : ((Object)$horizontalContents).hashCode());
        List<TemplateCardJump> $jumps = this.getJumps();
        result = result * 59 + ($jumps == null ? 43 : ((Object)$jumps).hashCode());
        String $cardActionUrl = this.getCardActionUrl();
        result = result * 59 + ($cardActionUrl == null ? 43 : $cardActionUrl.hashCode());
        String $cardActionAppid = this.getCardActionAppid();
        result = result * 59 + ($cardActionAppid == null ? 43 : $cardActionAppid.hashCode());
        String $cardActionPagepath = this.getCardActionPagepath();
        result = result * 59 + ($cardActionPagepath == null ? 43 : $cardActionPagepath.hashCode());
        List<TemplateCardButton> $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        String $checkboxQuestionKey = this.getCheckboxQuestionKey();
        result = result * 59 + ($checkboxQuestionKey == null ? 43 : $checkboxQuestionKey.hashCode());
        List<CheckboxOption> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $submitButtonText = this.getSubmitButtonText();
        result = result * 59 + ($submitButtonText == null ? 43 : $submitButtonText.hashCode());
        String $submitButtonKey = this.getSubmitButtonKey();
        result = result * 59 + ($submitButtonKey == null ? 43 : $submitButtonKey.hashCode());
        List<MultipleSelect> $selects = this.getSelects();
        result = result * 59 + ($selects == null ? 43 : ((Object)$selects).hashCode());
        QuoteArea $quoteArea = this.getQuoteArea();
        result = result * 59 + ($quoteArea == null ? 43 : ((Object)$quoteArea).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpGroupRobotMessage(msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mentionedList=" + this.getMentionedList() + ", mentionedMobileList=" + this.getMentionedMobileList() + ", base64=" + this.getBase64() + ", md5=" + this.getMd5() + ", articles=" + this.getArticles() + ", mediaId=" + this.getMediaId() + ", agentId=" + this.getAgentId() + ", cardType=" + this.getCardType() + ", sourceIconUrl=" + this.getSourceIconUrl() + ", sourceDesc=" + this.getSourceDesc() + ", sourceDescColor=" + this.getSourceDescColor() + ", actionMenuDesc=" + this.getActionMenuDesc() + ", actionMenuActionList=" + this.getActionMenuActionList() + ", mainTitleTitle=" + this.getMainTitleTitle() + ", mainTitleDesc=" + this.getMainTitleDesc() + ", cardImageUrl=" + this.getCardImageUrl() + ", cardImageAspectRatio=" + this.getCardImageAspectRatio() + ", emphasisContentTitle=" + this.getEmphasisContentTitle() + ", emphasisContentDesc=" + this.getEmphasisContentDesc() + ", subTitleText=" + this.getSubTitleText() + ", verticalContents=" + this.getVerticalContents() + ", horizontalContents=" + this.getHorizontalContents() + ", jumps=" + this.getJumps() + ", cardActionType=" + this.getCardActionType() + ", cardActionUrl=" + this.getCardActionUrl() + ", cardActionAppid=" + this.getCardActionAppid() + ", cardActionPagepath=" + this.getCardActionPagepath() + ", buttons=" + this.getButtons() + ", checkboxQuestionKey=" + this.getCheckboxQuestionKey() + ", checkboxMode=" + this.getCheckboxMode() + ", options=" + this.getOptions() + ", submitButtonText=" + this.getSubmitButtonText() + ", submitButtonKey=" + this.getSubmitButtonKey() + ", selects=" + this.getSelects() + ", quoteArea=" + this.getQuoteArea() + ")";
    }
}

