/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates;

import com.github.benmanes.gradle.versions.updates.Coordinate;
import com.github.benmanes.gradle.versions.updates.DependencyStatus;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.DefaultVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000fR\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u001dj\b\u0012\u0004\u0012\u00020\u001e`\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/benmanes/gradle/versions/updates/VersionMapping;", "", "project", "Lorg/gradle/api/Project;", "statuses", "", "Lcom/github/benmanes/gradle/versions/updates/DependencyStatus;", "<init>", "(Lorg/gradle/api/Project;Ljava/util/Set;)V", "getProject", "()Lorg/gradle/api/Project;", "downgrade", "Ljava/util/TreeSet;", "Lcom/github/benmanes/gradle/versions/updates/Coordinate;", "getDowngrade", "()Ljava/util/TreeSet;", "upToDate", "getUpToDate", "upgrade", "getUpgrade", "undeclared", "getUndeclared", "unresolved", "getUnresolved", "current", "getCurrent", "latest", "getLatest", "comparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "organize", "", "Companion", "gradle-versions-plugin"})
@SourceDebugExtension(value={"SMAP\nVersionMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionMapping.kt\ncom/github/benmanes/gradle/versions/updates/VersionMapping\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1208#2,2:68\n1238#2,4:70\n*S KotlinDebug\n*F\n+ 1 VersionMapping.kt\ncom/github/benmanes/gradle/versions/updates/VersionMapping\n*L\n34#1:68,2\n34#1:70,4\n*E\n"})
public final class VersionMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TreeSet<Coordinate> downgrade;
    @NotNull
    private final TreeSet<Coordinate> upToDate;
    @NotNull
    private final TreeSet<Coordinate> upgrade;
    @NotNull
    private final TreeSet<Coordinate> undeclared;
    @NotNull
    private final TreeSet<Coordinate> unresolved;
    @NotNull
    private final TreeSet<Coordinate> current;
    @NotNull
    private final TreeSet<Coordinate> latest;
    @NotNull
    private Comparator<String> comparator;

    public VersionMapping(@NotNull Project project, @NotNull Set<DependencyStatus> statuses) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        this.project = project;
        this.downgrade = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.upToDate = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.upgrade = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.undeclared = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.unresolved = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.current = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.latest = SetsKt.sortedSetOf((Object[])new Coordinate[0]);
        this.comparator = VersionMapping.Companion.makeVersionComparator();
        for (DependencyStatus status : statuses) {
            this.current.add(status.getCoordinate());
            boolean bl = status.getUnresolved() == null ? this.latest.add(status.getLatestCoordinate()) : this.unresolved.add(status.getCoordinate());
        }
        this.organize();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TreeSet<Coordinate> getDowngrade() {
        return this.downgrade;
    }

    @NotNull
    public final TreeSet<Coordinate> getUpToDate() {
        return this.upToDate;
    }

    @NotNull
    public final TreeSet<Coordinate> getUpgrade() {
        return this.upgrade;
    }

    @NotNull
    public final TreeSet<Coordinate> getUndeclared() {
        return this.undeclared;
    }

    @NotNull
    public final TreeSet<Coordinate> getUnresolved() {
        return this.unresolved;
    }

    @NotNull
    public final TreeSet<Coordinate> getCurrent() {
        return this.current;
    }

    @NotNull
    public final TreeSet<Coordinate> getLatest() {
        return this.latest;
    }

    /*
     * WARNING - void declaration
     */
    private final void organize() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.latest;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Coordinate coordinate = (Coordinate)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Coordinate it = (Coordinate)element$iv$iv;
            Coordinate.Key key = it.getKey();
            boolean bl2 = false;
            Coordinate coordinate2 = it;
            map.put(key, coordinate2);
        }
        Map latestByKey = destination$iv$iv;
        Iterator<Coordinate> iterator = this.current.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Coordinate> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Coordinate coordinate;
            Coordinate latestCoordinate;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Coordinate coordinate3 = latestCoordinate = (Coordinate)latestByKey.get(coordinate.getKey());
            String version = coordinate3 != null ? coordinate3.getVersion() : null;
            Logger logger = this.project.getLogger();
            String string = version;
            if (string == null) {
                string = "unresolved";
            }
            logger.info("Comparing dependency (current: {}, latest: {})", (Object)coordinate, (Object)string);
            if (this.unresolved.contains(coordinate)) continue;
            if (Intrinsics.areEqual((Object)coordinate.getVersion(), (Object)"none")) {
                this.undeclared.add(coordinate);
                continue;
            }
            int result = this.comparator.compare(coordinate.getVersion(), version);
            boolean bl = result <= -1 ? this.upgrade.add(coordinate) : (result == 0 ? this.upToDate.add(coordinate) : this.downgrade.add(coordinate));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/github/benmanes/gradle/versions/updates/VersionMapping$Companion;", "", "<init>", "()V", "makeVersionComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final Comparator<String> makeVersionComparator() {
            Comparator baseComparator = new DefaultVersionComparator().asVersionComparator();
            VersionParser versionParser = new VersionParser();
            return (arg_0, arg_1) -> Companion.makeVersionComparator$lambda$0(baseComparator, versionParser, arg_0, arg_1);
        }

        private static final int makeVersionComparator$lambda$0(Comparator $baseComparator, VersionParser $versionParser, String string1, String string2) {
            return $baseComparator.compare($versionParser.transform(string1), $versionParser.transform(string2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

