/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions;

import com.github.benmanes.gradle.versions.updates.DependencyUpdatesTask;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/github/benmanes/gradle/versions/VersionsPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "requireMinimumGradleVersion", "requireSupportedSaxParser", "gradle-versions-plugin"})
public final class VersionsPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.requireMinimumGradleVersion();
        this.requireSupportedSaxParser();
        TaskContainer tasks = project.getTasks();
        if (!tasks.getNames().contains("dependencyUpdates")) {
            tasks.register("dependencyUpdates", DependencyUpdatesTask.class);
        }
    }

    private final void requireMinimumGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0) {
            throw new GradleException("Gradle 5.0 or greater is required to apply the com.github.ben-manes.versions plugin.");
        }
    }

    private final void requireSupportedSaxParser() {
        boolean isRestrictedInMajor;
        boolean isRestrictedInPatch = GradleVersion.current().compareTo(GradleVersion.version((String)"7.6.3")) >= 0 && GradleVersion.current().compareTo(GradleVersion.version((String)"8.0")) <= 0;
        boolean bl = isRestrictedInMajor = GradleVersion.current().compareTo(GradleVersion.version((String)"8.4")) >= 0;
        if (isRestrictedInPatch || isRestrictedInMajor) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.newSAXParser().setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            }
            catch (SAXException ex) {
                throw new GradleException("A plugin or custom build logic has included an insecure XML parser, which is not compatible for\ndependency resolution with this version of Gradle. You can work around this issue by specifying\nthe SAXParserFactory to use or by updating any plugin that depends on an old XML parser version.\n\nUse ./gradlew buildEnvironment to check your build's plugin dependencies.\n\nFor more details and a workaround see,\nhttps://docs.gradle.org/8.4/userguide/upgrading_version_8.html#changes_8.4\n");
            }
        }
    }
}

