/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jspecify.annotations.Nullable;

@Immutable
public class AccessEvent {
    private final long key;

    private AccessEvent(long key) {
        this.key = key;
    }

    public long key() {
        return this.key;
    }

    public Long longKey() {
        return LongInterner.boxed(this.key);
    }

    public int weight() {
        return 1;
    }

    public double hitPenalty() {
        return 0.0;
    }

    public double missPenalty() {
        return 0.0;
    }

    public boolean isPenaltyAware() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object o) {
        if (!(o instanceof AccessEvent)) return false;
        AccessEvent event = (AccessEvent)o;
        if (this.key() != event.key()) return false;
        if (this.weight() != event.weight()) return false;
        if (this.hitPenalty() != event.hitPenalty()) return false;
        if (this.missPenalty() != event.missPenalty()) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.weight(), this.missPenalty(), this.hitPenalty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key()).add("weight", this.weight()).add("hit penalty", this.hitPenalty()).add("miss penalty", this.missPenalty()).toString();
    }

    public static AccessEvent forKey(long key) {
        return new AccessEvent(key);
    }

    public static AccessEvent forKeyAndWeight(long key, int weight) {
        return new WeightedAccessEvent(key, weight);
    }

    public static AccessEvent forKeyAndPenalties(long key, double hitPenalty, double missPenalty) {
        return new PenaltiesAccessEvent(key, hitPenalty, missPenalty);
    }

    private static final class LongInterner {
        static final AtomicReferenceArray<Long> cache = new AtomicReferenceArray(0x100000);
        static final int MASK = cache.length() - 1;

        private LongInterner() {
        }

        static Long boxed(long l) {
            int index = Long.hashCode(l) & MASK;
            Long boxed = cache.get(index);
            if (boxed == null || boxed != l) {
                boxed = l;
                cache.set(index, boxed);
            }
            return boxed;
        }
    }

    private static final class WeightedAccessEvent
    extends AccessEvent {
        private final int weight;

        WeightedAccessEvent(long key, int weight) {
            super(key);
            this.weight = weight;
            Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0);
        }

        @Override
        public int weight() {
            return this.weight;
        }
    }

    private static final class PenaltiesAccessEvent
    extends AccessEvent {
        private final double missPenalty;
        private final double hitPenalty;

        PenaltiesAccessEvent(long key, double hitPenalty, double missPenalty) {
            super(key);
            this.hitPenalty = hitPenalty;
            this.missPenalty = missPenalty;
            Preconditions.checkArgument((hitPenalty >= 0.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((missPenalty >= hitPenalty ? 1 : 0) != 0);
        }

        @Override
        public double missPenalty() {
            return this.missPenalty;
        }

        @Override
        public double hitPenalty() {
            return this.hitPenalty;
        }

        @Override
        public boolean isPenaltyAware() {
            return true;
        }
    }
}

