/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin64;

import com.google.common.base.Preconditions;
import java.util.Random;

final class CountMin64 {
    static final long PRIME_MODULUS = Integer.MAX_VALUE;
    final long[][] table;
    final long[] hashA;
    final int depth;
    final int width;

    public CountMin64(double eps, double confidence, int seed) {
        this.width = (int)Math.ceil(2.0 / eps);
        this.depth = (int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0));
        this.table = new long[this.depth][this.width];
        this.hashA = new long[this.depth];
        Preconditions.checkState((this.width > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.depth > 0 ? 1 : 0) != 0);
        Random random = new Random(seed);
        for (int i = 0; i < this.depth; ++i) {
            this.hashA[i] = random.nextInt(Integer.MAX_VALUE);
        }
    }

    public long estimateCount(long item) {
        long count = Long.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            count = Math.min(count, this.table[i][this.hash(item, i)]);
        }
        return count;
    }

    public void add(long item, long count, boolean conservative) {
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"Negative increments not implemented");
        if (conservative) {
            this.conservativeAdd(item, count);
        } else {
            this.add(item, count);
        }
    }

    private void add(long item, long count) {
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = this.hash(item, i);
            lArray[n] = lArray[n] + count;
        }
    }

    private void conservativeAdd(long item, long count) {
        int i;
        int[] buckets = new int[this.depth];
        for (int i2 = 0; i2 < this.depth; ++i2) {
            buckets[i2] = this.hash(item, i2);
        }
        long min = this.table[0][buckets[0]];
        for (i = 1; i < this.depth; ++i) {
            min = Math.min(min, this.table[i][buckets[i]]);
        }
        for (i = 0; i < this.depth; ++i) {
            long newVal;
            this.table[i][buckets[i]] = newVal = Math.max(this.table[i][buckets[i]], min + count);
        }
    }

    private int hash(long item, int i) {
        long hash = this.hashA[i] * item;
        hash += hash >> 32;
        return (int)(hash &= Integer.MAX_VALUE) % this.width;
    }
}

