/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.enterprise;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.function.Predicate;
import java.util.stream.LongStream;

public final class EnterpriseTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    private static final int BLOCK_SIZE = 4096;

    public EnterpriseTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() {
        return this.lines().dropWhile(new SkipHeader()).filter(line -> line.stripLeading().startsWith("DiskRead,")).map(line -> line.split(",", 8)).flatMapToLong(line -> {
            long byteOffset = Long.parseLong(line[5].strip().substring(2), 16);
            int size = Integer.parseInt(line[6].strip().substring(2), 16);
            long startBlock = byteOffset / 4096L;
            int sequence = IntMath.divide((int)size, (int)4096, (RoundingMode)RoundingMode.UP);
            return LongStream.range(startBlock, startBlock + (long)sequence);
        });
    }

    private static final class SkipHeader
    implements Predicate<String> {
        private boolean isHeader;

        private SkipHeader() {
        }

        @Override
        public boolean test(String line) {
            if (line.equals("BeginHeader")) {
                this.isHeader = true;
            } else if (line.equals("EndHeader")) {
                this.isHeader = false;
            }
            return this.isHeader;
        }
    }
}

