/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public final class CombinedCsvReport
implements Runnable {
    private static final String POLICY_KEY = "Policy";
    private final ImmutableSortedMap<Long, Path> inputFiles;
    private final Path outputFile;
    private final String metric;

    public CombinedCsvReport(ImmutableMap<Long, Path> inputFiles, String metric, Path outputFile) {
        this.inputFiles = ImmutableSortedMap.copyOf(inputFiles);
        this.outputFile = Objects.requireNonNull(outputFile);
        this.metric = metric.replace('_', ' ');
    }

    @Override
    public void run() {
        this.writeReport(this.tabulate());
    }

    private Map<Label, String> tabulate() {
        TreeMap<Label, String> results = new TreeMap<Label, String>();
        this.inputFiles.forEach((maximumSize, path) -> {
            List records = CombinedCsvReport.newCsvParser().parseAllRecords(path.toFile());
            for (Record record : records) {
                Label label = new Label(record.getString(POLICY_KEY), (long)maximumSize);
                results.put(label, (String)record.getValue(this.metric, (Object)""));
            }
        });
        return results;
    }

    private void writeReport(Map<Label, String> table) {
        ImmutableList policies = (ImmutableList)CombinedCsvReport.newCsvParser().parseAllRecords(((Path)this.inputFiles.values().iterator().next()).toFile()).stream().map(record -> record.getString(POLICY_KEY)).collect(ImmutableList.toImmutableList());
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        String[] headers = (String[])Stream.concat(Stream.of(POLICY_KEY), this.inputFiles.keySet().stream().map(formatter::format)).toArray(String[]::new);
        CsvWriter writer = this.newWriter(headers);
        for (String policy : policies) {
            writer.addValue(POLICY_KEY, (Object)policy);
            for (Long size : this.inputFiles.keySet()) {
                writer.addValue(formatter.format(size), (Object)table.get(new Label(policy, size)));
            }
            writer.writeValuesToRow();
        }
        writer.close();
    }

    private static CsvParser newCsvParser() {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setHeaderExtractionEnabled(true);
        return new CsvParser(settings);
    }

    private CsvWriter newWriter(String[] headers) {
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.setHeaderWritingEnabled(true);
        settings.setHeaders(headers);
        return new CsvWriter(this.outputFile.toFile(), settings);
    }

    private static final class Label
    implements Comparable<Label> {
        final String policy;
        final long size;

        Label(String policy, long size) {
            this.policy = Objects.requireNonNull(policy);
            this.size = size;
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof Label && this.compareTo((Label)o) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.policy, this.size);
        }

        @Override
        public int compareTo(Label label) {
            int ordering = this.policy.compareTo(label.policy);
            return ordering == 0 ? Long.compare(this.size, label.size) : ordering;
        }
    }
}

