/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.EvictionPolicy;
import com.trivago.triava.tcache.TCacheFactory;
import com.typesafe.config.Config;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="product.TCache")
public final class TCachePolicy
implements Policy.KeyOnlyPolicy {
    private final Cache<Long, Boolean> cache;
    private final PolicyStats policyStats;
    private final TCacheFactory factory;

    public TCachePolicy(TCacheSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        this.factory = new TCacheFactory();
        this.cache = this.factory.builder().setMaxElements(Math.toIntExact(settings.maximumSize())).setEvictionPolicy(policy.type).setStatistics(true).build();
    }

    public static Set<Policy> policies(Config config) {
        TCacheSettings settings = new TCacheSettings(config);
        return settings.policy().stream().map(policy -> new TCachePolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            this.cache.put((Object)key, (Object)Boolean.TRUE);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.factory.close();
        this.policyStats.addEvictions(this.cache.statistics().getEvictionCount());
    }

    public static final class TCacheSettings
    extends BasicSettings {
        public TCacheSettings(Config config) {
            super(config);
        }

        public Set<Eviction> policy() {
            EnumSet<Eviction> policies = EnumSet.noneOf(Eviction.class);
            for (String policy : this.config().getStringList("tcache.policy")) {
                if (policy.equalsIgnoreCase("lru")) {
                    policies.add(Eviction.LRU);
                    continue;
                }
                if (policy.equalsIgnoreCase("lfu")) {
                    policies.add(Eviction.LFU);
                    continue;
                }
                throw new IllegalArgumentException("Unknown policy: " + policy);
            }
            return policies;
        }
    }

    public static enum Eviction {
        LRU(EvictionPolicy.LRU),
        LFU(EvictionPolicy.LFU);

        final EvictionPolicy type;

        private Eviction(EvictionPolicy type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

