/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.greedy_dual;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="greedy-dual.Camp", characteristics={Policy.Characteristic.WEIGHTED})
public final class CampPolicy
implements Policy {
    private final Int2ObjectMap<Sentinel> sentinelMapping;
    private final NavigableSet<Sentinel> priorityQueue;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final long maximumSize;
    private final int precision;
    private final int bitMask;
    private long requestCount;
    private int size;

    public CampPolicy(Config config) {
        CampSettings settings = new CampSettings(config);
        this.requestCount = 0L;
        this.priorityQueue = new TreeSet<Sentinel>();
        this.precision = settings.precision();
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.sentinelMapping = new Int2ObjectOpenHashMap();
        this.bitMask = Integer.MAX_VALUE >> 31 - this.precision;
    }

    @Override
    public void record(AccessEvent event) {
        Node node = (Node)this.data.get(event.key());
        ++this.requestCount;
        if (node == null) {
            this.policyStats.recordWeightedMiss(event.weight());
            this.onMiss(event);
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            this.onHit(node);
            this.size += event.weight() - node.weight;
            node.weight = event.weight();
            if ((long)this.size > this.maximumSize) {
                this.evict();
            }
        }
    }

    private void onHit(Node node) {
        node.moveToTail();
        if (this.priorityQueue.size() > 1) {
            Sentinel sentinel = (Sentinel)this.sentinelMapping.get(node.cost);
            Preconditions.checkState((boolean)this.priorityQueue.remove(sentinel), (String)"cost %s not found in priority queue", (Object)sentinel);
            sentinel.priority = ((Sentinel)this.priorityQueue.first()).priority + sentinel.cost;
            sentinel.lastRequest = this.requestCount;
            this.priorityQueue.add(sentinel);
        }
    }

    private int roundedCost(AccessEvent event) {
        double penalty = event.isPenaltyAware() ? event.missPenalty() : 1.0;
        int cost = (int)(penalty / (double)event.weight());
        int msbIndex = 32 - Integer.numberOfLeadingZeros(cost);
        int roundMask = msbIndex <= this.precision ? Integer.MAX_VALUE : this.bitMask << msbIndex - this.precision;
        return cost & roundMask;
    }

    private void onMiss(AccessEvent event) {
        if ((long)event.weight() > this.maximumSize) {
            this.policyStats.recordEviction();
            return;
        }
        this.size += event.weight();
        while ((long)this.size > this.maximumSize) {
            this.evict();
        }
        int roundCost = this.roundedCost(event);
        int priority = this.priorityQueue.isEmpty() ? roundCost : ((Sentinel)this.priorityQueue.first()).priority + roundCost;
        Sentinel sentinel = (Sentinel)this.sentinelMapping.computeIfAbsent(roundCost, cost -> {
            Sentinel head = new Sentinel(roundCost);
            head.lastRequest = this.requestCount;
            head.priority = priority;
            this.priorityQueue.add(head);
            return head;
        });
        Node node = new Node(event.key(), event.weight(), sentinel);
        node.cost = roundCost;
        sentinel.appendToTail(node);
        this.data.put(node.key, (Object)node);
    }

    private void evict() {
        Sentinel sentinel = (Sentinel)this.priorityQueue.first();
        Node victim = Objects.requireNonNull(sentinel.next);
        this.data.remove(victim.key);
        this.size -= victim.weight;
        victim.remove();
        if (sentinel.isEmpty()) {
            this.sentinelMapping.remove(sentinel.cost);
            this.priorityQueue.remove(sentinel);
        }
        this.policyStats.recordEviction();
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState(((long)this.size <= this.maximumSize ? 1 : 0) != 0, (String)"%s > %s", (int)this.size, (long)this.maximumSize);
        long weightedSize = this.data.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((weightedSize == (long)this.size ? 1 : 0) != 0, (String)"%s != %s", (long)weightedSize, (int)this.size);
        Preconditions.checkState((this.priorityQueue.size() == this.sentinelMapping.size() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.priorityQueue.containsAll((Collection<?>)this.sentinelMapping.values()));
    }

    private static final class CampSettings
    extends BasicSettings {
        public CampSettings(Config config) {
            super(config);
        }

        public int precision() {
            return this.config().getInt("camp.precision");
        }
    }

    private static class Node {
        final long key;
        @Nullable Sentinel sentinel;
        @Nullable Node prev;
        @Nullable Node next;
        int weight;
        int cost;

        public Node(long key) {
            this.key = key;
        }

        public Node(long key, int weight, Sentinel sentinel) {
            this.sentinel = sentinel;
            this.weight = weight;
            this.key = key;
        }

        public void remove() {
            Preconditions.checkState((!(this instanceof Sentinel) ? 1 : 0) != 0);
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public void moveToTail() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = Objects.requireNonNull(this.sentinel);
            this.prev = Objects.requireNonNull(this.sentinel.prev);
            this.sentinel.prev = this;
            this.prev.next = this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("weight", this.weight).toString();
        }
    }

    private static final class Sentinel
    extends Node
    implements Comparable<Sentinel> {
        long lastRequest;
        int priority;

        public Sentinel(int cost) {
            super(Long.MIN_VALUE);
            this.cost = cost;
            this.prev = this.next = this;
        }

        public boolean isEmpty() {
            return this.next == this;
        }

        public void appendToTail(Node node) {
            Node tail = Objects.requireNonNull(this.prev);
            this.prev = node;
            tail.next = node;
            node.next = this;
            node.prev = tail;
        }

        @Override
        public int compareTo(Sentinel sentinel) {
            if (this.priority != sentinel.priority) {
                return Integer.compare(this.priority, sentinel.priority);
            }
            return Long.signum(sentinel.lastRequest - this.lastRequest);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sentinel)) {
                return false;
            }
            Sentinel sentinel = (Sentinel)o;
            return this.cost == sentinel.cost && this.priority == sentinel.priority;
        }

        public int hashCode() {
            return Objects.hash(this.cost, this.priority);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cost", this.cost).add("priority", this.priority).toString();
        }
    }
}

