/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.wikipedia;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.wikipedia.AutoValue_WikipediaTraceReader_Replacement;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.util.Objects;
import java.util.stream.LongStream;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class WikipediaTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    private static final ImmutableList<String> CONTAINS_FILTER = ImmutableList.of((Object)"?search=", (Object)"&search=", (Object)"User+talk", (Object)"User_talk", (Object)"User:", (Object)"Talk:", (Object)"&diff=", (Object)"&action=rollback", (Object)"Special:Watchlist");
    private static final ImmutableList<String> STARTS_WITH_FILTER = ImmutableList.of((Object)"wiki/Special:Search", (Object)"w/query.php", (Object)"wiki/Talk:", (Object)"wiki/Special:AutoLogin", (Object)"Special:UserLogin", (Object)"w/api.php", (Object)"error:");
    private static final ImmutableList<Replacement> REPLACEMENTS = ImmutableList.of((Object)Replacement.of("%2F", "/"), (Object)Replacement.of("%20", " "), (Object)Replacement.of("&amp;", "&"), (Object)Replacement.of("%3A", ":"));

    public WikipediaTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() {
        return this.lines().map(WikipediaTraceReader::parseRequest).filter(Objects::nonNull).mapToLong(path -> Hashing.murmur3_128().hashUnencodedChars((CharSequence)path).asLong());
    }

    private static @Nullable String parseRequest(String line) {
        String path;
        if (!WikipediaTraceReader.isRead(line)) {
            return null;
        }
        String url = WikipediaTraceReader.getRequestUrl(line);
        if (url.length() > 12 && WikipediaTraceReader.isAllowed(path = WikipediaTraceReader.getPath(url))) {
            return path;
        }
        return null;
    }

    private static boolean isRead(String line) {
        return line.charAt(line.length() - 1) == '-';
    }

    private static String getRequestUrl(String line) {
        int end = line.length() - 2;
        while (line.charAt(end) != ' ') {
            --end;
        }
        int start = end - 1;
        while (line.charAt(start) != ' ') {
            --start;
        }
        return line.substring(start + 1, end);
    }

    private static String getPath(String url) {
        int index = url.indexOf(47, 7);
        if (index == -1) {
            return url;
        }
        String cleansed = url.substring(index + 1);
        for (Replacement replacement : REPLACEMENTS) {
            cleansed = StringUtils.replace((String)cleansed, (String)replacement.search(), (String)replacement.replace());
        }
        return cleansed;
    }

    public static boolean isAllowed(String path) {
        for (String filter : STARTS_WITH_FILTER) {
            if (!path.startsWith(filter)) continue;
            return false;
        }
        for (String filter : CONTAINS_FILTER) {
            if (!path.contains(filter)) continue;
            return false;
        }
        return true;
    }

    @AutoValue
    static abstract class Replacement {
        Replacement() {
        }

        abstract String search();

        abstract String replace();

        static Replacement of(String search, String replace) {
            return new AutoValue_WikipediaTraceReader_Replacement(search, replace);
        }
    }
}

