/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.ChildFailed;
import akka.actor.typed.MailboxSelector;
import akka.actor.typed.Props;
import akka.actor.typed.Terminated;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.japi.function.Function;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;

public final class Simulator
extends AbstractBehavior<Command> {
    private final List<ActorRef<PolicyActor.Command>> policies;
    private final TraceReader traceReader;
    private final BasicSettings settings;
    private final Stopwatch stopwatch;
    private final Reporter reporter;

    public Simulator(ActorContext<Command> context, BasicSettings settings) {
        super(context);
        this.settings = settings;
        this.policies = new ArrayList<ActorRef<PolicyActor.Command>>();
        this.stopwatch = Stopwatch.createUnstarted();
        this.traceReader = Simulator.makeTraceReader(settings);
        this.reporter = settings.report().format().create(settings.config(), this.traceReader.characteristics());
    }

    public static Behavior<Command> create() {
        return Behaviors.setup((Function & Serializable)context -> {
            Config config = context.getSystem().settings().config().getConfig("caffeine.simulator");
            return new Simulator((ActorContext<Command>)context, new BasicSettings(config));
        });
    }

    public Receive<Command> createReceive() {
        return this.newReceiveBuilder().onMessage(Broadcast.class, (Function & Serializable)msg -> this.broadcast()).onMessage(Stats.class, (Function & Serializable)msg -> this.reportStats(msg.policyStats)).onSignal(ChildFailed.class, (Function & Serializable)msg -> Behaviors.stopped()).onSignal(Terminated.class, (Function & Serializable)msg -> Behaviors.same()).build();
    }

    private Behavior<Command> broadcast() {
        this.spawnPolicyActors();
        if (this.policies.isEmpty()) {
            System.err.println("No active policies in the current configuration");
            return Behaviors.stopped();
        }
        this.stopwatch.start();
        long skip = this.settings.trace().skip();
        long limit = this.settings.trace().limit();
        int batchSize = this.settings.batchSize();
        try (Stream<AccessEvent> events = this.traceReader.events().skip(skip).limit(limit);){
            MutableObject batch = new MutableObject(new ArrayList(batchSize));
            events.forEach(event -> {
                ((ArrayList)batch.getValue()).add(event);
                if (((ArrayList)batch.getValue()).size() == batchSize) {
                    this.route(new PolicyActor.AccessEvents((List)batch.getValue()));
                    batch.setValue(new ArrayList(batchSize));
                }
            });
            this.route(new PolicyActor.AccessEvents((List)batch.getValue()));
            this.route(new PolicyActor.Finished());
            Simulator simulator = this;
            return simulator;
        }
    }

    private void route(PolicyActor.Command message) {
        for (ActorRef<PolicyActor.Command> policy : this.policies) {
            policy.tell((Object)message);
        }
    }

    private static TraceReader makeTraceReader(BasicSettings settings) {
        if (settings.trace().isSynthetic()) {
            return Synthetic.generate(settings.trace());
        }
        List<String> filePaths = settings.trace().traceFiles().paths();
        TraceFormat format = settings.trace().traceFiles().format();
        return format.readFiles(filePaths);
    }

    private void spawnPolicyActors() {
        Registry registry = new Registry(this.settings, this.traceReader.characteristics());
        MailboxSelector mailbox = MailboxSelector.fromConfig((String)"caffeine.simulator.mailbox");
        for (Policy policy : registry.policies()) {
            String name = policy.getClass().getSimpleName() + "@" + System.identityHashCode(policy);
            Behavior<PolicyActor.Command> actor = PolicyActor.create((ActorRef<Command>)this.getContext().getSelf(), policy);
            ActorRef actorRef = this.getContext().spawn(actor, name, (Props)mailbox);
            this.getContext().watch(actorRef);
            this.policies.add((ActorRef<PolicyActor.Command>)actorRef);
        }
    }

    private Behavior<Command> reportStats(PolicyStats stats) throws IOException {
        this.reporter.add(stats);
        if (this.reporter.stats().size() == this.policies.size()) {
            this.reporter.print();
            System.out.println("Executed in " + this.stopwatch);
            return Behaviors.stopped();
        }
        return this;
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        ActorSystem simulator = ActorSystem.create(Simulator.create(), (String)"Simulator");
        simulator.tell((Object)new Broadcast());
    }

    public static final class Stats
    extends Command {
        public final PolicyStats policyStats;

        public Stats(PolicyStats policyStats) {
            this.policyStats = Objects.requireNonNull(policyStats);
        }
    }

    private static final class Broadcast
    extends Command {
        private Broadcast() {
        }
    }

    public static abstract class Command {
        private Command() {
        }
    }
}

