/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public abstract class TextReporter
implements Reporter {
    private final Set<Policy.Characteristic> characteristics;
    private final List<PolicyStats> results;
    private final BasicSettings settings;
    private ImmutableSet<String> headers;
    private Metrics metrics;

    protected TextReporter(Config config, Set<Policy.Characteristic> characteristics) {
        this.characteristics = Objects.requireNonNull(characteristics);
        this.settings = new BasicSettings(config);
        this.results = new ArrayList<PolicyStats>();
    }

    @Override
    public void add(PolicyStats policyStats) {
        this.results.add(policyStats);
    }

    @Override
    public void print() throws IOException {
        this.results.sort(this.comparator());
        String report = this.assemble(this.results);
        String output = this.settings.report().output();
        if (output.equalsIgnoreCase("console")) {
            System.out.println(report);
        } else {
            Files.createDirectories(Path.of(output, new String[0]).getParent(), new FileAttribute[0]);
            Files.write(Path.of(output, new String[0]), report.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    @Override
    public Collection<PolicyStats> stats() {
        return this.results;
    }

    protected Set<String> headers() {
        if (this.headers == null) {
            ImmutableSet all = (ImmutableSet)this.results.stream().flatMap(policyStats -> policyStats.metrics().keySet().stream()).collect(ImmutableSet.toImmutableSet());
            ImmutableSet used = (ImmutableSet)this.results.stream().flatMap(policyStats -> policyStats.metrics().values().stream()).filter(metric -> {
                if (metric.characteristics().isEmpty()) return true;
                if (!metric.characteristics().stream().anyMatch(this.characteristics::contains)) return false;
                return true;
            }).filter(metric -> metric.required() || !this.metrics().format((PolicyStats.Metric)metric).isEmpty()).map(PolicyStats.Metric::name).collect(ImmutableSet.toImmutableSet());
            this.headers = ImmutableSet.copyOf((Collection)Sets.intersection((Set)all, (Set)used));
        }
        return this.headers;
    }

    protected Metrics metrics() {
        return this.metrics == null ? (this.metrics = this.newMetrics()) : this.metrics;
    }

    protected abstract Metrics newMetrics();

    protected abstract String assemble(List<PolicyStats> var1);

    private Comparator<PolicyStats> comparator() {
        String sortBy = this.results.stream().flatMap(policyStats -> policyStats.metrics().keySet().stream()).filter(header -> header.toLowerCase(Locale.US).equals(this.settings.report().sortBy().toLowerCase(Locale.US))).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown sort order: " + this.settings.report().sortBy()));
        Comparator<PolicyStats> comparator = this.metrics().comparator(sortBy);
        return this.settings.report().ascending() ? comparator : comparator.reversed();
    }
}

