/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.opt;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Set;

@Policy.PolicySpec(name="opt.Unbounded", characteristics={Policy.Characteristic.WEIGHTED})
public final class UnboundedPolicy
implements Policy {
    private final PolicyStats policyStats;
    private final LongOpenHashSet data;

    public UnboundedPolicy(Config config, Set<Policy.Characteristic> characteristics) {
        BasicSettings settings = new BasicSettings(config);
        int initialSize = characteristics.contains((Object)Policy.Characteristic.WEIGHTED) ? 16 : Ints.saturatedCast((long)settings.maximumSize());
        this.data = new LongOpenHashSet(initialSize);
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(AccessEvent event) {
        this.policyStats.recordOperation();
        if (this.data.add(event.key())) {
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
        }
    }
}

