/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin4;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.CountMin4;
import com.github.benmanes.caffeine.cache.simulator.membership.FilterType;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.typesafe.config.Config;
import javax.annotation.Nonnegative;

public final class PeriodicResetCountMin4
extends CountMin4 {
    static final long ONE_MASK = 0x1111111111111111L;
    final Membership doorkeeper;
    int additions;
    int period;

    public PeriodicResetCountMin4(Config config) {
        super(config);
        BasicSettings settings = new BasicSettings(config);
        BasicSettings.TinyLfuSettings.DoorkeeperSettings doorkeeperSettings = settings.tinyLfu().countMin4().periodic().doorkeeper();
        if (doorkeeperSettings.enabled()) {
            FilterType filterType = settings.membershipFilter();
            double expectedInsertionsMultiplier = doorkeeperSettings.expectedInsertionsMultiplier();
            long expectedInsertions = (long)(expectedInsertionsMultiplier * (double)settings.maximumSize());
            this.doorkeeper = filterType.create(expectedInsertions, doorkeeperSettings.fpp(), config);
        } else {
            this.doorkeeper = Membership.disabled();
        }
    }

    @Override
    protected void ensureCapacity(@Nonnegative long maximumSize) {
        super.ensureCapacity(maximumSize);
        int n = this.period = maximumSize == 0L ? 10 : 10 * this.table.length;
        if (this.period <= 0) {
            this.period = Integer.MAX_VALUE;
        }
    }

    @Override
    public int frequency(long e) {
        int count = super.frequency(e);
        if (this.doorkeeper.mightContain(e)) {
            ++count;
        }
        return count;
    }

    @Override
    public void increment(long e) {
        if (!this.doorkeeper.put(e)) {
            super.increment(e);
        }
    }

    @Override
    protected void tryReset(boolean added) {
        if (!added) {
            return;
        }
        ++this.additions;
        if (this.additions != this.period) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.additions = (this.additions >>> 1) - (count >>> 2);
        this.doorkeeper.clear();
    }
}

